/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Events.Game;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.Nullable;
import rudynakodach.github.io.webhookintegrations.Modules.MessageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageType;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class PlayerCountChangeListener
implements Listener {
    private final JavaPlugin plugin;
    @Nullable
    private BukkitRunnable currentRunnable;
    private int lastPlayerCountSent = 0;

    public PlayerCountChangeListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    private void update() {
        MessageConfiguration.Message message = MessageConfiguration.get().getMessage(MessageType.PLAYER_COUNT_CHANGED);
        if (!message.canAnnounce()) {
            return;
        }
        if (this.currentRunnable != null) {
            this.currentRunnable.cancel();
        }
        this.currentRunnable = new BukkitRunnable(){

            public void run() {
                if (this.isCancelled() || WebhookActions.getPlayerCount(PlayerCountChangeListener.this.plugin) == PlayerCountChangeListener.this.lastPlayerCountSent) {
                    return;
                }
                PlayerCountChangeListener.this.sendPlayerCount();
            }
        };
        int delay = MessageConfiguration.get().getYamlConfig().getInt("%s.timeout-delay".formatted(new Object[]{MessageType.PLAYER_COUNT_CHANGED}), 0);
        if (delay > 0) {
            this.currentRunnable.runTaskLaterAsynchronously((Plugin)this.plugin, (long)delay);
        } else {
            this.currentRunnable.runTaskAsynchronously((Plugin)this.plugin);
        }
    }

    private void sendPlayerCount() {
        MessageConfiguration.Message message = MessageConfiguration.get().getMessage(MessageType.PLAYER_COUNT_CHANGED);
        String json = message.getJson();
        int playerCount = WebhookActions.getPlayerCount(this.plugin);
        int playerCountChange = playerCount - this.lastPlayerCountSent;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sdf.setTimeZone(TimeZone.getTimeZone(this.plugin.getConfig().getString("timezone")));
        String serverMotd = PlainTextComponentSerializer.plainText().serialize(this.plugin.getServer().motd());
        json = json.replace("$motd$", serverMotd).replace("$playersOnline$", String.valueOf(playerCount)).replace("$oldPlayerCount$", String.valueOf(this.lastPlayerCountSent)).replace("$time$", new SimpleDateFormat(this.plugin.getConfig().getString("date-format", "HH:mm:ss")).format(new Date())).replace("$timestamp$", sdf.format(new Date())).replace("$playerCountChange$", (CharSequence)(playerCountChange > 0 ? "+" + playerCountChange : String.valueOf(playerCountChange)));
        this.lastPlayerCountSent = WebhookActions.getPlayerCount(this.plugin);
        if (this.plugin.getConfig().getBoolean("remove-color-coding", false)) {
            json = WebhookActions.removeColorCoding(this.plugin, json);
        }
        new WebhookActions(message.setJson(json)).setHeaders(MessageType.PLAYER_COUNT_CHANGED).SendSync();
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.update();
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        this.update();
    }
}

