/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Events.Game;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.Modules.MessageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageType;
import rudynakodach.github.io.webhookintegrations.Utils.Timeout.TimeoutManager;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class PlayerDeathListener
implements Listener {
    JavaPlugin plugin;

    public PlayerDeathListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerDeathEvent(PlayerDeathEvent event) {
        if (TimeoutManager.get().isTimedOut(event.getPlayer()) && this.plugin.getConfig().getBoolean("ignore-events-during-timeout", false)) {
            return;
        }
        String playerName = event.getEntity().getName();
        if (this.plugin.getConfig().getBoolean("preventUsernameMarkdownFormatting")) {
            playerName = WebhookActions.escapeMarkdown(event.getPlayer().getName());
        }
        String deathMessage = PlainTextComponentSerializer.plainText().serialize((Component)(event.deathMessage() == null ? Component.empty() : Objects.requireNonNull(event.deathMessage())));
        String newLevel = String.valueOf(event.getNewLevel());
        String newExp = String.valueOf(event.getNewExp());
        String oldLevel = String.valueOf(event.getEntity().getLevel());
        String oldExp = String.valueOf(event.getEntity().getTotalExperience());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sdf.setTimeZone(TimeZone.getTimeZone(this.plugin.getConfig().getString("timezone")));
        if (event.getEntity().getKiller() != null) {
            MessageConfiguration.Message message = MessageConfiguration.get().getMessage(MessageType.PLAYER_DEATH_KILLED);
            if (!message.canPlayerTrigger(event.getPlayer().getKiller())) {
                return;
            }
            String killerName = event.getEntity().getKiller().getName();
            if (this.plugin.getConfig().getBoolean("preventUsernameMarkdownFormatting")) {
                killerName = WebhookActions.escapeMarkdown(event.getEntity().getKiller().getName());
            }
            String json = message.getJson();
            json = json.replace("$playersOnline$", String.valueOf(WebhookActions.getPlayerCount(this.plugin))).replace("$timestamp$", sdf.format(new Date())).replace("$maxPlayers$", String.valueOf(this.plugin.getServer().getMaxPlayers())).replace("$time$", new SimpleDateFormat(this.plugin.getConfig().getString("date-format", "HH:mm:ss")).format(new Date())).replace("$victim$", playerName).replace("$rawVictim$", event.getPlayer().getName()).replace("$rawKiller$", event.getEntity().getKiller().getName()).replace("$killer$", killerName).replace("$deathMessage$", deathMessage).replace("$newLevel$", newLevel).replace("$newExp$", newExp).replace("$oldLevel$", oldLevel).replace("$oldExp$", oldExp);
            if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
                json = PlaceholderAPI.setRelationalPlaceholders((Player)event.getPlayer(), (Player)event.getEntity().getKiller(), (String)json);
            }
            new WebhookActions(message.setJson(json)).setHeaders(MessageType.PLAYER_DEATH_KILLED).SendAsync();
        } else {
            MessageConfiguration.Message message = MessageConfiguration.get().getMessage(MessageType.PLAYER_DEATH_NPC);
            if (!message.canPlayerTrigger(event.getPlayer())) {
                return;
            }
            String json = message.getJson();
            if (json == null) {
                return;
            }
            json = json.replace("$time$", new SimpleDateFormat(this.plugin.getConfig().getString("date-format", "HH:mm:ss")).format(new Date())).replace("$timestamp$", sdf.format(new Date())).replace("$player$", playerName).replace("$rawVictim$", event.getPlayer().getName()).replace("$deathMessage$", deathMessage).replace("$newLevel$", newLevel).replace("$newExp$", newExp).replace("$oldLevel$", oldLevel).replace("$oldExp$", oldExp);
            if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
                json = PlaceholderAPI.setPlaceholders((Player)event.getPlayer(), (String)json);
            }
            if (this.plugin.getConfig().getBoolean("remove-color-coding", false)) {
                json = WebhookActions.removeColorCoding(this.plugin, json);
            }
            new WebhookActions(message.setJson(json)).setHeaders(MessageType.PLAYER_DEATH_NPC).SendAsync();
        }
    }
}

