/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Events.Game;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.Modules.MessageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageType;
import rudynakodach.github.io.webhookintegrations.Utils.Timeout.TimeoutManager;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class PlayerKickListener
implements Listener {
    JavaPlugin plugin;

    public PlayerKickListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerKickedEvent(PlayerKickEvent event) {
        String reason;
        if (event.isCancelled()) {
            return;
        }
        MessageConfiguration.Message message = MessageConfiguration.get().getMessage(MessageType.PLAYER_KICK);
        if (!message.canPlayerTrigger(event.getPlayer())) {
            return;
        }
        if (TimeoutManager.get().isTimedOut(event.getPlayer()) && this.plugin.getConfig().getBoolean("ignore-events-during-timeout", false)) {
            return;
        }
        String playerName = event.getPlayer().getName();
        if (this.plugin.getConfig().getBoolean("preventUsernameMarkdownFormatting")) {
            playerName = WebhookActions.escapeMarkdown(event.getPlayer().getName());
        }
        if ((reason = PlainTextComponentSerializer.plainText().serialize(event.reason())).isEmpty()) {
            reason = "Unspecified reason.";
        }
        String json = message.getJson();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sdf.setTimeZone(TimeZone.getTimeZone(this.plugin.getConfig().getString("timezone")));
        json = json.replace("$playersOnline$", String.valueOf(WebhookActions.getPlayerCount(this.plugin))).replace("$timestamp$", sdf.format(new Date())).replace("$maxPlayers$", String.valueOf(this.plugin.getServer().getMaxPlayers())).replace("$uuid$", event.getPlayer().getUniqueId().toString()).replace("$player$", playerName).replace("$rawUsername$", event.getPlayer().getName()).replace("$reason$", reason).replace("$time$", new SimpleDateFormat(this.plugin.getConfig().getString("date-format", "HH:mm:ss")).format(new Date()));
        if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            json = PlaceholderAPI.setPlaceholders((Player)event.getPlayer(), (String)json);
        }
        if (this.plugin.getConfig().getBoolean("remove-color-coding", false)) {
            json = WebhookActions.removeColorCoding(this.plugin, json);
        }
        new WebhookActions(message.setJson(json)).setHeaders(MessageType.PLAYER_KICK).SendAsync();
    }
}

