/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Events.Game;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import rudynakodach.github.io.webhookintegrations.Modules.MessageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageType;
import rudynakodach.github.io.webhookintegrations.Utils.Timeout.TimeoutManager;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class PlayerQuitListener
implements Listener {
    JavaPlugin plugin;

    public PlayerQuitListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerQuitEvent(final PlayerQuitEvent event) {
        MessageConfiguration.Message message = MessageConfiguration.get().getMessage(MessageType.PLAYER_QUIT);
        if (!message.canPlayerTrigger(event.getPlayer())) {
            return;
        }
        if (TimeoutManager.get().isTimedOut(event.getPlayer()) && this.plugin.getConfig().getBoolean("ignore-events-during-timeout", false)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("send-quit-when-kicked", false) && event.getReason() == PlayerQuitEvent.QuitReason.KICKED) {
            return;
        }
        String json = message.getJson();
        String playerName = event.getPlayer().getName();
        if (this.plugin.getConfig().getBoolean("preventUsernameMarkdownFormatting")) {
            playerName = WebhookActions.escapeMarkdown(event.getPlayer().getName());
        }
        if (json == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sdf.setTimeZone(TimeZone.getTimeZone(this.plugin.getConfig().getString("timezone")));
        json = json.replace("$playersOnline$", String.valueOf(WebhookActions.getPlayerCount(this.plugin))).replace("$timestamp$", sdf.format(new Date())).replace("$maxPlayers$", String.valueOf(this.plugin.getServer().getMaxPlayers())).replace("$player$", playerName).replace("$rawUsername$", event.getPlayer().getName()).replace("$time$", new SimpleDateFormat(this.plugin.getConfig().getString("date-format", "HH:mm:ss")).format(new Date()));
        if (this.plugin.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            json = PlaceholderAPI.setPlaceholders((Player)event.getPlayer(), (String)json);
        }
        if (this.plugin.getConfig().getBoolean("remove-color-coding", false)) {
            json = WebhookActions.removeColorCoding(this.plugin, json);
        }
        final WebhookActions action = new WebhookActions(message.setJson(json)).setHeaders(MessageType.PLAYER_QUIT);
        int timeoutDelay = this.plugin.getConfig().getInt("timeout-delay", 0);
        if (timeoutDelay > 0 && !event.getPlayer().hasPermission("webhookintegrations.bypassTimeout")) {
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    if (!PlayerQuitListener.this.plugin.getServer().getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.joining()).contains(event.getPlayer().getName())) {
                        action.SendAsync();
                    }
                }
            };
            TimeoutManager.get().timeout(event.getPlayer(), runnable);
        } else {
            action.SendAsync();
        }
    }
}

