/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Events.Game;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.Modules.MessageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageType;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class ServerStartListener
implements Listener {
    private final JavaPlugin plugin;

    public ServerStartListener(JavaPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onServerLoad(ServerLoadEvent event) {
        MessageConfiguration.Message message = MessageConfiguration.get().getMessage(MessageType.SERVER_START);
        if (!message.canAnnounce()) {
            return;
        }
        if (event.getType() != ServerLoadEvent.LoadType.STARTUP) {
            return;
        }
        String json = message.getJson();
        String serverIp = this.plugin.getServer().getIp();
        int slots = this.plugin.getServer().getMaxPlayers();
        String serverMotd = PlainTextComponentSerializer.plainText().serialize(this.plugin.getServer().motd());
        String serverName = this.plugin.getServer().getName();
        String serverVersion = this.plugin.getServer().getVersion();
        Boolean isOnlineMode = this.plugin.getServer().getOnlineMode();
        int playersOnline = WebhookActions.getPlayerCount(this.plugin);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sdf.setTimeZone(TimeZone.getTimeZone(this.plugin.getConfig().getString("timezone")));
        json = json.replace("$serverIp$", serverIp).replace("$timestamp$", sdf.format(new Date())).replace("$time$", new SimpleDateFormat(this.plugin.getConfig().getString("date-format", "HH:mm:ss")).format(new Date())).replace("$maxPlayers$", String.valueOf(slots)).replace("$serverMotd$", serverMotd).replace("$serverName$", serverName).replace("$serverVersion$", serverVersion).replace("$isOnlineMode$", String.valueOf(isOnlineMode)).replace("$playersOnline$", String.valueOf(playersOnline));
        if (this.plugin.getConfig().getBoolean("remove-color-coding", false)) {
            json = WebhookActions.removeColorCoding(this.plugin, json);
        }
        new WebhookActions(message.setJson(json)).setHeaders(MessageType.SERVER_START).SendSync();
    }
}

