/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Modules;

import java.io.File;
import java.util.HashMap;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;
import rudynakodach.github.io.webhookintegrations.Modules.MessageType;
import rudynakodach.github.io.webhookintegrations.Modules.WebhookIntegrationsModule;
import rudynakodach.github.io.webhookintegrations.WebhookActions;

public class MessageConfiguration
extends WebhookIntegrationsModule {
    private static MessageConfiguration instance;

    public static MessageConfiguration get() {
        return instance;
    }

    public MessageConfiguration(JavaPlugin plugin) {
        super("messages.yml", plugin);
        this.config = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "messages.yml"));
        instance = this;
    }

    public Message getMessage(MessageType type) {
        return new Message(this.plugin, type);
    }

    public boolean canAnnounce(String message) {
        return this.config.getBoolean(message + ".announce");
    }

    @Nullable
    public HashMap<String, String> getHeaders(MessageType type) {
        ConfigurationSection headersSection = this.config.getConfigurationSection("%s.headers".formatted(type.toString()));
        if (headersSection == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String key : headersSection.getKeys(false)) {
            headers.put(key, headersSection.get(key).toString());
        }
        return headers;
    }

    public static class Message {
        private final JavaPlugin plugin;
        private final String target;
        private final boolean announce;
        private String json;
        private final boolean usePermissions;
        private final MessageType type;

        public Message(JavaPlugin plugin, MessageType type) {
            this.plugin = plugin;
            this.type = type;
            ConfigurationSection sect = MessageConfiguration.get().getYamlConfig().getConfigurationSection(type.toString());
            if (sect == null) {
                throw new IllegalArgumentException("Provided section for event was null");
            }
            this.target = sect.getString("target", "main");
            this.announce = sect.getBoolean("announce", true);
            this.json = sect.getString("messageJson", "");
            this.usePermissions = sect.getBoolean("usePermissions", false);
        }

        public JavaPlugin getPlugin() {
            return this.plugin;
        }

        public String getTarget() {
            return this.target;
        }

        public Message setJson(String json) {
            this.json = json;
            return this;
        }

        public boolean canAnnounce() {
            return this.announce;
        }

        public String getJson() {
            return this.json;
        }

        public boolean usesPermissions() {
            return this.usePermissions;
        }

        public boolean canPlayerTrigger(Player p) {
            return this.announce && !WebhookActions.isPlayerVanished(this.plugin, p) && (!this.usePermissions || this.hasPlayerPermission(p, this.type));
        }

        private boolean hasPlayerPermission(Player p, MessageType type) {
            return p.hasPermission("webhookintegrations.events.%s".formatted(type.toString())) || p.hasPermission("webhookintegrations.events.all");
        }
    }
}

