/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Modules;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.Modules.WebhookIntegrationsModule;

public class TemplateConfiguration
extends WebhookIntegrationsModule {
    private static TemplateConfiguration instance;

    public static TemplateConfiguration get() {
        return instance;
    }

    public TemplateConfiguration(JavaPlugin plugin) {
        super("templates.yml", plugin);
        this.config = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "templates.yml"));
        instance = this;
    }

    public Template getTemplate(String templateName) {
        ConfigurationSection sect = this.config.getConfigurationSection("templates.%s".formatted(templateName));
        if (sect == null) {
            return null;
        }
        return new Template(this.plugin, sect);
    }

    public class Template {
        private final JavaPlugin plugin;
        public final boolean isUsingGlobals;
        private String json;
        public final List<String> params;
        private String target;

        private Template(JavaPlugin plugin, ConfigurationSection sect) {
            this.plugin = plugin;
            this.isUsingGlobals = sect.getBoolean("useGlobals");
            this.json = sect.getString("messageJson");
            this.params = sect.getStringList("params");
            this.target = sect.getString("defaultTarget");
        }

        public String getJson() {
            return this.json;
        }

        public Template setJson(String json) {
            this.json = json;
            return this;
        }

        public String getTarget() {
            return this.target;
        }

        public Template setTarget(String target) {
            this.target = target;
            return this;
        }

        public JavaPlugin getPlugin() {
            return this.plugin;
        }

        public static boolean templateExists(String name) {
            return TemplateConfiguration.get().config.getConfigurationSection("templates.%s".formatted(name)) != null;
        }

        public String compile(Map<String, String> args) {
            ConfigurationSection globalsSect;
            String compiledBody = this.json;
            for (Map.Entry<String, String> entry : args.entrySet()) {
                if (!this.params.contains(entry.getKey())) continue;
                compiledBody = compiledBody.replace("%%%s%%".formatted(entry.getKey()), entry.getValue());
            }
            if (this.isUsingGlobals && (globalsSect = TemplateConfiguration.this.config.getConfigurationSection("globals")) != null) {
                for (String globalEntry : globalsSect.getKeys(false)) {
                    compiledBody = compiledBody.replace("$%s$".formatted(globalEntry), Objects.requireNonNull(globalsSect.getString(globalEntry)));
                }
            }
            return compiledBody;
        }
    }
}

