/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Modules;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class WebhookIntegrationsModule {
    private static final List<WebhookIntegrationsModule> moduleInstances = new ArrayList<WebhookIntegrationsModule>();
    private final String configFileName;
    protected final JavaPlugin plugin;
    protected YamlConfiguration config;

    protected WebhookIntegrationsModule(String fileName, JavaPlugin plugin) {
        this.plugin = plugin;
        this.configFileName = fileName;
        moduleInstances.add(this);
    }

    public static void reloadAll() {
        for (WebhookIntegrationsModule module : moduleInstances) {
            module.reload();
        }
    }

    public final void reload() {
        this.plugin.getLogger().log(Level.INFO, "reloading %s".formatted(this.configFileName));
        this.config = YamlConfiguration.loadConfiguration((File)new File(this.plugin.getDataFolder(), this.configFileName));
    }

    public final void reset() {
        this.plugin.getLogger().log(Level.INFO, "resetting %s".formatted(this.configFileName));
        this.plugin.saveResource(this.configFileName, true);
        this.reload();
    }

    public static void resetAll() {
        for (WebhookIntegrationsModule module : moduleInstances) {
            module.reset();
        }
    }

    public YamlConfiguration getYamlConfig() {
        return this.config;
    }

    public boolean save() {
        try {
            this.config.save(Path.of(this.plugin.getDataFolder().toString(), this.configFileName).toString());
            return true;
        }
        catch (IOException err) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save config: " + err.getMessage());
            err.printStackTrace();
            return false;
        }
    }
}

