/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Utils.Config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.Modules.LanguageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageConfiguration;

public class ConfigBackupManager {
    private final JavaPlugin plugin;
    private final Path backups;
    private static ConfigBackupManager instance;

    public ConfigBackupManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.backups = Path.of(plugin.getDataFolder().getAbsolutePath(), "config-backups");
        instance = this;
    }

    public static ConfigBackupManager get() {
        return instance;
    }

    public boolean saveBackup(String name) {
        Path originalConfig = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config.yml");
        Path originalLanguage = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "lang.yml");
        Path originalMessages = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "messages.yml");
        Path backupConfig = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config-backups", name, "config.yml");
        Path backupLanguage = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config-backups", name, "lang.yml");
        Path backupMessages = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config-backups", name, "messages.yml");
        try {
            Files.createDirectory(Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config-backups", name), new FileAttribute[0]);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to make a backup folder: " + e.getMessage());
            return false;
        }
        try {
            Files.copy(originalConfig, backupConfig, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to make a copy of the config file: " + e.getMessage());
        }
        try {
            Files.copy(originalLanguage, backupLanguage, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to make a copy of the language configuration file: " + e.getMessage());
        }
        try {
            Files.copy(originalMessages, backupMessages, StandardCopyOption.COPY_ATTRIBUTES);
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to make a copy of JSON payloads file: " + e.getMessage());
        }
        return true;
    }

    public void loadBackup(String name) {
        Path originalConfig = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config.yml");
        Path originalLanguage = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "lang.yml");
        Path originalMessages = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "messages.yml");
        Path backupConfig = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config-backups", name, "config.yml");
        Path backupLanguage = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config-backups", name, "lang.yml");
        Path backupMessages = Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config-backups", name, "messages.yml");
        try {
            if (Files.exists(Path.of(this.plugin.getDataFolder().getAbsolutePath(), "config.yml"), new LinkOption[0])) {
                Files.copy(backupConfig, originalConfig, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(backupConfig, originalConfig, StandardCopyOption.COPY_ATTRIBUTES);
            }
            this.plugin.reloadConfig();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to replace the config file: " + e.getMessage());
        }
        try {
            if (Files.exists(Path.of(this.plugin.getDataFolder().getAbsolutePath(), "lang.yml"), new LinkOption[0])) {
                Files.copy(backupLanguage, originalLanguage, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(backupLanguage, originalLanguage, StandardCopyOption.COPY_ATTRIBUTES);
            }
            LanguageConfiguration.get().reload();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to replace the language file: " + e.getMessage());
        }
        try {
            if (Files.exists(Path.of(this.plugin.getDataFolder().getAbsolutePath(), "messages.yml"), new LinkOption[0])) {
                Files.copy(backupMessages, originalMessages, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(backupMessages, originalMessages, StandardCopyOption.COPY_ATTRIBUTES);
            }
            MessageConfiguration.get().reload();
        }
        catch (IOException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to replace the messages config file: " + e.getMessage());
        }
    }

    public boolean backupExists(String name) {
        return Files.exists(Path.of(this.backups.toAbsolutePath().toString(), name), new LinkOption[0]);
    }
}

