/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations.Utils.Timeout;

import java.util.HashMap;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimeoutManager {
    private static TimeoutManager instance;
    private final HashMap<String, @Nullable BukkitRunnable> activeTimeouts = new HashMap();
    private final JavaPlugin plugin;

    public TimeoutManager(JavaPlugin plugin) {
        this.plugin = plugin;
        instance = this;
    }

    @NotNull
    public static TimeoutManager get() {
        return instance;
    }

    public void timeout(final Player player, final @Nullable BukkitRunnable onEnd) {
        int timeoutDelay = this.plugin.getConfig().getInt("timeout-delay", 0);
        if (timeoutDelay > 0) {
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    if (this.isCancelled()) {
                        return;
                    }
                    TimeoutManager.this.activeTimeouts.remove(player.getName());
                    if (onEnd != null) {
                        onEnd.run();
                        this.cancel();
                    }
                }
            };
            if (this.activeTimeouts.get(player.getName()) != null) {
                this.activeTimeouts.get(player.getName()).cancel();
            }
            this.activeTimeouts.put(player.getName(), runnable);
            runnable.runTaskLaterAsynchronously((Plugin)this.plugin, (long)timeoutDelay);
        } else if (onEnd != null) {
            onEnd.run();
        }
    }

    public void timeout(Player player) {
        this.timeout(player, null);
    }

    public boolean isTimedOut(Player player) {
        return this.activeTimeouts.containsKey(player.getName());
    }
}

