/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rudynakodach.github.io.webhookintegrations.Modules.LanguageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageType;
import rudynakodach.github.io.webhookintegrations.Modules.TemplateConfiguration;

public class WebhookActions {
    private final JavaPlugin plugin;
    private final String target;
    private final String json;
    @Nullable
    private HashMap<String, String> headers = null;

    public WebhookActions(MessageConfiguration.Message message) {
        this.plugin = message.getPlugin();
        this.target = message.getTarget();
        this.json = message.getJson();
    }

    public WebhookActions(TemplateConfiguration.Template template) {
        this.plugin = template.getPlugin();
        this.target = template.getTarget();
        this.json = template.getJson();
    }

    public WebhookActions(JavaPlugin plugin, String target, String json) {
        this.plugin = plugin;
        this.target = target;
        this.json = json;
    }

    @NotNull
    public WebhookActions setHeaders(@Nullable HashMap<String, String> headers) {
        this.headers = headers;
        return this;
    }

    @NotNull
    public WebhookActions setHeaders(MessageType type) {
        this.headers = MessageConfiguration.get().getHeaders(type);
        return this;
    }

    public void SendAsync() {
        if (!this.plugin.getConfig().getBoolean("isEnabled")) {
            return;
        }
        if (!this.plugin.getConfig().contains("webhooks.%s".formatted(this.target))) {
            this.plugin.getLogger().log(Level.SEVERE, LanguageConfiguration.get().getLocalizedString("config.noWebhookUrl").formatted(this.target));
            return;
        }
        final String webhookUrl = this.plugin.getConfig().getString("webhooks.%s".formatted(this.target), "").trim();
        if (webhookUrl.isEmpty()) {
            this.plugin.getLogger().log(Level.WARNING, "Attempted to send a message to an empty webhook URL! Use /setUrl or disable the event in the config!");
            return;
        }
        new BukkitRunnable(){

            public void run() {
                WebhookActions.this.send(webhookUrl, WebhookActions.this.json);
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    public void SendSync() {
        if (!this.plugin.getConfig().getBoolean("isEnabled")) {
            return;
        }
        if (!this.plugin.getConfig().contains("webhooks.%s".formatted(this.target))) {
            this.plugin.getLogger().log(Level.SEVERE, LanguageConfiguration.get().getLocalizedString("config.noWebhookUrl"));
            return;
        }
        String webhookUrl = this.plugin.getConfig().getString("webhooks.%s".formatted(this.target), "").trim();
        if (webhookUrl.isEmpty()) {
            this.plugin.getLogger().log(Level.WARNING, "Attempted to send a message to an empty webhook URL! Use /setUrl or disable the event in the config!");
            return;
        }
        this.send(webhookUrl, this.json);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(@NotNull String webhookUrl, @NotNull String json) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(webhookUrl);
        StringEntity requestEntity = new StringEntity(json, ContentType.APPLICATION_JSON);
        httpPost.setEntity(requestEntity);
        if (this.headers != null) {
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                httpPost.addHeader(entry.getKey(), entry.getValue());
            }
        }
        try {
            CloseableHttpResponse ignored = httpClient.execute(httpPost);
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                httpClient.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isPlayerVanished(@NotNull JavaPlugin plugin, @NotNull Player player) {
        if (!plugin.getConfig().getBoolean("disableForVanishedPlayers")) {
            return false;
        }
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String escapeMarkdown(@NotNull String s) {
        return s.replaceAll("[*_~#\\-|\\[\\]()>`]", "\\\\\\\\$0");
    }

    @NotNull
    public static String removeColorCoding(@NotNull JavaPlugin plugin, @NotNull String text) {
        String regex = plugin.getConfig().getString("color-code-regex", "[&\u00a7][a-f0-9klmnorA-FKLMNOR]|&?#[0-9a-fA-F]{6}");
        return text.replaceAll(regex, "");
    }

    public static int getPlayerCount(@NotNull JavaPlugin plugin) {
        if (plugin.getConfig().getBoolean("exclude-vanished-from-player-count", false)) {
            return (int)plugin.getServer().getOnlinePlayers().stream().filter(p -> !WebhookActions.isPlayerVanished(plugin, p)).count();
        }
        return plugin.getServer().getOnlinePlayers().size();
    }
}

