/*
 * Decompiled with CFR 0.152.
 */
package rudynakodach.github.io.webhookintegrations;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.logging.Level;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import rudynakodach.github.io.webhookintegrations.AutoUpdater;
import rudynakodach.github.io.webhookintegrations.Commands.SendToWebhook;
import rudynakodach.github.io.webhookintegrations.Commands.SetWebhookURL;
import rudynakodach.github.io.webhookintegrations.Commands.WIActions;
import rudynakodach.github.io.webhookintegrations.Events.Actions.OpJoinEvent;
import rudynakodach.github.io.webhookintegrations.Events.Game.PlayerAdvancementCompletedListener;
import rudynakodach.github.io.webhookintegrations.Events.Game.PlayerChatListener;
import rudynakodach.github.io.webhookintegrations.Events.Game.PlayerCountChangeListener;
import rudynakodach.github.io.webhookintegrations.Events.Game.PlayerDeathListener;
import rudynakodach.github.io.webhookintegrations.Events.Game.PlayerJoinListener;
import rudynakodach.github.io.webhookintegrations.Events.Game.PlayerKickListener;
import rudynakodach.github.io.webhookintegrations.Events.Game.PlayerQuitListener;
import rudynakodach.github.io.webhookintegrations.Events.Game.ServerStartListener;
import rudynakodach.github.io.webhookintegrations.Modules.LanguageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageConfiguration;
import rudynakodach.github.io.webhookintegrations.Modules.MessageType;
import rudynakodach.github.io.webhookintegrations.Modules.TemplateConfiguration;
import rudynakodach.github.io.webhookintegrations.Utils.Config.ConfigBackupManager;
import rudynakodach.github.io.webhookintegrations.Utils.Config.ConfigMigrator;
import rudynakodach.github.io.webhookintegrations.Utils.Timeout.TimeoutManager;
import rudynakodach.github.io.webhookintegrations.WebhookActions;
import rudynakodach.github.io.webhookintegrations.bukkit.Metrics;
import rudynakodach.github.io.webhookintegrations.charts.SimplePie;

public final class WebhookIntegrations
extends JavaPlugin {
    public static boolean isLatest = true;
    public static final int currentBuildNumber = 67;
    public static final int currentConfigVersion = 4;

    public void onEnable() {
        String webhookUrl;
        boolean result;
        this.saveDefaultConfig();
        this.getLogger().log(Level.INFO, "Hello, World!");
        if (!new File(this.getDataFolder(), "messages.yml").exists()) {
            this.saveResource("messages.yml", false);
        }
        if (!new File(this.getDataFolder(), "lang.yml").exists()) {
            this.saveResource("lang.yml", false);
        }
        if (!new File(this.getDataFolder(), "templates.yml").exists()) {
            this.saveResource("templates.yml", false);
        }
        if (!new File(this.getDataFolder(), "config-backups").exists() && !(result = new File(this.getDataFolder(), "config-backups").mkdir())) {
            this.getLogger().log(Level.SEVERE, "Failed to create the config-backups directory.");
        }
        this.getLogger().log(Level.INFO, "Initializing language...");
        File langFile = new File(this.getDataFolder(), "lang.yml");
        Locale locale = Locale.getDefault();
        String selectedLanguage = locale.toString();
        YamlConfiguration languageConfig = YamlConfiguration.loadConfiguration((File)langFile);
        Object object = this.getConfig().get("language-override");
        if (object instanceof String) {
            String languageOverride = (String)object;
            if (!languageConfig.contains(selectedLanguage)) {
                this.getLogger().log(Level.INFO, "Language override is set to a language that doesn't exist. Falling back to en_US. For all available languages see lang.yml.");
                selectedLanguage = "en_US";
            } else {
                this.getLogger().log(Level.INFO, "Language override set to: " + languageOverride);
                selectedLanguage = languageOverride;
            }
        } else {
            if (!languageConfig.contains(selectedLanguage)) {
                selectedLanguage = "en_US";
            }
            this.getLogger().log(Level.INFO, "Hooked to " + selectedLanguage);
        }
        LanguageConfiguration language = new LanguageConfiguration(this, selectedLanguage, languageConfig);
        new TemplateConfiguration(this);
        new MessageConfiguration(this);
        new ConfigBackupManager(this);
        new TimeoutManager(this);
        int presentConfigVersion = this.getConfig().getInt("config-version", 1);
        if (4 > presentConfigVersion) {
            ConfigMigrator.migrate(this, presentConfigVersion, 4);
        }
        this.getLogger().log(Level.INFO, language.getLocalizedString("onStart.message"));
        if (this.getConfig().getBoolean("check-for-updates")) {
            this.getLogger().log(Level.INFO, language.getLocalizedString("update.checking"));
            try {
                AutoUpdater updater = new AutoUpdater(this);
                int receivedBuildNumber = updater.getLatestVersion();
                if (67 < receivedBuildNumber && receivedBuildNumber != -1) {
                    isLatest = false;
                    this.getLogger().log(Level.WARNING, "------------------------- WI -------------------------");
                    this.getLogger().log(Level.INFO, language.getLocalizedString("update.updateFound"));
                    this.getLogger().log(Level.WARNING, "------------------------------------------------------");
                    if (this.getConfig().getBoolean("auto-update")) {
                        isLatest = updater.Update();
                    }
                } else {
                    this.getLogger().log(Level.INFO, language.getLocalizedString("update.latest"));
                }
            }
            catch (IOException e) {
                this.getLogger().log(Level.WARNING, language.getLocalizedString("update.checkFailed") + e.getMessage());
            }
        }
        if ((webhookUrl = this.getConfig().getString("webhooks.main")) == null) {
            this.getLogger().log(Level.WARNING, language.getLocalizedString("onStart.webhookEmpty"));
        } else if (webhookUrl.equalsIgnoreCase("")) {
            this.getLogger().log(Level.WARNING, language.getLocalizedString("onStart.webhookEmpty"));
        }
        this.getLogger().log(Level.INFO, language.getLocalizedString("onStart.registeringEvents"));
        ServerStartListener serverStart = new ServerStartListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)serverStart, (Plugin)this);
        PlayerChatListener chatEvent = new PlayerChatListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)chatEvent, (Plugin)this);
        PlayerJoinListener onPlayerJoinEvent = new PlayerJoinListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)onPlayerJoinEvent, (Plugin)this);
        OpJoinEvent opJoinEvent = new OpJoinEvent(this);
        this.getServer().getPluginManager().registerEvents((Listener)opJoinEvent, (Plugin)this);
        PlayerQuitListener playerQuitEvent = new PlayerQuitListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerQuitEvent, (Plugin)this);
        PlayerKickListener playerKick = new PlayerKickListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerKick, (Plugin)this);
        PlayerAdvancementCompletedListener onPlayerAdvancement = new PlayerAdvancementCompletedListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)onPlayerAdvancement, (Plugin)this);
        PlayerDeathListener playerDeath = new PlayerDeathListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerDeath, (Plugin)this);
        PlayerCountChangeListener playerCountChangeListener = new PlayerCountChangeListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)playerCountChangeListener, (Plugin)this);
        this.getLogger().log(Level.INFO, language.getLocalizedString("onStart.eventRegisterFinish"));
        SetWebhookURL setWebhookUrlCommand = new SetWebhookURL(this);
        Objects.requireNonNull(this.getCommand("seturl")).setExecutor((CommandExecutor)setWebhookUrlCommand);
        SendToWebhook sendToWebhookCommand = new SendToWebhook(this.getConfig(), this);
        Objects.requireNonNull(this.getCommand("send")).setExecutor((CommandExecutor)sendToWebhookCommand);
        WIActions resetConfig = new WIActions(this);
        Objects.requireNonNull(this.getCommand("wi")).setExecutor((CommandExecutor)resetConfig);
        this.getLogger().log(Level.INFO, language.getLocalizedString("onStart.commandRegisterFinish"));
        Metrics metrics = new Metrics(this, 18509);
        metrics.addCustomChart(new SimplePie("url_state", () -> String.valueOf(!Objects.requireNonNullElse(this.getConfig().getString("webhookUrl"), "").isBlank())));
        metrics.addCustomChart(new SimplePie("lang_used", () -> LanguageConfiguration.get().getLocale()));
        metrics.addCustomChart(new SimplePie("timezone", () -> this.getConfig().getString("timezone")));
        metrics.addCustomChart(new SimplePie("remove-force-role-pings", () -> String.valueOf(this.getConfig().getBoolean("remove-force-role-pings"))));
        metrics.addCustomChart(new SimplePie("remove-force-pings", () -> String.valueOf(this.getConfig().getBoolean("remove-force-pings"))));
        metrics.addCustomChart(new SimplePie("remove-force-channel-pings", () -> String.valueOf(this.getConfig().getBoolean("remove-force-channel-pings"))));
    }

    public void onDisable() {
        if (Bukkit.isStopping()) {
            this.sendStopMessage();
        }
        this.getLogger().log(Level.INFO, "this is my final message");
        this.getLogger().log(Level.INFO, "goodb ye");
    }

    private void sendStopMessage() {
        MessageConfiguration.Message message = MessageConfiguration.get().getMessage(MessageType.SERVER_STOP);
        if (!message.canAnnounce()) {
            return;
        }
        String serverIp = this.getServer().getIp();
        int slots = this.getServer().getMaxPlayers();
        String serverMotd = PlainTextComponentSerializer.plainText().serialize(this.getServer().motd());
        String serverName = this.getServer().getName();
        String serverVersion = this.getServer().getVersion();
        Boolean isOnlineMode = this.getServer().getOnlineMode();
        int playersOnline = this.getServer().getOnlinePlayers().size();
        String json = message.getJson();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        sdf.setTimeZone(TimeZone.getTimeZone(this.getConfig().getString("timezone")));
        json = json.replace("$time$", new SimpleDateFormat(Objects.requireNonNullElse(this.getConfig().getString("date-format"), "")).format(new Date())).replace("$timestamp$", sdf.format(new Date())).replace("$serverIp$", serverIp).replace("$maxPlayers$", String.valueOf(slots)).replace("$serverMotd$", serverMotd).replace("$serverName$", serverName).replace("$serverVersion$", serverVersion).replace("$isOnlineMode$", String.valueOf(isOnlineMode)).replace("$playersOnline$", String.valueOf(playersOnline));
        new WebhookActions(message.setJson(json)).setHeaders(MessageType.SERVER_STOP).SendSync();
    }
}

