/*
 * Decompiled with CFR 0.152.
 */
package org.rayz.rayzWardrobe;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RayzWardrobe
extends JavaPlugin
implements Listener {
    private static final Map<String, Sound> SOUND_MAP = Map.of("BLOCK_CHEST_OPEN", Sound.BLOCK_CHEST_OPEN, "ENTITY_PLAYER_LEVELUP", Sound.ENTITY_PLAYER_LEVELUP, "ITEM_ARMOR_EQUIP_NETHERITE", Sound.ITEM_ARMOR_EQUIP_NETHERITE);
    private static final Map<String, Particle> PARTICLE_MAP = Map.of("CLOUD", Particle.CLOUD, "HEART", Particle.HEART, "FLAME", Particle.FLAME);
    private FileConfiguration config;
    private FileConfiguration messages;
    private File configFile;
    private File messagesFile;
    private final Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, String> renamingPlayers = new HashMap<UUID, String>();
    private final Map<UUID, Integer> renamingSlots = new HashMap<UUID, Integer>();
    private final Map<UUID, List<ArmorSet>> playerArmorSets = new HashMap<UUID, List<ArmorSet>>();
    private final Map<UUID, Integer> currentPages = new HashMap<UUID, Integer>();
    private final Map<UUID, Inventory> openInventories = new HashMap<UUID, Inventory>();
    private static final int MAX_PAGES = 8;
    private static final int SETS_PER_PAGE = 7;
    private static final Material[] SPECTRUM = new Material[]{Material.RED_STAINED_GLASS_PANE, Material.LIME_STAINED_GLASS_PANE, Material.BLUE_STAINED_GLASS_PANE, Material.PURPLE_STAINED_GLASS_PANE};

    public void onEnable() {
        this.createFiles();
        if (this.messages == null) {
            this.getLogger().severe("Disabling plugin - messages file could not be loaded!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.loadPlayerData();
        String version = this.getDescription().getVersion();
        String enableMsg = this.getMessage("console.enable", "&a[RayzWardrobe] &fEnabled! &b(v{version})").replace("{version}", version);
        this.getLogger().info(enableMsg);
    }

    public void onDisable() {
        this.savePlayerData();
        String disableMsg = this.getMessage("console.disable", "&c[RayzWardrobe] &fSaving all data...");
        this.getLogger().info(disableMsg);
    }

    private void createFiles() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.messagesFile = new File(this.getDataFolder(), "messages_en.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.saveResource("config.yml", false);
        }
        if (!this.messagesFile.exists()) {
            this.messagesFile.getParentFile().mkdirs();
            this.saveResource("messages_en.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        if (this.messages == null) {
            this.getLogger().severe("Failed to load messages file!");
        }
    }

    private void reloadFiles() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.loadMessages();
    }

    private void loadMessages() {
        try {
            if (this.messagesFile != null && this.messagesFile.exists()) {
                this.messages.load(this.messagesFile);
            } else {
                this.getLogger().warning("Messages file not found at: " + (this.messagesFile != null ? this.messagesFile.getPath() : "null"));
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load messages file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String getMessage(String path, String def) {
        return this.messages != null ? this.colorize(this.messages.getString(path, def)) : this.colorize(def);
    }

    private void loadPlayerData() {
        File dataFolder = new File(this.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
            return;
        }
        int count = 0;
        File[] playerFiles = dataFolder.listFiles();
        if (playerFiles != null) {
            for (File file : playerFiles) {
                if (!file.getName().endsWith(".yml")) continue;
                try {
                    String uuidStr = file.getName().replace(".yml", "");
                    UUID uuid = UUID.fromString(uuidStr);
                    YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)file);
                    ArrayList<ArmorSet> armorSets = new ArrayList<ArmorSet>();
                    Set keys = playerConfig.getKeys(false);
                    for (String key : keys) {
                        try {
                            int idx = Integer.parseInt(key);
                            String name = playerConfig.getString(key + ".name");
                            ItemStack[] armor = new ItemStack[4];
                            for (int i = 0; i < 4; ++i) {
                                armor[i] = playerConfig.getItemStack(key + ".armor." + i);
                            }
                            ArmorSet set = new ArmorSet((String)(name != null ? name : "Set #" + (idx + 1)), armor);
                            while (armorSets.size() <= idx) {
                                armorSets.add(null);
                            }
                            armorSets.set(idx, set);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    this.playerArmorSets.put(uuid, armorSets);
                    ++count;
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to load player data from " + file.getName() + ": " + e.getMessage());
                }
            }
        }
        String loadedMsg = this.getMessage("console.loaded-data", "&7Loaded data for &b{count} &7players").replace("{count}", String.valueOf(count));
        this.getLogger().info(loadedMsg);
    }

    private void savePlayerData() {
        File dataFolder = new File(this.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        int count = 0;
        for (Map.Entry<UUID, List<ArmorSet>> entry : this.playerArmorSets.entrySet()) {
            try {
                int i;
                File playerFile = new File(dataFolder, entry.getKey().toString() + ".yml");
                YamlConfiguration playerConfig = new YamlConfiguration();
                List<ArmorSet> armorSets = entry.getValue();
                int lastIndex = -1;
                for (i = armorSets.size() - 1; i >= 0; --i) {
                    if (armorSets.get(i) == null) continue;
                    lastIndex = i;
                    break;
                }
                for (i = 0; i <= lastIndex; ++i) {
                    ArmorSet set = armorSets.get(i);
                    if (set == null) continue;
                    playerConfig.set(i + ".name", (Object)set.getName());
                    for (int j = 0; j < 4; ++j) {
                        playerConfig.set(i + ".armor." + j, (Object)set.getArmor()[j]);
                    }
                }
                playerConfig.save(playerFile);
                ++count;
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to save data for player " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
            }
        }
        String savedMsg = this.getMessage("console.saved-data", "&7Saved data for &b{count} &7players").replace("{count}", String.valueOf(count));
        this.getLogger().info(savedMsg);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("wardrobe")) {
            long secondsLeft;
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.getMessage("errors.only-players", "&c\u2716 &7Only players can use &bRayzWardrobe&7!"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("rayzwardrobe.use")) {
                player.sendMessage(this.getMessage("errors.no-permission", "&c\u2716 &7You need &b{permission} &7permission!").replace("{permission}", "rayzwardrobe.use"));
                return true;
            }
            if (this.cooldowns.containsKey(player.getUniqueId()) && (secondsLeft = this.cooldowns.get(player.getUniqueId()) / 1000L + (long)this.config.getInt("settings.cooldown-seconds", 0) - System.currentTimeMillis() / 1000L) > 0L) {
                String cooldownMsg = this.getMessage("errors.cooldown", "&c\u23f3 &7Please wait &b{time}s &7before using again!").replace("{time}", String.valueOf(secondsLeft));
                player.sendMessage(cooldownMsg);
                return true;
            }
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            this.openWardrobeGUI(player, 1);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("rwreload")) {
            if (!sender.hasPermission("rayzwardrobe.reload")) {
                sender.sendMessage(this.getMessage("errors.no-permission", "&c\u2716 &7You need &b{permission} &7permission!").replace("{permission}", "rayzwardrobe.reload"));
                return true;
            }
            this.reloadFiles();
            this.savePlayerData();
            this.loadPlayerData();
            sender.sendMessage(this.colorize("&a[RayzWardrobe] &fConfiguration and messages reloaded successfully!"));
            this.getLogger().info("[RayzWardrobe] Configuration and messages reloaded");
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("rwcredits")) {
            sender.sendMessage(this.colorize("&6&l\u26a1 &bRayzWardrobe &7- &fPremium Armor Wardrobe"));
            sender.sendMessage(this.colorize("&7Created by: &bRayz"));
            sender.sendMessage(this.colorize("&7Version: &b" + this.getDescription().getVersion()));
            sender.sendMessage(this.colorize("&7Website: &bhttps://rayzdev.com"));
            sender.sendMessage(this.colorize("&7Discord: &bhttps://discord.gg/rayzdev"));
            sender.sendMessage(this.colorize("&7SpigotMC: &bhttps://www.spigotmc.org/resources/rayzwardrobe"));
            sender.sendMessage(this.colorize("&7Thank you for using my plugin!"));
            return true;
        }
        return false;
    }

    private void openWardrobeGUI(Player player, int requestedPage) {
        if (requestedPage > 1 && !player.hasPermission("rayzwardrobe.use.page" + requestedPage)) {
            player.sendMessage(this.getMessage("errors.no-page-permission", "&c\u2716 &7You don't have permission to access page &b{page}&7!").replace("{page}", String.valueOf(requestedPage)));
            return;
        }
        int page = Math.max(1, Math.min(requestedPage, 8));
        this.currentPages.put(player.getUniqueId(), page);
        List armorSets = this.playerArmorSets.getOrDefault(player.getUniqueId(), new ArrayList());
        int totalPages = 8;
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)this.getMessage("gui.title", "&6&l\u26a1 &bRayz&3Wardrobe &8| &7Page {page}/{total}").replace("{page}", String.valueOf(page)).replace("{total}", String.valueOf(totalPages)));
        ItemStack background = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta bgMeta = background.getItemMeta();
        if (bgMeta != null) {
            bgMeta.setDisplayName(" ");
            background.setItemMeta(bgMeta);
        }
        for (int i = 0; i < 54; ++i) {
            if (i >= 10 && i <= 16 || i >= 19 && i <= 25 || i >= 28 && i <= 34 || i >= 37 && i <= 43 || i >= 46 && i <= 52 || i == 48 || i == 50 || i == 45 || i == 53 || i == 49) continue;
            gui.setItem(i, background);
        }
        if (page > 1) {
            ItemStack prevPage = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevPage.getItemMeta();
            if (prevMeta != null) {
                prevMeta.setDisplayName(this.getMessage("gui.buttons.previous", "&aPrevious Page"));
                prevPage.setItemMeta(prevMeta);
            }
            gui.setItem(45, prevPage);
        } else {
            ItemStack noPrev = new ItemStack(Material.BARRIER);
            ItemMeta npm = noPrev.getItemMeta();
            if (npm != null) {
                npm.setDisplayName(this.getMessage("gui.buttons.no-previous", "&cNo Previous Page"));
                noPrev.setItemMeta(npm);
            }
            gui.setItem(45, noPrev);
        }
        if (page < 8) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextPage.getItemMeta();
            if (nextMeta != null) {
                nextMeta.setDisplayName(this.getMessage("gui.buttons.next", "&aNext Page"));
                nextPage.setItemMeta(nextMeta);
            }
            gui.setItem(53, nextPage);
        } else {
            ItemStack noNext = new ItemStack(Material.BARRIER);
            ItemMeta nnm = noNext.getItemMeta();
            if (nnm != null) {
                nnm.setDisplayName(this.getMessage("gui.buttons.no-next", "&cNo Next Page"));
                noNext.setItemMeta(nnm);
            }
            gui.setItem(53, noNext);
        }
        ItemStack pageInfo = new ItemStack(Material.BOOK);
        ItemMeta pageInfoMeta = pageInfo.getItemMeta();
        if (pageInfoMeta != null) {
            pageInfoMeta.setDisplayName(this.getMessage("gui.buttons.page-info", "&bPage &e{page} &bof &e{total}").replace("{page}", String.valueOf(page)).replace("{total}", String.valueOf(totalPages)));
            pageInfo.setItemMeta(pageInfoMeta);
        }
        gui.setItem(49, pageInfo);
        int startIndex = (page - 1) * 7;
        for (int slotIndex = 0; slotIndex < 7; ++slotIndex) {
            int globalIndex = startIndex + slotIndex;
            ArmorSet set = globalIndex < armorSets.size() ? (ArmorSet)armorSets.get(globalIndex) : null;
            ItemStack nameplate = new ItemStack(Material.NAME_TAG);
            ItemMeta nm = nameplate.getItemMeta();
            if (nm != null) {
                nm.setDisplayName(set != null ? this.colorize("&f" + set.getName()) : this.getMessage("gui.buttons.empty-slot", "&7Empty armour slot"));
                nameplate.setItemMeta(nm);
            }
            gui.setItem(1 + slotIndex, nameplate);
            Material setColor = SPECTRUM[globalIndex % SPECTRUM.length];
            gui.setItem(10 + slotIndex, set != null ? this.defaultIfNull(set.getArmor()[3]) : this.emptyArmorPlaceholder(setColor));
            gui.setItem(19 + slotIndex, set != null ? this.defaultIfNull(set.getArmor()[2]) : this.emptyArmorPlaceholder(setColor));
            gui.setItem(28 + slotIndex, set != null ? this.defaultIfNull(set.getArmor()[1]) : this.emptyArmorPlaceholder(setColor));
            gui.setItem(37 + slotIndex, set != null ? this.defaultIfNull(set.getArmor()[0]) : this.emptyArmorPlaceholder(setColor));
            if (set != null) {
                ItemStack equipButton = new ItemStack(Material.LIME_DYE);
                ItemMeta equipMeta = equipButton.getItemMeta();
                if (equipMeta != null) {
                    equipMeta.setDisplayName(this.getMessage("gui.buttons.equip", "&aEquip &7{name}").replace("{name}", set.getName()));
                    equipButton.setItemMeta(equipMeta);
                }
                gui.setItem(46 + slotIndex, equipButton);
                continue;
            }
            ItemStack saveButton = new ItemStack(Material.GRAY_DYE);
            ItemMeta saveMeta = saveButton.getItemMeta();
            if (saveMeta != null) {
                saveMeta.setDisplayName(this.getMessage("gui.buttons.save", "&aSave Armor Here"));
                saveButton.setItemMeta(saveMeta);
            }
            gui.setItem(46 + slotIndex, saveButton);
        }
        player.openInventory(gui);
        this.openInventories.put(player.getUniqueId(), gui);
        if (this.config.getBoolean("sounds.enabled", true)) {
            this.playSound(player, "sounds.open");
        }
    }

    private ItemStack emptyArmorPlaceholder(Material color) {
        ItemStack placeholder = new ItemStack(color);
        ItemMeta meta = placeholder.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.getMessage("gui.buttons.empty-armor-slot", "&cEmpty Slot"));
            placeholder.setItemMeta(meta);
        }
        return placeholder;
    }

    private ItemStack defaultIfNull(ItemStack stack) {
        if (stack != null && stack.getType() != Material.AIR) {
            return stack;
        }
        ItemStack placeholder = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = placeholder.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.getMessage("gui.buttons.empty-placeholder", "&7(Empty)"));
            placeholder.setItemMeta(meta);
        }
        return placeholder;
    }

    private void playSound(Player player, String configPath) {
        if (!this.config.getBoolean("sounds.enabled", true)) {
            return;
        }
        Sound sound = SOUND_MAP.getOrDefault(this.config.getString(configPath, "BLOCK_CHEST_OPEN"), Sound.BLOCK_CHEST_OPEN);
        player.playSound(player.getLocation(), sound, SoundCategory.PLAYERS, (float)this.config.getDouble("sounds.volume", 0.8), (float)this.config.getDouble("sounds.pitch", 1.0));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        InventoryView view = event.getView();
        Inventory top = view.getTopInventory();
        Inventory ourTop = this.openInventories.get(uuid);
        if (ourTop == null || !top.equals((Object)ourTop)) {
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        if (!event.getClickedInventory().equals((Object)top)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        int currentPage = this.currentPages.getOrDefault(uuid, 1);
        List armorSets = this.playerArmorSets.computeIfAbsent(uuid, k -> new ArrayList());
        if (slot == 45) {
            if (currentPage > 1) {
                this.openWardrobeGUI(player, currentPage - 1);
            }
            return;
        }
        if (slot == 53) {
            int nextPage = currentPage + 1;
            if (nextPage <= 8) {
                if (!player.hasPermission("rayzwardrobe.use.page" + nextPage)) {
                    player.sendMessage(this.getMessage("errors.no-page-permission", "&c\u2716 &7You don't have permission to access page &b{page}&7!").replace("{page}", String.valueOf(nextPage)));
                    return;
                }
                this.openWardrobeGUI(player, nextPage);
            }
            return;
        }
        if (slot >= 1 && slot <= 7 && event.isRightClick()) {
            int setSlot = slot - 1;
            int globalSetIndex = (currentPage - 1) * 7 + setSlot;
            if (globalSetIndex < armorSets.size() && armorSets.get(globalSetIndex) != null) {
                this.startRenamingProcess(player, globalSetIndex);
            } else {
                player.sendMessage(this.colorize("&c\u2716 &7No set in that slot to rename."));
            }
            return;
        }
        if (slot >= 46 && slot <= 52) {
            int setSlot = slot - 46;
            int globalSetIndex = (currentPage - 1) * 7 + setSlot;
            if (globalSetIndex < armorSets.size() && armorSets.get(globalSetIndex) != null) {
                this.equipArmorSet(player, globalSetIndex);
            } else {
                this.saveArmorSet(player, globalSetIndex);
            }
        }
    }

    private void saveArmorSet(Player player, int globalIndex) {
        List armorSets = this.playerArmorSets.computeIfAbsent(player.getUniqueId(), k -> new ArrayList());
        int maxSets = this.config.getInt("settings.max-armor-sets", 56);
        int existingCount = 0;
        for (ArmorSet s : armorSets) {
            if (s == null) continue;
            ++existingCount;
        }
        if (existingCount >= maxSets) {
            player.sendMessage(this.getMessage("errors.max-sets", "&c\u2716 &7Maximum armor sets reached (&b{max}&7)!").replace("{max}", String.valueOf(maxSets)));
            return;
        }
        ItemStack[] currentArmor = player.getInventory().getArmorContents();
        boolean hasArmor = false;
        for (ItemStack item : currentArmor) {
            if (item == null || item.getType() == Material.AIR) continue;
            hasArmor = true;
            break;
        }
        if (!hasArmor) {
            player.sendMessage(this.getMessage("errors.no-armor", "&c\u2716 &7You're not wearing any armor!"));
            return;
        }
        ItemStack[] snapshot = Arrays.copyOf(currentArmor, 4);
        player.getInventory().setArmorContents(new ItemStack[4]);
        while (armorSets.size() <= globalIndex) {
            armorSets.add(null);
        }
        ArmorSet newSet = new ArmorSet("Set #" + (globalIndex + 1), snapshot);
        armorSets.set(globalIndex, newSet);
        this.savePlayerData();
        player.sendMessage(this.getMessage("messages.saved", "&a\u2714 &7Armor saved as &f{name}&7!").replace("{name}", newSet.getName()));
        this.playSound(player, "sounds.save");
        this.openWardrobeGUI(player, this.currentPages.getOrDefault(player.getUniqueId(), 1));
    }

    private void equipArmorSet(Player player, int globalIndex) {
        List armorSets = this.playerArmorSets.computeIfAbsent(player.getUniqueId(), k -> new ArrayList());
        if (globalIndex >= armorSets.size()) {
            return;
        }
        ArmorSet set = (ArmorSet)armorSets.get(globalIndex);
        if (set == null) {
            return;
        }
        ItemStack[] currentArmor = player.getInventory().getArmorContents();
        int emptySlots = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item != null && item.getType() != Material.AIR) continue;
            ++emptySlots;
        }
        boolean needsStorage = false;
        for (ItemStack item : currentArmor) {
            if (item == null || item.getType() == Material.AIR) continue;
            needsStorage = true;
            break;
        }
        if (needsStorage && emptySlots < 4) {
            player.sendMessage(this.getMessage("errors.full-inventory", "&c\u2716 &7Clear inventory space first!"));
            return;
        }
        if (needsStorage) {
            for (ItemStack item : currentArmor) {
                if (item == null || item.getType() == Material.AIR) continue;
                player.getInventory().addItem(new ItemStack[]{item});
            }
        }
        player.getInventory().setArmorContents(Arrays.copyOf(set.getArmor(), 4));
        armorSets.set(globalIndex, null);
        this.savePlayerData();
        player.sendMessage(this.getMessage("messages.loaded", "&a\u2726 &7Equipped &b{name}&7!").replace("{name}", set.getName()));
        this.playSound(player, "sounds.equip");
        if (this.config.getBoolean("settings.enable-animations", true)) {
            this.showEquipParticles(player);
        }
        this.openWardrobeGUI(player, this.currentPages.getOrDefault(player.getUniqueId(), 1));
    }

    private void showEquipParticles(final Player player) {
        new BukkitRunnable(){
            int count = 0;
            final int maxCount;
            final Particle particle;
            {
                this.maxCount = Math.max(1, RayzWardrobe.this.config.getInt("particles.count", 25));
                this.particle = PARTICLE_MAP.getOrDefault(RayzWardrobe.this.config.getString("particles.equip-effect", "CLOUD"), Particle.CLOUD);
            }

            public void run() {
                if (this.count >= this.maxCount) {
                    this.cancel();
                    return;
                }
                double offsetX = RayzWardrobe.this.config.getDouble("particles.offset-x", 0.3);
                double offsetY = RayzWardrobe.this.config.getDouble("particles.offset-y", 0.5);
                double offsetZ = RayzWardrobe.this.config.getDouble("particles.offset-z", 0.3);
                player.spawnParticle(this.particle, player.getLocation().add(0.0, 1.0, 0.0), Math.max(1, this.maxCount / 5), offsetX, offsetY, offsetZ, 0.1, null, true);
                ++this.count;
            }
        }.runTaskTimer((Plugin)this, 0L, 2L);
    }

    private void startRenamingProcess(Player player, int setIndex) {
        List<ArmorSet> armorSets = this.playerArmorSets.get(player.getUniqueId());
        if (armorSets == null || setIndex < 0 || setIndex >= armorSets.size()) {
            player.sendMessage(this.colorize("&c\u2716 &7No set found to rename."));
            return;
        }
        ArmorSet set = armorSets.get(setIndex);
        if (set == null) {
            player.sendMessage(this.colorize("&c\u2716 &7No set found to rename."));
            return;
        }
        this.renamingPlayers.put(player.getUniqueId(), set.getName());
        this.renamingSlots.put(player.getUniqueId(), setIndex);
        player.closeInventory();
        player.sendMessage(this.getMessage("messages.rename-prompt", "&e\u270e &7Type the new name in chat:"));
        player.sendMessage(this.getMessage("messages.rename-cancel", "&7Type &c'cancel' &7to cancel renaming."));
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID id = player.getUniqueId();
        if (!this.renamingPlayers.containsKey(id)) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        if (message.equalsIgnoreCase("cancel")) {
            player.sendMessage(this.getMessage("messages.rename-cancelled", "&c\u2716 &7Renaming cancelled"));
            this.renamingPlayers.remove(id);
            this.renamingSlots.remove(id);
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.openWardrobeGUI(player, this.currentPages.getOrDefault(id, 1)));
            return;
        }
        int maxLength = Math.max(1, this.config.getInt("settings.max-name-length", 16));
        int minLength = Math.max(1, this.config.getInt("settings.min-name-length", 3));
        if (message.length() > maxLength) {
            player.sendMessage(this.getMessage("errors.name-too-long", "&c\u2716 &7Name too long! (Max &b{max}&7 chars)").replace("{max}", String.valueOf(maxLength)));
            return;
        }
        if (message.length() < minLength) {
            player.sendMessage(this.getMessage("errors.name-too-short", "&c\u2716 &7Name too short! (Min &b{min}&7 chars)").replace("{min}", String.valueOf(minLength)));
            return;
        }
        Integer slot = this.renamingSlots.get(id);
        List<ArmorSet> armorSets = this.playerArmorSets.get(id);
        if (slot == null || armorSets == null || slot < 0 || slot >= armorSets.size()) {
            player.sendMessage(this.colorize("&c\u2716 &7Failed to find the set to rename."));
            this.renamingPlayers.remove(id);
            this.renamingSlots.remove(id);
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.openWardrobeGUI(player, this.currentPages.getOrDefault(id, 1)));
            return;
        }
        ArmorSet set = armorSets.get(slot);
        if (set == null) {
            player.sendMessage(this.colorize("&c\u2716 &7Failed to find the set to rename."));
            this.renamingPlayers.remove(id);
            this.renamingSlots.remove(id);
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.openWardrobeGUI(player, this.currentPages.getOrDefault(id, 1)));
            return;
        }
        set.setName(message);
        this.savePlayerData();
        player.sendMessage(this.getMessage("messages.renamed", "&a\u270e &7Renamed to &b{new}&7!").replace("{new}", message));
        this.playSound(player, "sounds.save");
        this.renamingPlayers.remove(id);
        this.renamingSlots.remove(id);
        Bukkit.getScheduler().runTask((Plugin)this, () -> this.openWardrobeGUI(player, this.currentPages.getOrDefault(id, 1)));
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        UUID uuid = player.getUniqueId();
        this.openInventories.remove(uuid);
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.playerArmorSets.containsKey(uuid)) {
            this.savePlayerData();
        }
        this.renamingPlayers.remove(uuid);
        this.renamingSlots.remove(uuid);
        this.cooldowns.remove(uuid);
        this.currentPages.remove(uuid);
        this.openInventories.remove(uuid);
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private static class ArmorSet {
        private String name;
        private final ItemStack[] armor;

        public ArmorSet(String name, ItemStack[] armor) {
            this.name = name != null ? name : "Unnamed";
            this.armor = armor != null ? armor : new ItemStack[4];
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name != null ? name : this.name;
        }

        public ItemStack[] getArmor() {
            return this.armor;
        }
    }
}

