/*
 * Decompiled with CFR 0.152.
 */
package org.rayz.rayzWardrobe;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RayzWardrobe
extends JavaPlugin
implements Listener {
    private static final Map<String, Sound> SOUND_MAP = Map.of("BLOCK_CHEST_OPEN", Sound.BLOCK_CHEST_OPEN, "ENTITY_PLAYER_LEVELUP", Sound.ENTITY_PLAYER_LEVELUP, "ITEM_ARMOR_EQUIP_NETHERITE", Sound.ITEM_ARMOR_EQUIP_NETHERITE, "ENTITY_EXPERIENCE_ORB_PICKUP", Sound.ENTITY_EXPERIENCE_ORB_PICKUP);
    private static final Map<String, Particle> PARTICLE_MAP = Map.of("CLOUD", Particle.CLOUD, "HEART", Particle.HEART, "FLAME", Particle.FLAME, "END_ROD", Particle.END_ROD, "SPELL_WITCH", Particle.WITCH);
    private FileConfiguration config;
    private FileConfiguration messages;
    private File configFile;
    private File messagesFile;
    private final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, String> renamingPlayers = new ConcurrentHashMap<UUID, String>();
    private final Map<UUID, Integer> renamingSlots = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, List<ArmorSet>> playerArmorSets = new ConcurrentHashMap<UUID, List<ArmorSet>>();
    private final Map<UUID, Integer> currentPages = new ConcurrentHashMap<UUID, Integer>();
    private final Map<UUID, Inventory> openInventories = new ConcurrentHashMap<UUID, Inventory>();
    private final Map<UUID, String> playerThemes = new ConcurrentHashMap<UUID, String>();
    private final Map<String, Theme> themeRegistry = new LinkedHashMap<String, Theme>();
    private final Map<UUID, Inventory> openThemeInventories = new ConcurrentHashMap<UUID, Inventory>();
    private final Map<UUID, BukkitRunnable> themeAnimationTasks = new ConcurrentHashMap<UUID, BukkitRunnable>();
    private static final int MAX_PAGES = 8;
    private static final int SETS_PER_PAGE = 7;
    private static final Material[] SPECTRUM = new Material[]{Material.RED_STAINED_GLASS_PANE, Material.LIME_STAINED_GLASS_PANE, Material.BLUE_STAINED_GLASS_PANE, Material.PURPLE_STAINED_GLASS_PANE};

    public void onEnable() {
        this.createFiles();
        this.createThemeFiles();
        if (this.messages == null) {
            this.getLogger().severe("Disabling plugin - messages file could not be loaded!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.loadPlayerData();
        this.loadThemes();
        this.loadPlayerThemes();
        String version = this.getDescription().getVersion();
        String enableMsg = this.getMessage("console.enable", "&a[RayzWardrobe] &fEnabled! &b(v{version})").replace("{version}", version);
        this.getLogger().info(enableMsg);
    }

    public void onDisable() {
        for (BukkitRunnable task : this.themeAnimationTasks.values()) {
            try {
                task.cancel();
            }
            catch (Exception exception) {}
        }
        this.themeAnimationTasks.clear();
        this.savePlayerData();
        this.savePlayerThemes();
        String disableMsg = this.getMessage("console.disable", "&c[RayzWardrobe] &fSaving all data...");
        this.getLogger().info(disableMsg);
    }

    private void createFiles() {
        File dataFolder;
        File playerData;
        File themesFolder;
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.messagesFile = new File(this.getDataFolder(), "messages_en.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.saveResource("config.yml", false);
        }
        if (!this.messagesFile.exists()) {
            this.messagesFile.getParentFile().mkdirs();
            this.saveResource("messages_en.yml", false);
        }
        if (!(themesFolder = new File(this.getDataFolder(), "themes")).exists()) {
            themesFolder.mkdirs();
        }
        if (!(playerData = new File(this.getDataFolder(), "playerdata")).exists()) {
            playerData.mkdirs();
        }
        if (!(dataFolder = new File(this.getDataFolder(), "data")).exists()) {
            dataFolder.mkdirs();
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    private void createThemeFiles() {
        String[] defaults;
        File themesFolder = new File(this.getDataFolder(), "themes");
        if (!themesFolder.exists()) {
            themesFolder.mkdirs();
        }
        for (String name : defaults = new String[]{"classic.yml", "cyber.yml", "darkmode.yml", "galaxy.yml", "neon.yml", "pastel.yml", "royal.yml", "sunset.yml"}) {
            try {
                File out = new File(this.getDataFolder(), "themes/" + name);
                if (out.exists()) continue;
                this.saveResource("themes/" + name, false);
                this.getLogger().info("Generated default theme: " + name);
            }
            catch (IllegalArgumentException e) {
                this.getLogger().warning("Theme resource missing in JAR: themes/" + name);
            }
        }
    }

    private void reloadFiles() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        this.loadMessages();
        this.loadThemes();
    }

    private void loadMessages() {
        try {
            if (this.messagesFile != null && this.messagesFile.exists()) {
                this.messages.load(this.messagesFile);
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load messages file: " + e.getMessage());
        }
    }

    private String getMessage(String path, String def) {
        return this.messages != null ? this.colorize(this.messages.getString(path, def)) : this.colorize(def);
    }

    private String getMessage(Player player, String path, String def) {
        String raw = this.messages != null ? this.messages.getString(path, def) : def;
        String colored = this.colorize(raw);
        return this.parsePlaceholders(player, colored);
    }

    private String parsePlaceholders(Player player, String text) {
        if (text == null) {
            return "";
        }
        if (player == null) {
            return text;
        }
        if (!Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return text;
        }
        try {
            Class<?> papiClass = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
            Method method = papiClass.getMethod("setPlaceholders", Player.class, String.class);
            Object result = method.invoke(null, player, text);
            if (result instanceof String) {
                return (String)result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return text;
    }

    private void loadPlayerData() {
        File dataFolder = new File(this.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
            return;
        }
        int count = 0;
        File[] playerFiles = dataFolder.listFiles();
        if (playerFiles != null) {
            for (File file : playerFiles) {
                if (!file.getName().endsWith(".yml")) continue;
                try {
                    String uuidStr = file.getName().replace(".yml", "");
                    UUID uuid = UUID.fromString(uuidStr);
                    YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)file);
                    ArrayList<ArmorSet> armorSets = new ArrayList<ArmorSet>();
                    Set keys = playerConfig.getKeys(false);
                    for (String key : keys) {
                        try {
                            int idx = Integer.parseInt(key);
                            String name = playerConfig.getString(key + ".name");
                            ItemStack[] armor = new ItemStack[4];
                            for (int i = 0; i < 4; ++i) {
                                armor[i] = playerConfig.getItemStack(key + ".armor." + i);
                            }
                            ArmorSet set = new ArmorSet((String)(name != null ? name : "Set #" + (idx + 1)), armor);
                            while (armorSets.size() <= idx) {
                                armorSets.add(null);
                            }
                            armorSets.set(idx, set);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    this.playerArmorSets.put(uuid, armorSets);
                    ++count;
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to load player data from " + file.getName() + ": " + e.getMessage());
                }
            }
        }
        String loadedMsg = this.getMessage("console.loaded-data", "&7Loaded data for &b{count} &7players").replace("{count}", String.valueOf(count));
        this.getLogger().info(loadedMsg);
    }

    private void savePlayerData() {
        File dataFolder = new File(this.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        int count = 0;
        for (Map.Entry<UUID, List<ArmorSet>> entry : this.playerArmorSets.entrySet()) {
            try {
                int i;
                File playerFile = new File(dataFolder, entry.getKey().toString() + ".yml");
                YamlConfiguration playerConfig = new YamlConfiguration();
                List<ArmorSet> armorSets = entry.getValue();
                int lastIndex = -1;
                for (i = armorSets.size() - 1; i >= 0; --i) {
                    if (armorSets.get(i) == null) continue;
                    lastIndex = i;
                    break;
                }
                for (i = 0; i <= lastIndex; ++i) {
                    ArmorSet set = armorSets.get(i);
                    if (set == null) continue;
                    playerConfig.set(i + ".name", (Object)set.getName());
                    for (int j = 0; j < 4; ++j) {
                        playerConfig.set(i + ".armor." + j, (Object)set.getArmor()[j]);
                    }
                }
                playerConfig.save(playerFile);
                ++count;
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to save data for player " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
            }
        }
        String savedMsg = this.getMessage("console.saved-data", "&7Saved data for &b{count} &7players").replace("{count}", String.valueOf(count));
        this.getLogger().info(savedMsg);
    }

    private void loadThemes() {
        File[] files;
        this.themeRegistry.clear();
        File themesFolder = new File(this.getDataFolder(), "themes");
        if (!themesFolder.exists()) {
            themesFolder.mkdirs();
        }
        if ((files = themesFolder.listFiles()) == null) {
            return;
        }
        for (File f : files) {
            if (!f.getName().endsWith(".yml")) continue;
            try {
                YamlConfiguration yml = YamlConfiguration.loadConfiguration((File)f);
                String key = f.getName().replace(".yml", "");
                Theme t = new Theme();
                t.key = key;
                t.name = yml.getString("theme-name", key);
                t.slot = yml.getInt("slot", 10);
                t.permission = yml.getString("permission", "");
                t.icon = this.matOrDefault(yml.getString("icon", "BOOK"), Material.BOOK);
                t.background = this.matOrDefault(yml.getString("background", "GRAY_STAINED_GLASS_PANE"), Material.GRAY_STAINED_GLASS_PANE);
                t.primary = this.matOrDefault(yml.getString("primary-color", "WHITE_STAINED_GLASS_PANE"), Material.WHITE_STAINED_GLASS_PANE);
                t.secondary = this.matOrDefault(yml.getString("secondary-color", "LIGHT_BLUE_STAINED_GLASS_PANE"), Material.LIGHT_BLUE_STAINED_GLASS_PANE);
                t.emptySlotIcon = this.matOrDefault(yml.getString("empty-slot-icon", ""), null);
                t.lockedIcon = this.matOrDefault(yml.getString("locked-icon", "BARRIER"), Material.BARRIER);
                t.headOwner = yml.getString("head-owner", "");
                t.headTexture = yml.getString("head-texture", "");
                this.themeRegistry.put(key.toLowerCase(), t);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to load theme file: " + f.getName() + " -> " + e.getMessage());
            }
        }
        if (this.themeRegistry.isEmpty()) {
            Theme def = new Theme();
            def.key = "classic";
            def.name = "Classic";
            def.slot = 10;
            def.icon = Material.BOOK;
            def.background = Material.GRAY_STAINED_GLASS_PANE;
            def.primary = Material.WHITE_STAINED_GLASS_PANE;
            def.secondary = Material.LIGHT_BLUE_STAINED_GLASS_PANE;
            def.lockedIcon = Material.BARRIER;
            this.themeRegistry.put(def.key, def);
        }
    }

    private void loadPlayerThemes() {
        File[] files;
        File dataFolder = new File(this.getDataFolder(), "playerdata");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        if ((files = dataFolder.listFiles()) == null) {
            return;
        }
        for (File file : files) {
            if (!file.getName().endsWith(".yml")) continue;
            try {
                UUID uuid = UUID.fromString(file.getName().replace(".yml", ""));
                YamlConfiguration themeConfig = YamlConfiguration.loadConfiguration((File)file);
                this.playerThemes.put(uuid, themeConfig.getString("selected-theme", "classic"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void savePlayerThemes() {
        File dataFolder = new File(this.getDataFolder(), "playerdata");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        for (Map.Entry<UUID, String> entry : this.playerThemes.entrySet()) {
            try {
                File themeFile = new File(dataFolder, entry.getKey().toString() + ".yml");
                YamlConfiguration themeConfig = new YamlConfiguration();
                themeConfig.set("selected-theme", (Object)entry.getValue());
                themeConfig.save(themeFile);
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to save theme for player " + String.valueOf(entry.getKey()));
            }
        }
    }

    private Theme getSelectedTheme(Player player) {
        String key = this.playerThemes.getOrDefault(player.getUniqueId(), "classic");
        Theme t = this.themeRegistry.get(key.toLowerCase());
        if (t == null) {
            return this.themeRegistry.values().iterator().next();
        }
        return t;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("wardrobe")) {
            long secondsLeft;
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.getMessage("errors.only-players", "&c\u2716 &7Only players can use &bRayzWardrobe&7!"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("rayzwardrobe.use")) {
                player.sendMessage(this.getMessage(player, "errors.no-permission", "&c\u2716 &7You need &b{permission} &7permission!").replace("{permission}", "rayzwardrobe.use"));
                return true;
            }
            if (this.cooldowns.containsKey(player.getUniqueId()) && (secondsLeft = this.cooldowns.get(player.getUniqueId()) / 1000L + (long)this.config.getInt("settings.cooldown-seconds", 0) - System.currentTimeMillis() / 1000L) > 0L) {
                String cooldownMsg = this.getMessage(player, "errors.cooldown", "&c\u23f3 &7Please wait &b{time}s &7before using again!").replace("{time}", String.valueOf(secondsLeft));
                player.sendMessage(cooldownMsg);
                return true;
            }
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            this.openWardrobeGUI(player, 1);
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("rwreload")) {
            if (!sender.hasPermission("rayzwardrobe.reload")) {
                sender.sendMessage(this.getMessage("errors.no-permission", "&c\u2716 &7You need &b{permission} &7permission!").replace("{permission}", "rayzwardrobe.reload"));
                return true;
            }
            this.reloadFiles();
            this.savePlayerData();
            this.loadPlayerData();
            sender.sendMessage(this.colorize("&a[RayzWardrobe] &fConfiguration/messages & themes reloaded successfully!"));
            this.getLogger().info("[RayzWardrobe] Configuration, messages and themes reloaded");
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("rwcredits")) {
            sender.sendMessage(this.colorize("&6&l\u26a1 &bRayzWardrobe &7- &fPremium Armor Wardrobe"));
            sender.sendMessage(this.colorize("&7Created by: &bRayz"));
            sender.sendMessage(this.colorize("&7Version: &b" + this.getDescription().getVersion()));
            sender.sendMessage(this.colorize("&7Website: &bhttps://rayzdev.com"));
            sender.sendMessage(this.colorize("&7Discord: &bhttps://discord.gg/rayzdev"));
            sender.sendMessage(this.colorize("&7SpigotMC: &bhttps://www.spigotmc.org/resources/rayzwardrobe"));
            sender.sendMessage(this.colorize("&7Thank you for using my plugin!"));
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("wardrobethemes")) {
            if (!(sender instanceof Player)) {
                return true;
            }
            this.openThemesGUI((Player)sender);
            return true;
        }
        return false;
    }

    private void openWardrobeGUI(Player player, int requestedPage) {
        if (requestedPage > 1 && !player.hasPermission("rayzwardrobe.use.page" + requestedPage)) {
            player.sendMessage(this.getMessage(player, "errors.no-page-permission", "&c\u2716 &7You don't have permission to access page &b{page}&7!").replace("{page}", String.valueOf(requestedPage)));
            return;
        }
        int page = Math.max(1, Math.min(requestedPage, 8));
        this.currentPages.put(player.getUniqueId(), page);
        List armorSets = this.playerArmorSets.getOrDefault(player.getUniqueId(), new ArrayList());
        int totalPages = 8;
        Theme theme = this.getSelectedTheme(player);
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)this.getMessage(player, "gui.title", "&6&l\u26a1 &bRayz&3Wardrobe &8| &7Page {page}/{total}").replace("{page}", String.valueOf(page)).replace("{total}", String.valueOf(totalPages)));
        ItemStack background = new ItemStack(theme.background != null ? theme.background : Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta bgMeta = background.getItemMeta();
        if (bgMeta != null) {
            bgMeta.setDisplayName(" ");
            background.setItemMeta(bgMeta);
        }
        for (int i = 0; i < 54; ++i) {
            if (i >= 10 && i <= 16 || i >= 19 && i <= 25 || i >= 28 && i <= 34 || i >= 37 && i <= 43 || i >= 46 && i <= 52 || i == 45 || i == 53 || i == 49 || i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8) continue;
            gui.setItem(i, background);
        }
        if (page > 1) {
            gui.setItem(45, this.quickItem(Material.ARROW, this.getMessage(player, "gui.buttons.previous", "&aPrevious Page")));
        } else {
            gui.setItem(45, this.quickItem(Material.BARRIER, this.getMessage(player, "gui.buttons.no-previous", "&cNo Previous Page")));
        }
        if (page < 8) {
            gui.setItem(53, this.quickItem(Material.ARROW, this.getMessage(player, "gui.buttons.next", "&aNext Page")));
        } else {
            gui.setItem(53, this.quickItem(Material.BARRIER, this.getMessage(player, "gui.buttons.no-next", "&cNo Next Page")));
        }
        gui.setItem(49, this.quickItem(Material.BOOK, this.getMessage(player, "gui.buttons.page-info", "&bPage &e{page} &bof &e{total}").replace("{page}", String.valueOf(page)).replace("{total}", String.valueOf(totalPages))));
        gui.setItem(8, this.createThemeIconForButton(player, theme));
        int startIndex = (page - 1) * 7;
        for (int slotIndex = 0; slotIndex < 7; ++slotIndex) {
            int globalIndex = startIndex + slotIndex;
            ArmorSet set = globalIndex < armorSets.size() ? (ArmorSet)armorSets.get(globalIndex) : null;
            ItemStack nameplate = new ItemStack(Material.NAME_TAG);
            ItemMeta nm = nameplate.getItemMeta();
            if (nm != null) {
                if (set != null) {
                    nm.setDisplayName(set.getName());
                    lore = new ArrayList<String>();
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.separator", "&8&m----------------")));
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.rename", "&7Right-Click: &eRename this set")));
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.colorcodes", "&7Use & codes for colors")));
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.example", "&8e.g., &aArmour")));
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.separator", "&8&m----------------")));
                    nm.setLore(lore);
                } else {
                    nm.setDisplayName(this.getMessage(player, "gui.buttons.empty-slot", "&7Empty armour slot"));
                    lore = new ArrayList();
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.separator", "&8&m----------------")));
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.save-left", "&7Left-Click: &aSave current armor")));
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.then-right", "&7Then Right-Click the name tag")));
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.change-name", "&7to &echange the set name")));
                    lore.add(this.colorize(this.getMessage(player, "gui.lore.separator", "&8&m----------------")));
                    nm.setLore(lore);
                }
                nameplate.setItemMeta(nm);
            }
            gui.setItem(1 + slotIndex, nameplate);
            Material placeholderColor = theme.emptySlotIcon != null ? theme.emptySlotIcon : SPECTRUM[globalIndex % SPECTRUM.length];
            gui.setItem(10 + slotIndex, set != null ? this.defaultIfNull(player, set.getArmor()[3]) : this.emptyArmorPlaceholder(player, placeholderColor));
            gui.setItem(19 + slotIndex, set != null ? this.defaultIfNull(player, set.getArmor()[2]) : this.emptyArmorPlaceholder(player, placeholderColor));
            gui.setItem(28 + slotIndex, set != null ? this.defaultIfNull(player, set.getArmor()[1]) : this.emptyArmorPlaceholder(player, placeholderColor));
            gui.setItem(37 + slotIndex, set != null ? this.defaultIfNull(player, set.getArmor()[0]) : this.emptyArmorPlaceholder(player, placeholderColor));
            if (set != null) {
                gui.setItem(46 + slotIndex, this.quickItem(Material.LIME_DYE, this.getMessage(player, "gui.buttons.equip", "&aEquip &7{name}").replace("{name}", set.getName())));
                continue;
            }
            gui.setItem(46 + slotIndex, this.quickItem(Material.GRAY_DYE, this.getMessage(player, "gui.buttons.save", "&aSave Armor Here")));
        }
        player.openInventory(gui);
        this.openInventories.put(player.getUniqueId(), gui);
        if (this.config != null && this.config.getBoolean("sounds.enabled", true)) {
            this.playSound(player, "sounds.open");
        }
    }

    private void openThemesGUI(Player player) {
        String title = this.getMessage(player, "themes_gui.title", "&b\u26a1 Select Your Theme");
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)title);
        UUID uuid = player.getUniqueId();
        gui.setItem(0, this.quickItem(Material.ARROW, this.getMessage(player, "themes_gui.back-button", "&a\u2190 Back to Wardrobe")));
        ItemStack filler = this.quickItem(Material.LIGHT_GRAY_STAINED_GLASS_PANE, " ");
        for (int i = 1; i < gui.getSize(); ++i) {
            gui.setItem(i, filler);
        }
        int[] themeSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        int idx = 0;
        String selectedKey = this.playerThemes.getOrDefault(uuid, "classic");
        for (Theme t : this.themeRegistry.values()) {
            ItemStack icon;
            boolean unlocked;
            if (idx >= themeSlots.length) break;
            boolean bl = unlocked = t.permission == null || t.permission.isEmpty() || player.hasPermission(t.permission);
            if (unlocked) {
                icon = this.createThemeIcon(player, t, String.valueOf(ChatColor.YELLOW) + t.name);
                m = icon.getItemMeta();
                if (m != null) {
                    if (t.key.equalsIgnoreCase(selectedKey)) {
                        m.addEnchant(Enchantment.UNBREAKING, 1, true);
                        m.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        m.setLore(Collections.singletonList(this.getMessage(player, "themes_gui.theme-selected", "&b\u2714 Selected")));
                    } else {
                        m.setLore(Collections.singletonList(this.getMessage(player, "themes_gui.theme-apply", "&7Click to apply")));
                    }
                    icon.setItemMeta(m);
                }
            } else {
                icon = this.quickItem(t.lockedIcon != null ? t.lockedIcon : Material.BARRIER, this.getMessage(player, "themes_gui.locked-theme", "&cLocked Theme"));
                m = icon.getItemMeta();
                if (m != null) {
                    ArrayList<String> lore = new ArrayList<String>();
                    String permText = this.getMessage(player, "themes_gui.locked-permission", "&7Permission: &f{permission}");
                    if (t.permission != null && !t.permission.isEmpty()) {
                        lore.add(permText.replace("{permission}", t.permission));
                    }
                    m.setLore(lore);
                    icon.setItemMeta(m);
                }
            }
            gui.setItem(themeSlots[idx], icon);
            ++idx;
        }
        player.openInventory(gui);
        this.openThemeInventories.put(uuid, gui);
    }

    private ItemStack createThemeIconForButton(Player player, Theme theme) {
        String title = this.colorize(this.getMessage(player, "gui.buttons.themes", "&dThemes &7(Selected: &f" + theme.name + "&7)"));
        return this.createThemeIcon(player, theme, title);
    }

    private ItemStack createThemeIcon(Player player, Theme theme, String title) {
        Material base = theme.icon != null ? theme.icon : Material.BOOK;
        ItemStack item = new ItemStack(base);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (base == Material.PLAYER_HEAD) {
                SkullMeta skullMeta = (SkullMeta)meta;
                if (theme.headOwner != null && !theme.headOwner.isEmpty()) {
                    String owner = this.parsePlaceholders(player, theme.headOwner);
                    try {
                        Method owning = skullMeta.getClass().getMethod("setOwner", String.class);
                        owning.invoke((Object)skullMeta, owner);
                    }
                    catch (Throwable ignored) {
                        try {
                            Method m = skullMeta.getClass().getMethod("setOwningPlayer", OfflinePlayer.class);
                            m.invoke((Object)skullMeta, Bukkit.getOfflinePlayer((String)owner));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                if (theme.headTexture != null && !theme.headTexture.isEmpty()) {
                    this.applyBase64Texture(skullMeta, theme.headTexture);
                }
                meta = skullMeta;
            }
            meta.setDisplayName(title);
            item.setItemMeta(meta);
        }
        return item;
    }

    private void applyBase64Texture(SkullMeta skullMeta, String base64) {
        try {
            Class<?> gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
            Class<?> propertyClass = Class.forName("com.mojang.authlib.properties.Property");
            Class<?> propertyMapClass = Class.forName("com.mojang.authlib.properties.PropertyMap");
            Object profile = gameProfileClass.getConstructor(UUID.class, String.class).newInstance(UUID.randomUUID(), null);
            Method getProperties = gameProfileClass.getMethod("getProperties", new Class[0]);
            Object propMap = getProperties.invoke(profile, new Object[0]);
            Method putMethod = propertyMapClass.getMethod("put", Object.class, Object.class);
            Object property = propertyClass.getConstructor(String.class, String.class).newInstance("textures", base64);
            putMethod.invoke(propMap, "textures", property);
            Field profileField = skullMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(skullMeta, profile);
        }
        catch (Throwable t) {
            this.getLogger().log(Level.WARNING, "Failed to apply custom head texture: " + t.getMessage());
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        InventoryView view = event.getView();
        Inventory top = view.getTopInventory();
        Inventory ourTop = this.openInventories.get(uuid);
        Inventory themeTop = this.openThemeInventories.get(uuid);
        if (themeTop != null && top.equals((Object)themeTop)) {
            event.setCancelled(true);
            this.handleThemeClick(event, player, themeTop);
            return;
        }
        if (ourTop == null || !top.equals((Object)ourTop)) {
            return;
        }
        if (event.getClickedInventory() == null) {
            return;
        }
        if (!event.getClickedInventory().equals((Object)top)) {
            return;
        }
        event.setCancelled(true);
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        int currentPage = this.currentPages.getOrDefault(uuid, 1);
        List armorSets = this.playerArmorSets.computeIfAbsent(uuid, k -> new ArrayList());
        if (slot == 8) {
            this.openThemesGUI(player);
            return;
        }
        if (slot == 45) {
            if (currentPage > 1) {
                this.openWardrobeGUI(player, currentPage - 1);
            }
            return;
        }
        if (slot == 53) {
            int nextPage = currentPage + 1;
            if (nextPage <= 8) {
                if (!player.hasPermission("rayzwardrobe.use.page" + nextPage)) {
                    player.sendMessage(this.getMessage(player, "errors.no-page-permission", "&c\u2716 &7You don't have permission to access page &b{page}&7!").replace("{page}", String.valueOf(nextPage)));
                    return;
                }
                this.openWardrobeGUI(player, nextPage);
            }
            return;
        }
        if (slot >= 1 && slot <= 7 && event.isRightClick()) {
            int setSlot = slot - 1;
            int globalSetIndex = (currentPage - 1) * 7 + setSlot;
            if (globalSetIndex < armorSets.size() && armorSets.get(this.globalIndexSafe(armorSets, globalSetIndex)) != null) {
                this.startRenamingProcess(player, globalSetIndex);
            } else {
                player.sendMessage(this.colorize(this.getMessage(player, "errors.no-set-to-rename", "&c\u2716 &7No set in that slot to rename.")));
            }
            return;
        }
        if (slot >= 46 && slot <= 52) {
            int setSlot = slot - 46;
            int globalSetIndex = (currentPage - 1) * 7 + setSlot;
            if (globalSetIndex < armorSets.size() && armorSets.get(this.globalIndexSafe(armorSets, globalSetIndex)) != null) {
                this.equipArmorSet(player, globalSetIndex);
            } else {
                this.saveArmorSet(player, globalSetIndex);
            }
        }
    }

    private int globalIndexSafe(List<ArmorSet> list, int idx) {
        return Math.min(Math.max(0, idx), Math.max(0, list.size() - 1));
    }

    private void handleThemeClick(InventoryClickEvent event, Player player, Inventory themeInventory) {
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        UUID uuid = player.getUniqueId();
        if (slot == 0) {
            player.closeInventory();
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> this.openWardrobeGUI(player, this.currentPages.getOrDefault(uuid, 1)), 1L);
            return;
        }
        if (this.isInThemeGrid(slot)) {
            boolean unlocked;
            ItemMeta meta = clicked.getItemMeta();
            if (meta == null || !meta.hasDisplayName()) {
                return;
            }
            String display = ChatColor.stripColor((String)meta.getDisplayName());
            Theme clickedTheme = this.findThemeByName(display);
            if (clickedTheme == null) {
                return;
            }
            boolean bl = unlocked = clickedTheme.permission == null || clickedTheme.permission.isEmpty() || player.hasPermission(clickedTheme.permission);
            if (!unlocked) {
                player.sendMessage(this.colorize(this.getMessage(player, "errors.no-theme-permission", "&c\u2716 &7You don't have permission to use that theme.")));
                this.playSound(player, "sounds.save");
                return;
            }
            ItemStack original = clicked.clone();
            ItemStack flash = this.quickItem(Material.GOLD_BLOCK, String.valueOf(ChatColor.GOLD) + "Applying...");
            themeInventory.setItem(slot, flash);
            Particle p = PARTICLE_MAP.getOrDefault(this.config != null ? this.config.getString("particles.select-effect", "END_ROD") : "END_ROD", Particle.END_ROD);
            player.getWorld().spawnParticle(p, player.getLocation().add(0.0, 1.0, 0.0), 10, 0.2, 0.5, 0.2, 0.02);
            Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
                themeInventory.setItem(slot, original);
                this.applyThemeToPlayer(player, clickedTheme);
                this.refreshThemeInventorySelection(player, themeInventory, clickedTheme.key);
            }, 6L);
        }
    }

    private void applyThemeToPlayer(Player player, Theme theme) {
        UUID uuid = player.getUniqueId();
        this.playerThemes.put(uuid, theme.key);
        this.savePlayerThemes();
        player.sendMessage(this.colorize(this.getMessage(player, "messages.theme-set", "&a\u2714 &7Theme set to &f" + theme.name)));
        this.playSound(player, "sounds.equip");
        Particle p = PARTICLE_MAP.getOrDefault(this.config != null ? this.config.getString("particles.apply-effect", "SPELL_WITCH") : "SPELL_WITCH", Particle.WITCH);
        player.getWorld().spawnParticle(p, player.getLocation().add(0.0, 1.0, 0.0), 20, 0.3, 0.6, 0.3, 0.02);
    }

    private void refreshThemeInventorySelection(Player player, Inventory inv, String selectedKey) {
        int[] themeGridSlots;
        if (inv == null) {
            return;
        }
        for (int s : themeGridSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34}) {
            String display;
            Theme t;
            ItemMeta meta;
            ItemStack it = inv.getItem(s);
            if (it == null || !it.hasItemMeta() || (meta = it.getItemMeta()) == null || (t = this.findThemeByName(display = ChatColor.stripColor((String)meta.getDisplayName()))) == null) continue;
            if (t.key.equalsIgnoreCase(selectedKey)) {
                meta.removeEnchant(Enchantment.UNBREAKING);
                meta.addEnchant(Enchantment.UNBREAKING, 1, true);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                String sel = this.getMessage(player, "themes_gui.theme-selected", "&b\u2714 Selected");
                meta.setLore(Collections.singletonList(sel));
            } else {
                meta.removeEnchant(Enchantment.UNBREAKING);
                meta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                String apply = this.getMessage(player, "themes_gui.theme-apply", "&7Click to apply");
                meta.setLore(Collections.singletonList(apply));
            }
            it.setItemMeta(meta);
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        UUID uuid = event.getPlayer().getUniqueId();
        this.openInventories.remove(uuid);
        this.openThemeInventories.remove(uuid);
        BukkitRunnable t = this.themeAnimationTasks.remove(uuid);
        if (t != null) {
            try {
                t.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.playerArmorSets.containsKey(uuid)) {
            this.savePlayerData();
        }
        this.renamingPlayers.remove(uuid);
        this.renamingSlots.remove(uuid);
        this.cooldowns.remove(uuid);
        this.currentPages.remove(uuid);
        this.openInventories.remove(uuid);
        this.openThemeInventories.remove(uuid);
        BukkitRunnable t = this.themeAnimationTasks.remove(uuid);
        if (t != null) {
            try {
                t.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startRenamingProcess(Player player, int setIndex) {
        List<ArmorSet> armorSets = this.playerArmorSets.get(player.getUniqueId());
        if (armorSets == null || setIndex < 0 || setIndex >= armorSets.size()) {
            player.sendMessage(this.colorize(this.getMessage(player, "errors.no-set-found-rename", "&c\u2716 &7No set found to rename.")));
            return;
        }
        ArmorSet set = armorSets.get(setIndex);
        if (set == null) {
            player.sendMessage(this.colorize(this.getMessage(player, "errors.no-set-found-rename", "&c\u2716 &7No set found to rename.")));
            return;
        }
        this.renamingPlayers.put(player.getUniqueId(), set.getName());
        this.renamingSlots.put(player.getUniqueId(), setIndex);
        player.closeInventory();
        player.sendMessage(this.getMessage(player, "messages.rename-prompt", "&e\u270e &7Type the new name in chat:"));
        player.sendMessage(this.getMessage(player, "messages.rename-cancel", "&7Type &c'cancel' &7to cancel renaming."));
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        UUID id = player.getUniqueId();
        if (!this.renamingPlayers.containsKey(id)) {
            return;
        }
        event.setCancelled(true);
        String message = event.getMessage();
        if (message.equalsIgnoreCase("cancel")) {
            player.sendMessage(this.getMessage(player, "messages.rename-cancelled", "&c\u2716 &7Renaming cancelled"));
            this.renamingPlayers.remove(id);
            this.renamingSlots.remove(id);
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.openWardrobeGUI(player, this.currentPages.getOrDefault(id, 1)));
            return;
        }
        int maxLength = Math.max(1, this.config.getInt("settings.max-name-length", 16));
        int minLength = Math.max(1, this.config.getInt("settings.min-name-length", 3));
        if (message.length() > maxLength) {
            player.sendMessage(this.getMessage(player, "errors.name-too-long", "&c\u2716 &7Name too long! (Max &b{max}&7 chars)").replace("{max}", String.valueOf(maxLength)));
            return;
        }
        if (message.length() < minLength) {
            player.sendMessage(this.getMessage(player, "errors.name-too-short", "&c\u2716 &7Name too short! (Min &b{min}&7 chars)").replace("{min}", String.valueOf(minLength)));
            return;
        }
        Integer slot = this.renamingSlots.get(id);
        List<ArmorSet> armorSets = this.playerArmorSets.get(id);
        if (slot == null || armorSets == null || slot < 0 || slot >= armorSets.size()) {
            player.sendMessage(this.colorize(this.getMessage(player, "errors.rename-failed-find", "&c\u2716 &7Failed to find the set to rename.")));
            this.renamingPlayers.remove(id);
            this.renamingSlots.remove(id);
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.openWardrobeGUI(player, this.currentPages.getOrDefault(id, 1)));
            return;
        }
        ArmorSet set = armorSets.get(slot);
        if (set == null) {
            player.sendMessage(this.colorize(this.getMessage(player, "errors.rename-failed-find", "&c\u2716 &7Failed to find the set to rename.")));
            this.renamingPlayers.remove(id);
            this.renamingSlots.remove(id);
            Bukkit.getScheduler().runTask((Plugin)this, () -> this.openWardrobeGUI(player, this.currentPages.getOrDefault(id, 1)));
            return;
        }
        set.setName(message);
        this.savePlayerData();
        player.sendMessage(this.getMessage(player, "messages.renamed", "&a\u270e &7Renamed to &b{new}&7!").replace("{new}", message));
        this.playSound(player, "sounds.save");
        this.renamingPlayers.remove(id);
        this.renamingSlots.remove(id);
        Bukkit.getScheduler().runTask((Plugin)this, () -> this.openWardrobeGUI(player, this.currentPages.getOrDefault(id, 1)));
    }

    private void saveArmorSet(Player player, int globalIndex) {
        List armorSets = this.playerArmorSets.computeIfAbsent(player.getUniqueId(), k -> new ArrayList());
        int maxSets = this.config != null ? this.config.getInt("settings.max-armor-sets", 56) : 56;
        int existingCount = 0;
        for (ArmorSet s : armorSets) {
            if (s == null) continue;
            ++existingCount;
        }
        if (existingCount >= maxSets) {
            player.sendMessage(this.getMessage(player, "errors.max-sets", "&c\u2716 &7Maximum armor sets reached (&b{max}&7)!").replace("{max}", String.valueOf(maxSets)));
            return;
        }
        ItemStack[] currentArmor = player.getInventory().getArmorContents();
        boolean hasArmor = false;
        for (ItemStack item : currentArmor) {
            if (item == null || item.getType() == Material.AIR) continue;
            hasArmor = true;
            break;
        }
        if (!hasArmor) {
            player.sendMessage(this.getMessage(player, "errors.no-armor", "&c\u2716 &7You're not wearing any armor!"));
            return;
        }
        ItemStack[] snapshot = Arrays.copyOf(currentArmor, 4);
        player.getInventory().setArmorContents(new ItemStack[4]);
        while (armorSets.size() <= globalIndex) {
            armorSets.add(null);
        }
        ArmorSet newSet = new ArmorSet("Set #" + (globalIndex + 1), snapshot);
        armorSets.set(globalIndex, newSet);
        this.savePlayerData();
        player.sendMessage(this.getMessage(player, "messages.saved", "&a\u2714 &7Armor saved as &f{name}&7!").replace("{name}", newSet.getName()));
        this.playSound(player, "sounds.save");
        this.openWardrobeGUI(player, this.currentPages.getOrDefault(player.getUniqueId(), 1));
    }

    private void equipArmorSet(Player player, int globalIndex) {
        List armorSets = this.playerArmorSets.computeIfAbsent(player.getUniqueId(), k -> new ArrayList());
        if (globalIndex >= armorSets.size()) {
            return;
        }
        ArmorSet set = (ArmorSet)armorSets.get(globalIndex);
        if (set == null) {
            return;
        }
        ItemStack[] currentArmor = player.getInventory().getArmorContents();
        int emptySlots = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item != null && item.getType() != Material.AIR) continue;
            ++emptySlots;
        }
        boolean needsStorage = false;
        for (ItemStack item : currentArmor) {
            if (item == null || item.getType() == Material.AIR) continue;
            needsStorage = true;
            break;
        }
        if (needsStorage && emptySlots < 4) {
            player.sendMessage(this.getMessage(player, "errors.full-inventory", "&c\u2716 &7Clear inventory space first!"));
            return;
        }
        if (needsStorage) {
            for (ItemStack item : currentArmor) {
                if (item == null || item.getType() == Material.AIR) continue;
                player.getInventory().addItem(new ItemStack[]{item});
            }
        }
        player.getInventory().setArmorContents(Arrays.copyOf(set.getArmor(), 4));
        armorSets.set(globalIndex, null);
        this.savePlayerData();
        player.sendMessage(this.getMessage(player, "messages.loaded", "&a\u2726 &7Equipped &b{name}&7!").replace("{name}", set.getName()));
        this.playSound(player, "sounds.equip");
        if (this.config != null && this.config.getBoolean("settings.enable-animations", true)) {
            this.showEquipParticles(player);
        }
        this.openWardrobeGUI(player, this.currentPages.getOrDefault(player.getUniqueId(), 1));
    }

    private void showEquipParticles(final Player player) {
        new BukkitRunnable(){
            int count = 0;
            final int maxCount;
            final Particle particle;
            {
                this.maxCount = Math.max(1, RayzWardrobe.this.config != null ? RayzWardrobe.this.config.getInt("particles.count", 25) : 25);
                this.particle = PARTICLE_MAP.getOrDefault(RayzWardrobe.this.config != null ? RayzWardrobe.this.config.getString("particles.equip-effect", "CLOUD") : "CLOUD", Particle.CLOUD);
            }

            public void run() {
                if (this.count >= this.maxCount) {
                    this.cancel();
                    return;
                }
                double offsetX = RayzWardrobe.this.config != null ? RayzWardrobe.this.config.getDouble("particles.offset-x", 0.3) : 0.3;
                double offsetY = RayzWardrobe.this.config != null ? RayzWardrobe.this.config.getDouble("particles.offset-y", 0.5) : 0.5;
                double offsetZ = RayzWardrobe.this.config != null ? RayzWardrobe.this.config.getDouble("particles.offset-z", 0.3) : 0.3;
                player.spawnParticle(this.particle, player.getLocation().add(0.0, 1.0, 0.0), Math.max(1, this.maxCount / 5), offsetX, offsetY, offsetZ, 0.1, null, true);
                ++this.count;
            }
        }.runTaskTimer((Plugin)this, 0L, 2L);
    }

    private ItemStack quickItem(Material mat, String name) {
        ItemStack is = new ItemStack(mat);
        ItemMeta im = is.getItemMeta();
        if (im != null) {
            im.setDisplayName(name);
            is.setItemMeta(im);
        }
        return is;
    }

    private ItemStack emptyArmorPlaceholder(Player player, Material color) {
        ItemStack placeholder = new ItemStack(color != null ? color : Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = placeholder.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.getMessage(player, "gui.buttons.empty-armor-slot", "&cEmpty Slot"));
            placeholder.setItemMeta(meta);
        }
        return placeholder;
    }

    private ItemStack defaultIfNull(Player player, ItemStack stack) {
        if (stack != null && stack.getType() != Material.AIR) {
            return stack;
        }
        ItemStack placeholder = new ItemStack(Material.LIGHT_GRAY_STAINED_GLASS_PANE);
        ItemMeta meta = placeholder.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(this.getMessage(player, "gui.buttons.empty-placeholder", "&7(Empty)"));
            placeholder.setItemMeta(meta);
        }
        return placeholder;
    }

    private void playSound(Player player, String configPath) {
        if (this.config == null) {
            return;
        }
        if (!this.config.getBoolean("sounds.enabled", true)) {
            return;
        }
        Sound sound = SOUND_MAP.getOrDefault(this.config.getString(configPath, "BLOCK_CHEST_OPEN"), Sound.BLOCK_CHEST_OPEN);
        player.playSound(player.getLocation(), sound, SoundCategory.PLAYERS, (float)this.config.getDouble("sounds.volume", 0.8), (float)this.config.getDouble("sounds.pitch", 1.0));
    }

    private boolean isInThemeGrid(int slot) {
        int[] themeGridSlots;
        for (int s : themeGridSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34}) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    private Theme findThemeByName(String displayName) {
        if (displayName == null) {
            return null;
        }
        for (Theme t : this.themeRegistry.values()) {
            if (!t.name.equalsIgnoreCase(displayName)) continue;
            return t;
        }
        return null;
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private Material matOrDefault(String name, Material def) {
        if (name == null || name.isEmpty()) {
            return def;
        }
        Material m = Material.matchMaterial((String)name);
        return m != null ? m : def;
    }

    private static class ArmorSet {
        private String name;
        private final ItemStack[] armor;

        public ArmorSet(String name, ItemStack[] armor) {
            this.name = name != null ? name : "Unnamed";
            this.armor = armor != null ? armor : new ItemStack[4];
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name != null ? name : this.name;
        }

        public ItemStack[] getArmor() {
            return this.armor;
        }
    }

    private static class Theme {
        String key;
        String name;
        int slot;
        String permission;
        Material icon;
        Material background;
        Material primary;
        Material secondary;
        Material emptySlotIcon;
        Material lockedIcon;
        String headOwner;
        String headTexture;

        private Theme() {
        }
    }
}

