/*
 * Decompiled with CFR 0.152.
 */
package org.rayz.rayzWardrobe;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class RayzWardrobe
extends JavaPlugin
implements Listener {
    private static final Map<String, Sound> SOUND_MAP = Map.of("BLOCK_CHEST_OPEN", Sound.BLOCK_CHEST_OPEN, "ENTITY_PLAYER_LEVELUP", Sound.ENTITY_PLAYER_LEVELUP, "ITEM_ARMOR_EQUIP_NETHERITE", Sound.ITEM_ARMOR_EQUIP_NETHERITE);
    private static final Map<String, Particle> PARTICLE_MAP = Map.of("CLOUD", Particle.CLOUD, "HEART", Particle.HEART, "FLAME", Particle.FLAME);
    private FileConfiguration config;
    private FileConfiguration messages;
    private File configFile;
    private File messagesFile;
    private Map<UUID, Long> cooldowns = new HashMap<UUID, Long>();
    private Map<UUID, String> renamingPlayers = new HashMap<UUID, String>();
    private Map<UUID, Integer> renamingSlots = new HashMap<UUID, Integer>();
    private Map<UUID, List<ArmorSet>> playerArmorSets = new HashMap<UUID, List<ArmorSet>>();
    private Map<UUID, Integer> currentPages = new HashMap<UUID, Integer>();

    public void onEnable() {
        this.createFiles();
        if (this.messages == null) {
            this.getLogger().severe("Disabling plugin - messages file could not be loaded!");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.saveDefaultConfig();
        this.loadPlayerData();
        String version = this.getDescription().getVersion();
        String enableMsg = this.getMessage("console.enable", "&a[RayzWardrobe] &fEnabled! &b(v{version})").replace("{version}", version);
        this.getLogger().info(enableMsg);
    }

    public void onDisable() {
        this.savePlayerData();
        String disableMsg = this.getMessage("console.disable", "&c[RayzWardrobe] &fSaving all data...");
        this.getLogger().info(disableMsg);
    }

    private void createFiles() {
        this.configFile = new File(this.getDataFolder(), "config.yml");
        this.messagesFile = new File(this.getDataFolder(), "messages_en.yml");
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.saveResource("config.yml", false);
        }
        if (!this.messagesFile.exists()) {
            this.messagesFile.getParentFile().mkdirs();
            this.saveResource("messages_en.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
        if (this.messages == null) {
            this.getLogger().severe("Failed to load messages file!");
        }
    }

    private void loadMessages() {
        try {
            if (this.messagesFile != null && this.messagesFile.exists()) {
                this.messages.load(this.messagesFile);
            } else {
                this.getLogger().warning("Messages file not found at: " + (this.messagesFile != null ? this.messagesFile.getPath() : "null"));
            }
        }
        catch (Exception e) {
            this.getLogger().severe("Failed to load messages file: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private String getMessage(String path, String def) {
        return this.messages != null ? this.colorize(this.messages.getString(path, def)) : this.colorize(def);
    }

    private void loadPlayerData() {
        File dataFolder = new File(this.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
            return;
        }
        int count = 0;
        File[] playerFiles = dataFolder.listFiles();
        if (playerFiles != null) {
            for (File file : playerFiles) {
                if (!file.getName().endsWith(".yml")) continue;
                try {
                    String uuidStr = file.getName().replace(".yml", "");
                    UUID uuid = UUID.fromString(uuidStr);
                    YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)file);
                    ArrayList<ArmorSet> armorSets = new ArrayList<ArmorSet>();
                    for (String key : playerConfig.getKeys(false)) {
                        String name = playerConfig.getString(key + ".name");
                        ItemStack[] armor = new ItemStack[4];
                        for (int i = 0; i < 4; ++i) {
                            armor[i] = playerConfig.getItemStack(key + ".armor." + i);
                        }
                        armorSets.add(new ArmorSet(name, armor));
                    }
                    this.playerArmorSets.put(uuid, armorSets);
                    ++count;
                }
                catch (Exception e) {
                    this.getLogger().warning("Failed to load player data from " + file.getName() + ": " + e.getMessage());
                }
            }
        }
        String loadedMsg = this.getMessage("console.loaded-data", "&7Loaded data for &b{count} &7players").replace("{count}", String.valueOf(count));
        this.getLogger().info(loadedMsg);
    }

    private void savePlayerData() {
        File dataFolder = new File(this.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        int count = 0;
        for (Map.Entry<UUID, List<ArmorSet>> entry : this.playerArmorSets.entrySet()) {
            try {
                File playerFile = new File(dataFolder, entry.getKey().toString() + ".yml");
                YamlConfiguration playerConfig = new YamlConfiguration();
                List<ArmorSet> armorSets = entry.getValue();
                for (int i = 0; i < armorSets.size(); ++i) {
                    ArmorSet set = armorSets.get(i);
                    playerConfig.set(i + ".name", (Object)set.getName());
                    for (int j = 0; j < 4; ++j) {
                        playerConfig.set(i + ".armor." + j, (Object)set.getArmor()[j]);
                    }
                }
                playerConfig.save(playerFile);
                ++count;
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to save data for player " + String.valueOf(entry.getKey()) + ": " + e.getMessage());
            }
        }
        String savedMsg = this.getMessage("console.saved-data", "&7Saved data for &b{count} &7players").replace("{count}", String.valueOf(count));
        this.getLogger().info(savedMsg);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("wardrobe")) {
            long secondsLeft;
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.getMessage("errors.only-players", "&c\u2716 &7Only players can use &bRayzWardrobe&7!"));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("rayzwardrobe.use")) {
                player.sendMessage(this.getMessage("errors.no-permission", "&c\u2716 &7You need &brayzwardrobe.use &7permission!"));
                return true;
            }
            if (this.cooldowns.containsKey(player.getUniqueId()) && (secondsLeft = this.cooldowns.get(player.getUniqueId()) / 1000L + (long)this.config.getInt("settings.cooldown-seconds") - System.currentTimeMillis() / 1000L) > 0L) {
                String cooldownMsg = this.getMessage("errors.cooldown", "&c\u23f3 &7Please wait &b{time}s &7before using again!").replace("{time}", String.valueOf(secondsLeft));
                player.sendMessage(cooldownMsg);
                return true;
            }
            this.cooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            this.openWardrobeGUI(player, 1);
            return true;
        }
        return false;
    }

    private void openWardrobeGUI(Player player, int page) {
        int i;
        this.currentPages.put(player.getUniqueId(), page);
        int maxSetsPerPage = 7;
        List armorSets = this.playerArmorSets.getOrDefault(player.getUniqueId(), new ArrayList());
        int totalPages = (int)Math.ceil((double)armorSets.size() / (double)maxSetsPerPage);
        Inventory gui = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)this.getMessage("gui.title", "&6&l\u26a1 &bRayz&3Wardrobe &8| &7Page {page}/{total}").replace("{page}", String.valueOf(page)).replace("{total}", String.valueOf(totalPages == 0 ? 1 : totalPages)));
        ItemStack background = new ItemStack(Material.GRAY_STAINED_GLASS_PANE);
        ItemMeta bgMeta = background.getItemMeta();
        bgMeta.setDisplayName(" ");
        background.setItemMeta(bgMeta);
        for (i = 0; i < 54; ++i) {
            if (i >= 10 && i <= 16 || i >= 19 && i <= 25 || i >= 28 && i <= 34 || i == 48 || i == 50) continue;
            gui.setItem(i, background);
        }
        if (page > 1) {
            ItemStack prevPage = new ItemStack(Material.ARROW);
            ItemMeta prevMeta = prevPage.getItemMeta();
            prevMeta.setDisplayName(this.getMessage("gui.buttons.previous", "&aPrevious Page"));
            prevPage.setItemMeta(prevMeta);
            gui.setItem(48, prevPage);
        }
        if (armorSets.size() > page * maxSetsPerPage) {
            ItemStack nextPage = new ItemStack(Material.ARROW);
            ItemMeta nextMeta = nextPage.getItemMeta();
            nextMeta.setDisplayName(this.getMessage("gui.buttons.next", "&aNext Page"));
            nextPage.setItemMeta(nextMeta);
            gui.setItem(50, nextPage);
        }
        for (i = 0; i < maxSetsPerPage; ++i) {
            int setIndex = i + (page - 1) * maxSetsPerPage;
            if (setIndex < armorSets.size()) {
                ArmorSet set = (ArmorSet)armorSets.get(setIndex);
                gui.setItem(10 + i, set.getArmor()[3]);
                gui.setItem(19 + i, set.getArmor()[2]);
                gui.setItem(28 + i, set.getArmor()[1]);
                gui.setItem(37 + i, set.getArmor()[0]);
                ItemStack equipButton = new ItemStack(Material.LIME_DYE);
                ItemMeta equipMeta = equipButton.getItemMeta();
                equipMeta.setDisplayName(this.getMessage("gui.buttons.equip", "&aEquip &7{name}").replace("{name}", set.getName()));
                equipButton.setItemMeta(equipMeta);
                gui.setItem(46 + i, equipButton);
                continue;
            }
            ItemStack emptySlot = new ItemStack(Material.BARRIER);
            ItemMeta emptyMeta = emptySlot.getItemMeta();
            emptyMeta.setDisplayName(this.getMessage("gui.buttons.empty-slot", "&7Empty Slot"));
            emptySlot.setItemMeta(emptyMeta);
            gui.setItem(10 + i, emptySlot);
            gui.setItem(19 + i, emptySlot);
            gui.setItem(28 + i, emptySlot);
            gui.setItem(37 + i, emptySlot);
            ItemStack saveButton = new ItemStack(Material.EMERALD);
            ItemMeta saveMeta = saveButton.getItemMeta();
            saveMeta.setDisplayName(this.getMessage("gui.buttons.save", "&aSave Armor Here"));
            saveButton.setItemMeta(saveMeta);
            gui.setItem(46 + i, saveButton);
        }
        player.openInventory(gui);
        if (this.config.getBoolean("sounds.enabled", true)) {
            this.playSound(player, "sounds.open");
        }
    }

    private void playSound(Player player, String configPath) {
        if (this.config.getBoolean("sounds.enabled", true)) {
            Sound sound = SOUND_MAP.getOrDefault(this.config.getString(configPath, "BLOCK_CHEST_OPEN"), Sound.BLOCK_CHEST_OPEN);
            player.playSound(player.getLocation(), sound, SoundCategory.PLAYERS, (float)this.config.getDouble("sounds.volume", 0.8), (float)this.config.getDouble("sounds.pitch", 1.0));
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        String guiTitle;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String inventoryTitle = event.getView().getTitle();
        if (inventoryTitle.startsWith((guiTitle = this.getMessage("gui.title", "&6&l\u26a1 &bRayz&3Wardrobe &8| &7Page {page}/{total}")).substring(0, 10))) {
            event.setCancelled(true);
            if (event.getCurrentItem() == null || event.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            int slot = event.getSlot();
            int currentPage = this.currentPages.getOrDefault(player.getUniqueId(), 1);
            List armorSets = this.playerArmorSets.computeIfAbsent(player.getUniqueId(), k -> new ArrayList());
            int maxSetsPerPage = 7;
            int setIndex = (currentPage - 1) * maxSetsPerPage + (slot - 46);
            if (slot == 48 && currentPage > 1) {
                this.openWardrobeGUI(player, currentPage - 1);
                return;
            }
            if (slot == 50 && armorSets.size() > currentPage * maxSetsPerPage) {
                this.openWardrobeGUI(player, currentPage + 1);
                return;
            }
            if (slot >= 46 && slot <= 52) {
                int setSlot = slot - 46;
                int globalSetIndex = (currentPage - 1) * maxSetsPerPage + setSlot;
                if (globalSetIndex < armorSets.size()) {
                    this.equipArmorSet(player, (ArmorSet)armorSets.get(globalSetIndex));
                } else {
                    this.saveArmorSet(player, setSlot + (currentPage - 1) * maxSetsPerPage);
                }
                return;
            }
            if (event.isRightClick() && (slot >= 10 && slot <= 16 || slot >= 19 && slot <= 25 || slot >= 28 && slot <= 34 || slot >= 37 && slot <= 43)) {
                int globalSetIndex;
                int setSlot = -1;
                if (slot >= 10 && slot <= 16) {
                    setSlot = slot - 10;
                } else if (slot >= 19 && slot <= 25) {
                    setSlot = slot - 19;
                } else if (slot >= 28 && slot <= 34) {
                    setSlot = slot - 28;
                } else if (slot >= 37 && slot <= 43) {
                    setSlot = slot - 37;
                }
                if (setSlot != -1 && (globalSetIndex = (currentPage - 1) * maxSetsPerPage + setSlot) < armorSets.size()) {
                    this.startRenamingProcess(player, globalSetIndex);
                }
            }
        }
    }

    private void saveArmorSet(Player player, int slot) {
        List armorSets = this.playerArmorSets.computeIfAbsent(player.getUniqueId(), k -> new ArrayList());
        int maxSets = this.config.getInt("settings.max-armor-sets", 28);
        if (armorSets.size() >= maxSets) {
            player.sendMessage(this.getMessage("errors.max-sets", "&c\u2716 &7Maximum armor sets reached (&b{max}&7)!").replace("{max}", String.valueOf(maxSets)));
            return;
        }
        ItemStack[] currentArmor = player.getInventory().getArmorContents();
        boolean hasArmor = false;
        for (ItemStack item : currentArmor) {
            if (item == null || item.getType() == Material.AIR) continue;
            hasArmor = true;
            break;
        }
        if (!hasArmor) {
            player.sendMessage(this.getMessage("errors.no-armor", "&c\u2716 &7You're not wearing any armor!"));
            return;
        }
        for (int i = 0; i < currentArmor.length; ++i) {
            if (currentArmor[i] == null || currentArmor[i].getType() == Material.AIR) continue;
            player.getInventory().setArmorContents(new ItemStack[4]);
            break;
        }
        ArmorSet newSet = new ArmorSet("Set #" + (armorSets.size() + 1), currentArmor);
        armorSets.add(newSet);
        this.savePlayerData();
        player.sendMessage(this.getMessage("messages.saved", "&a\u2714 &7Armor saved as &f{name}&7!").replace("{name}", newSet.getName()));
        this.playSound(player, "sounds.save");
        player.closeInventory();
        this.openWardrobeGUI(player, this.currentPages.getOrDefault(player.getUniqueId(), 1));
    }

    private void equipArmorSet(Player player, ArmorSet set) {
        ItemStack[] currentArmor = player.getInventory().getArmorContents();
        int emptySlots = 0;
        for (ItemStack item : player.getInventory().getContents()) {
            if (item != null && item.getType() != Material.AIR) continue;
            ++emptySlots;
        }
        boolean needsStorage = false;
        for (ItemStack item : currentArmor) {
            if (item == null || item.getType() == Material.AIR) continue;
            needsStorage = true;
            break;
        }
        if (needsStorage && emptySlots < 4) {
            player.sendMessage(this.getMessage("errors.full-inventory", "&c\u2716 &7Clear inventory space first!"));
            return;
        }
        if (needsStorage) {
            for (ItemStack item : currentArmor) {
                if (item == null || item.getType() == Material.AIR) continue;
                player.getInventory().addItem(new ItemStack[]{item});
            }
        }
        player.getInventory().setArmorContents(set.getArmor());
        List<ArmorSet> armorSets = this.playerArmorSets.get(player.getUniqueId());
        armorSets.remove(set);
        this.savePlayerData();
        player.sendMessage(this.getMessage("messages.loaded", "&a\u2726 &7Equipped &b{name}&7!").replace("{name}", set.getName()));
        this.playSound(player, "sounds.equip");
        if (this.config.getBoolean("settings.enable-animations", true)) {
            this.showEquipParticles(player);
        }
        player.closeInventory();
        this.openWardrobeGUI(player, this.currentPages.getOrDefault(player.getUniqueId(), 1));
    }

    private void showEquipParticles(final Player player) {
        new BukkitRunnable(){
            int count = 0;
            int maxCount;
            Particle particle;
            {
                this.maxCount = RayzWardrobe.this.config.getInt("particles.count", 25);
                this.particle = PARTICLE_MAP.getOrDefault(RayzWardrobe.this.config.getString("particles.equip-effect", "CLOUD"), Particle.CLOUD);
            }

            public void run() {
                if (this.count >= this.maxCount) {
                    this.cancel();
                    return;
                }
                double offsetX = RayzWardrobe.this.config.getDouble("particles.offset-x", 0.3);
                double offsetY = RayzWardrobe.this.config.getDouble("particles.offset-y", 0.5);
                double offsetZ = RayzWardrobe.this.config.getDouble("particles.offset-z", 0.3);
                player.spawnParticle(this.particle, player.getLocation().add(0.0, 1.0, 0.0), this.maxCount / 5, offsetX, offsetY, offsetZ, 0.1, null, true);
                ++this.count;
            }
        }.runTaskTimer((Plugin)this, 0L, 2L);
    }

    private void startRenamingProcess(Player player, int slot) {
        this.renamingPlayers.put(player.getUniqueId(), this.playerArmorSets.get(player.getUniqueId()).get(slot).getName());
        this.renamingSlots.put(player.getUniqueId(), slot);
        player.closeInventory();
        Inventory renameGUI = Bukkit.createInventory((InventoryHolder)player, (int)9, (String)this.getMessage("gui.rename-title", "&e&l\u270f &fRename Armor Set"));
        player.openInventory(renameGUI);
        player.sendMessage(this.getMessage("messages.rename-prompt", "&e\u270e &7Type the new name in chat:"));
    }

    @EventHandler
    public void onPlayerChat(PlayerChatEvent event) {
        Player player = event.getPlayer();
        if (this.renamingPlayers.containsKey(player.getUniqueId())) {
            List<ArmorSet> armorSets;
            event.setCancelled(true);
            String newName = event.getMessage();
            int maxLength = this.config.getInt("settings.max-name-length", 16);
            if (newName.length() > maxLength) {
                player.sendMessage(this.getMessage("errors.name-too-long", "&c\u2716 &7Name too long! (Max &b{max}&7 chars)").replace("{max}", String.valueOf(maxLength)));
                this.renamingPlayers.remove(player.getUniqueId());
                this.renamingSlots.remove(player.getUniqueId());
                this.openWardrobeGUI(player, this.currentPages.getOrDefault(player.getUniqueId(), 1));
                return;
            }
            int slot = this.renamingSlots.get(player.getUniqueId());
            if (slot < (armorSets = this.playerArmorSets.get(player.getUniqueId())).size()) {
                ArmorSet set = armorSets.get(slot);
                set.setName(newName);
                this.savePlayerData();
                player.sendMessage(this.getMessage("messages.renamed", "&a\u270e &7Renamed to &b{new}&7!").replace("{new}", newName));
                this.playSound(player, "sounds.save");
            }
            this.renamingPlayers.remove(player.getUniqueId());
            this.renamingSlots.remove(player.getUniqueId());
            this.openWardrobeGUI(player, this.currentPages.getOrDefault(player.getUniqueId(), 1));
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        String renameTitle;
        final Player player = (Player)event.getPlayer();
        String inventoryTitle = event.getView().getTitle();
        if (inventoryTitle.equals(renameTitle = this.getMessage("gui.rename-title", "&e&l\u270f &fRename Armor Set")) && this.renamingPlayers.containsKey(player.getUniqueId())) {
            player.sendMessage(this.getMessage("messages.rename-cancelled", "&c\u2716 &7Renaming cancelled"));
            this.renamingPlayers.remove(player.getUniqueId());
            this.renamingSlots.remove(player.getUniqueId());
            new BukkitRunnable(){

                public void run() {
                    RayzWardrobe.this.openWardrobeGUI(player, RayzWardrobe.this.currentPages.getOrDefault(player.getUniqueId(), 1));
                }
            }.runTaskLater((Plugin)this, 1L);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (this.playerArmorSets.containsKey(uuid)) {
            this.savePlayerData();
        }
        if (this.renamingPlayers.containsKey(uuid)) {
            this.renamingPlayers.remove(uuid);
            this.renamingSlots.remove(uuid);
        }
        this.cooldowns.remove(uuid);
        this.currentPages.remove(uuid);
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private static class ArmorSet {
        private String name;
        private final ItemStack[] armor;

        public ArmorSet(String name, ItemStack[] armor) {
            this.name = name;
            this.armor = armor;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public ItemStack[] getArmor() {
            return this.armor;
        }
    }
}

