/*
 * Decompiled with CFR 0.152.
 */
package org.rayz.rayzWardrobe;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.rayz.rayzWardrobe.RayzWardrobe;

public class MySQLManager {
    public final RayzWardrobe plugin;
    private Connection connection;

    public MySQLManager(RayzWardrobe plugin) {
        this.plugin = plugin;
    }

    public boolean connect() {
        FileConfiguration config = this.plugin.getConfig();
        String host = config.getString("mysql.host", "localhost");
        int port = config.getInt("mysql.port", 3306);
        String database = config.getString("mysql.database", "minecraft");
        String username = config.getString("mysql.username", "root");
        String password = config.getString("mysql.password", "");
        boolean useSSL = config.getBoolean("mysql.useSSL", false);
        try {
            String url = "jdbc:mysql://" + host + ":" + port + "/" + database + "?useSSL=" + useSSL + "&autoReconnect=true";
            this.connection = DriverManager.getConnection(url, username, password);
            this.createTables();
            this.plugin.getLogger().info("Successfully connected to MySQL database!");
            return true;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Could not connect to MySQL database!", e);
            return false;
        }
    }

    public void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.plugin.getLogger().info("Disconnected from MySQL database!");
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Error closing MySQL connection!", e);
            }
        }
    }

    public Connection getConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connect();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error checking MySQL connection!", e);
        }
        return this.connection;
    }

    private void createTables() {
        try (Connection conn = this.getConnection();
             Statement stmt = conn.createStatement();){
            String armorSetsTable = "CREATE TABLE IF NOT EXISTS rayzwardrobe_armor_sets (id INT AUTO_INCREMENT PRIMARY KEY,player_uuid VARCHAR(36) NOT NULL,set_index INT NOT NULL,name VARCHAR(255) NOT NULL,helmet TEXT,chestplate TEXT,leggings TEXT,boots TEXT,UNIQUE KEY unique_player_set (player_uuid, set_index))";
            String playerThemesTable = "CREATE TABLE IF NOT EXISTS rayzwardrobe_player_themes (id INT AUTO_INCREMENT PRIMARY KEY,player_uuid VARCHAR(36) NOT NULL UNIQUE,theme_key VARCHAR(255) NOT NULL DEFAULT 'classic')";
            stmt.execute(armorSetsTable);
            stmt.execute(playerThemesTable);
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Error creating MySQL tables!", e);
        }
    }
}

