/*
 * Decompiled with CFR 0.152.
 */
package org.rayz.rayzWardrobe.data;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.inventory.ItemStack;
import org.rayz.rayzWardrobe.RayzWardrobe;
import org.rayz.rayzWardrobe.data.DataManager;

public class FileDataManager
implements DataManager {
    private final RayzWardrobe plugin;

    public FileDataManager(RayzWardrobe plugin) {
        this.plugin = plugin;
    }

    @Override
    public List<RayzWardrobe.ArmorSet> loadPlayerArmorSets(UUID playerUUID) {
        ArrayList<RayzWardrobe.ArmorSet> armorSets = new ArrayList<RayzWardrobe.ArmorSet>();
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
            return armorSets;
        }
        File playerFile = new File(dataFolder, playerUUID.toString() + ".yml");
        if (!playerFile.exists()) {
            return armorSets;
        }
        try {
            YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
            Set keys = playerConfig.getKeys(false);
            for (String key : keys) {
                try {
                    int idx = Integer.parseInt(key);
                    String name = playerConfig.getString(key + ".name");
                    ItemStack[] armor = new ItemStack[4];
                    for (int i = 0; i < 4; ++i) {
                        armor[i] = playerConfig.getItemStack(key + ".armor." + i);
                    }
                    RayzWardrobe.ArmorSet set = new RayzWardrobe.ArmorSet((String)(name != null ? name : "Set #" + (idx + 1)), armor);
                    while (armorSets.size() <= idx) {
                        armorSets.add(null);
                    }
                    armorSets.set(idx, set);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load player data from " + playerFile.getName() + ": " + e.getMessage());
        }
        return armorSets;
    }

    @Override
    public void savePlayerArmorSets(UUID playerUUID, List<RayzWardrobe.ArmorSet> armorSets) {
        File dataFolder = new File(this.plugin.getDataFolder(), "data");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        try {
            int i;
            File playerFile = new File(dataFolder, playerUUID.toString() + ".yml");
            YamlConfiguration playerConfig = new YamlConfiguration();
            int lastIndex = -1;
            for (i = armorSets.size() - 1; i >= 0; --i) {
                if (armorSets.get(i) == null) continue;
                lastIndex = i;
                break;
            }
            for (i = 0; i <= lastIndex; ++i) {
                RayzWardrobe.ArmorSet set = armorSets.get(i);
                if (set == null) continue;
                playerConfig.set(i + ".name", (Object)set.getName());
                for (int j = 0; j < 4; ++j) {
                    playerConfig.set(i + ".armor." + j, (Object)set.getArmor()[j]);
                }
            }
            playerConfig.save(playerFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to save data for player " + String.valueOf(playerUUID) + ": " + e.getMessage());
        }
    }

    @Override
    public String loadPlayerTheme(UUID playerUUID) {
        File dataFolder = new File(this.plugin.getDataFolder(), "playerdata");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
            return "classic";
        }
        File themeFile = new File(dataFolder, playerUUID.toString() + ".yml");
        if (!themeFile.exists()) {
            return "classic";
        }
        try {
            YamlConfiguration themeConfig = YamlConfiguration.loadConfiguration((File)themeFile);
            return themeConfig.getString("selected-theme", "classic");
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to load theme for player " + String.valueOf(playerUUID));
            return "classic";
        }
    }

    @Override
    public void savePlayerTheme(UUID playerUUID, String themeKey) {
        File dataFolder = new File(this.plugin.getDataFolder(), "playerdata");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        try {
            File themeFile = new File(dataFolder, playerUUID.toString() + ".yml");
            YamlConfiguration themeConfig = new YamlConfiguration();
            themeConfig.set("selected-theme", (Object)themeKey);
            themeConfig.save(themeFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to save theme for player " + String.valueOf(playerUUID));
        }
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public void close() {
    }
}

