/*
 * Decompiled with CFR 0.152.
 */
package org.rayz.rayzWardrobe.data;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.inventory.ItemStack;
import org.rayz.rayzWardrobe.MySQLManager;
import org.rayz.rayzWardrobe.RayzWardrobe;
import org.rayz.rayzWardrobe.data.DataManager;
import org.rayz.rayzWardrobe.util.ItemSerializer;

public class MySQLDataManager
implements DataManager {
    private final MySQLManager mySQLManager;

    public MySQLDataManager(MySQLManager mySQLManager) {
        this.mySQLManager = mySQLManager;
    }

    @Override
    public List<RayzWardrobe.ArmorSet> loadPlayerArmorSets(UUID playerUUID) {
        ArrayList<RayzWardrobe.ArmorSet> armorSets = new ArrayList<RayzWardrobe.ArmorSet>();
        String query = "SELECT set_index, name, helmet, chestplate, leggings, boots FROM rayzwardrobe_armor_sets WHERE player_uuid = ? ORDER BY set_index";
        try (Connection conn = this.mySQLManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, playerUUID.toString());
            ResultSet rs = stmt.executeQuery();
            while (rs.next()) {
                int setIndex = rs.getInt("set_index");
                String name = rs.getString("name");
                ItemStack helmet = ItemSerializer.itemStackFromBase64(rs.getString("helmet"));
                ItemStack chestplate = ItemSerializer.itemStackFromBase64(rs.getString("chestplate"));
                ItemStack leggings = ItemSerializer.itemStackFromBase64(rs.getString("leggings"));
                ItemStack boots = ItemSerializer.itemStackFromBase64(rs.getString("boots"));
                ItemStack[] armor = new ItemStack[]{boots, leggings, chestplate, helmet};
                RayzWardrobe.ArmorSet set = new RayzWardrobe.ArmorSet(name, armor);
                while (armorSets.size() <= setIndex) {
                    armorSets.add(null);
                }
                armorSets.set(setIndex, set);
            }
        }
        catch (SQLException e) {
            this.mySQLManager.plugin.getLogger().log(Level.SEVERE, "Error loading armor sets from MySQL", e);
        }
        return armorSets;
    }

    @Override
    public void savePlayerArmorSets(UUID playerUUID, List<RayzWardrobe.ArmorSet> armorSets) {
        String deleteQuery = "DELETE FROM rayzwardrobe_armor_sets WHERE player_uuid = ?";
        try (Connection conn = this.mySQLManager.getConnection();
             PreparedStatement deleteStmt = conn.prepareStatement(deleteQuery);){
            deleteStmt.setString(1, playerUUID.toString());
            deleteStmt.executeUpdate();
        }
        catch (SQLException e) {
            this.mySQLManager.plugin.getLogger().log(Level.SEVERE, "Error deleting armor sets from MySQL", e);
            return;
        }
        String insertQuery = "INSERT INTO rayzwardrobe_armor_sets (player_uuid, set_index, name, helmet, chestplate, leggings, boots) VALUES (?, ?, ?, ?, ?, ?, ?)";
        try (Connection conn = this.mySQLManager.getConnection();
             PreparedStatement insertStmt = conn.prepareStatement(insertQuery);){
            for (int i = 0; i < armorSets.size(); ++i) {
                RayzWardrobe.ArmorSet set = armorSets.get(i);
                if (set == null) continue;
                insertStmt.setString(1, playerUUID.toString());
                insertStmt.setInt(2, i);
                insertStmt.setString(3, set.getName());
                insertStmt.setString(4, ItemSerializer.itemStackToBase64(set.getArmor()[3]));
                insertStmt.setString(5, ItemSerializer.itemStackToBase64(set.getArmor()[2]));
                insertStmt.setString(6, ItemSerializer.itemStackToBase64(set.getArmor()[1]));
                insertStmt.setString(7, ItemSerializer.itemStackToBase64(set.getArmor()[0]));
                insertStmt.addBatch();
            }
            insertStmt.executeBatch();
        }
        catch (SQLException e) {
            this.mySQLManager.plugin.getLogger().log(Level.SEVERE, "Error saving armor sets to MySQL", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String loadPlayerTheme(UUID playerUUID) {
        String query = "SELECT theme_key FROM rayzwardrobe_player_themes WHERE player_uuid = ?";
        try (Connection conn = this.mySQLManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, playerUUID.toString());
            ResultSet rs = stmt.executeQuery();
            if (!rs.next()) return "classic";
            String string = rs.getString("theme_key");
            return string;
        }
        catch (SQLException e) {
            this.mySQLManager.plugin.getLogger().log(Level.SEVERE, "Error loading player theme from MySQL", e);
        }
        return "classic";
    }

    @Override
    public void savePlayerTheme(UUID playerUUID, String themeKey) {
        String query = "INSERT INTO rayzwardrobe_player_themes (player_uuid, theme_key) VALUES (?, ?) ON DUPLICATE KEY UPDATE theme_key = ?";
        try (Connection conn = this.mySQLManager.getConnection();
             PreparedStatement stmt = conn.prepareStatement(query);){
            stmt.setString(1, playerUUID.toString());
            stmt.setString(2, themeKey);
            stmt.setString(3, themeKey);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            this.mySQLManager.plugin.getLogger().log(Level.SEVERE, "Error saving player theme to MySQL", e);
        }
    }

    @Override
    public boolean isReady() {
        return this.mySQLManager.getConnection() != null;
    }

    @Override
    public void close() {
        this.mySQLManager.disconnect();
    }
}

