/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks;

import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.data.config.ClientConfig;
import com.beansgalaxy.backpacks.items.ModBlocks;
import com.beansgalaxy.backpacks.items.ModItems;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ModSound;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class CommonClass {
    public static final Supplier<EntityType<BackpackEntity>> BACKPACK_ENTITY = Services.PLATFORM.register("backpack", EntityType.Builder.of(BackpackEntity::new, (MobCategory)MobCategory.MISC).sized(0.4375f, 0.5625f).eyeHeight(0.5f));
    public static final Supplier<EntityType<BackpackEntity>> LEGACY_ENDER_ENTITY = Services.PLATFORM.register("ender_backpack", EntityType.Builder.of(BackpackEntity::new, (MobCategory)MobCategory.MISC).sized(0.4375f, 0.5625f).eyeHeight(0.5f));
    public static final Supplier<EntityType<BackpackEntity>> LEGACY_WINGED_ENTITY = Services.PLATFORM.register("winged_backpack", EntityType.Builder.of(BackpackEntity::new, (MobCategory)MobCategory.MISC).sized(0.4375f, 0.5625f).eyeHeight(0.5f));
    public static final Supplier<Activity> CHESTER_ACTIVITY = Services.PLATFORM.registerActivity("chester");
    public static final Supplier<Activity> CHESTER_IDLE_ACTIVITY = Services.PLATFORM.registerActivity("chester_idle");
    public static final Supplier<MemoryModuleType<UUID>> BACKPACK_OWNER_MEMORY = Services.PLATFORM.registerMemoryModule("backpack_owner", UUIDUtil.CODEC);
    public static final ClientConfig CLIENT_CONFIG = new ClientConfig();

    public static void init() {
        ModSound.Events.register();
        Traits.register();
        ITraitData.register();
        ModItems.register();
        ModBlocks.register();
    }

    public static InteractionResult swapBackWith(ArmorStand armorStand, Player player) {
        EquipmentSlot slot = EquipmentSlot.BODY;
        ItemStack backpack = player.getItemBySlot(slot);
        ItemStack standItem = armorStand.getItemBySlot(slot);
        if (backpack.isEmpty() && standItem.isEmpty()) {
            return InteractionResult.FAIL;
        }
        armorStand.onEquipItem(slot, standItem, backpack);
        player.onEquipItem(slot, backpack, standItem);
        armorStand.setItemSlot(slot, backpack);
        player.setItemSlot(slot, standItem);
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult swapBackWith(Allay allay, Player player) {
        EquipmentSlot slot = EquipmentSlot.BODY;
        ItemStack backpack = player.getItemBySlot(slot);
        ItemStack standItem = allay.getItemBySlot(slot);
        if (backpack.isEmpty()) {
            if (standItem.isEmpty()) {
                return InteractionResult.FAIL;
            }
            allay.getBrain().eraseMemory(BACKPACK_OWNER_MEMORY.get());
        } else {
            Optional<GenericTraits> traitsOptional = Traits.get(backpack);
            if (traitsOptional.isEmpty()) {
                return InteractionResult.FAIL;
            }
            ItemStack itemInHand = allay.getItemInHand(InteractionHand.MAIN_HAND);
            if (!itemInHand.isEmpty() && !player.addItem(itemInHand)) {
                return InteractionResult.FAIL;
            }
            Brain brain = allay.getBrain();
            brain.setMemory(BACKPACK_OWNER_MEMORY.get(), (Object)player.getUUID());
            brain.setActiveActivityIfPossible(CHESTER_ACTIVITY.get());
        }
        allay.onEquipItem(slot, standItem, backpack);
        player.onEquipItem(slot, backpack, standItem);
        allay.setItemSlot(slot, backpack);
        player.setItemSlot(slot, standItem);
        return InteractionResult.SUCCESS;
    }

    public static void interactEquippedBackpack(LivingEntity owner, Player viewer, CallbackInfoReturnable<InteractionResult> cir) {
        double maxRadius;
        double radius;
        boolean looking;
        boolean yawMatches;
        ItemStack backpack = owner.getItemBySlot(EquipmentSlot.BODY);
        if (backpack.isEmpty()) {
            return;
        }
        double yaw = Math.abs(viewer.yHeadRot - owner.yBodyRot) % 360.0f - 180.0f;
        boolean bl = yawMatches = Math.abs(yaw) > 90.0;
        if (!yawMatches) {
            return;
        }
        Optional<GenericTraits> optional = Traits.get(backpack);
        if (optional.isEmpty()) {
            return;
        }
        double angleRadians = Math.toRadians(owner.yBodyRot);
        double offset = -0.3;
        double x = owner.getX();
        double z = owner.getZ();
        double offsetX = Math.cos(angleRadians) * offset;
        double offsetZ = Math.sin(angleRadians) * offset;
        double newX = x - offsetZ;
        double newY = owner.getEyeY() - 0.45;
        double newZ = z + offsetX;
        Vec3 vec3d = viewer.getViewVector(1.0f).normalize();
        Vec3 vec3d2 = new Vec3(newX - viewer.getX(), newY - viewer.getEyeY(), newZ - viewer.getZ());
        double d = -vec3d2.length() + 5.65;
        double e = vec3d.dot(vec3d2.normalize());
        boolean bl2 = looking = e > 1.0 - (radius = d * d * d * d / 625.0) * (maxRadius = 0.05) && viewer.hasLineOfSight((Entity)owner);
        if (!looking) {
            return;
        }
        GenericTraits traits = optional.get();
        traits.onPlayerInteract(owner, viewer, backpack, cir);
    }

    @NotNull
    public static String getTinyNumberFromDigitChar(char c) {
        return switch (c) {
            case '1' -> "\u2081";
            case '2' -> "\u2082";
            case '3' -> "\u2083";
            case '4' -> "\u2084";
            case '5' -> "\u2085";
            case '6' -> "\u2086";
            case '7' -> "\u2087";
            case '8' -> "\u2088";
            case '9' -> "\u2089";
            default -> "\u2080";
        };
    }

    public static void addAttributesToTooltip(Consumer<Component> pTooltipAdder, EquipmentSlotGroup slotGroup, MutableBoolean needsLabel, ItemStack backpack) {
        byte size;
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits != null && traits.slots().test(slotGroup)) {
            if (needsLabel.isTrue()) {
                pTooltipAdder.accept(CommonComponents.EMPTY);
                pTooltipAdder.accept((Component)Component.translatable((String)("item.modifiers." + slotGroup.getSerializedName())).withStyle(ChatFormatting.GRAY));
                needsLabel.setFalse();
            }
            traits.client().appendTooltipLines(traits, pTooltipAdder);
        }
        if (EquipmentSlotGroup.BODY.equals((Object)slotGroup) && (size = UtilityComponent.getSize(backpack)) != 0) {
            if (needsLabel.isTrue()) {
                pTooltipAdder.accept(CommonComponents.EMPTY);
                pTooltipAdder.accept((Component)Component.translatable((String)("item.modifiers." + slotGroup.getSerializedName())).withStyle(ChatFormatting.GRAY));
                needsLabel.setFalse();
            }
            MutableComponent translatable = Component.translatable((String)"traits.beansbackpacks.equipment.utility", (Object[])new Object[]{size});
            pTooltipAdder.accept((Component)translatable.withStyle(ChatFormatting.GOLD));
        }
    }
}

