/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.access.MinecraftAccessor;
import com.beansgalaxy.backpacks.client.KeyPress;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.container.BackSlot;
import com.beansgalaxy.backpacks.container.UtilitySlot;
import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.ISlotSelectorTrait;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.beansgalaxy.backpacks.util.SmoothRandomFloat;
import com.beansgalaxy.backpacks.util.Tint;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class CommonClient {
    public static final ItemStack UTILITY_DISPLAY_STAND_IN = new ItemStack((ItemLike)Items.AIR);
    public static final ClampedItemPropertyFunction UTILITIES_PREDICATE = (itemStack, clientLevel, livingEntity, i) -> {
        if (itemStack == UTILITY_DISPLAY_STAND_IN && clientLevel == null && livingEntity == null && i == 0) {
            return 1.0f;
        }
        return 0.0f;
    };
    public static final ClampedItemPropertyFunction EATING_TRAIT_ITEM_PREDICATE = (itemStack, clientLevel, livingEntity, i) -> livingEntity != null && livingEntity.isUsingItem() && livingEntity.getUseItem() == itemStack && LunchBoxTraits.get(itemStack) != null ? 1.0f : 0.0f;
    public static final ClampedItemPropertyFunction FULLNESS_ITEM_PREDICATE = (itemStack, clientLevel, livingEntity, i) -> {
        ComponentHolder holder;
        GenericTraits traits;
        Optional<GenericTraits> optional = Traits.get(itemStack);
        if (optional.isPresent()) {
            traits = optional.get();
            holder = ComponentHolder.of(itemStack);
        } else {
            EnderTraits enderTraits = (EnderTraits)itemStack.get(Traits.ENDER);
            if (enderTraits == null) {
                return 0.0f;
            }
            traits = enderTraits.getTrait((Level)clientLevel);
            holder = enderTraits;
        }
        if (traits.isFull(holder)) {
            return 1.0f;
        }
        Fraction fullness = traits.fullness(holder);
        if (traits.isEmpty(holder) || fullness.equals((Object)Fraction.ZERO)) {
            return 0.0f;
        }
        float v = fullness.floatValue();
        return v * 0.89f + 0.1f;
    };
    public static final ClampedItemPropertyFunction ENDER_SEARCHING_PREDICATE = (itemStack, clientLevel, livingEntity, i) -> {
        EnderTraits enderTraits = (EnderTraits)itemStack.get(Traits.ENDER);
        if (enderTraits == null || !enderTraits.isLoaded()) {
            return 1.0f;
        }
        return 0.0f;
    };
    public static final ItemColor LEATHER_BACKPACK_ITEM_COLOR = (itemStack, layer) -> switch (layer) {
        case 0 -> CommonClient.componentTint(itemStack, -7714783);
        case 2, 4 -> CommonClient.componentHighlight(itemStack, -7714783);
        default -> -1;
    };
    public static final ItemColor BUNDLE_ITEM_COLOR = (itemStack, layer) -> layer != 1 ? CommonClient.componentTint(itemStack, -3310778) : -1;
    public static final ResourceLocation BACK_SLOT = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"textures/gui/slots/back_slot.png");
    public static final ResourceLocation UTIL_SLOT = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"textures/gui/slots/util_slot.png");
    private static final CompassItemPropertyFunction COMPASS_FUNCTION = new CompassItemPropertyFunction((clientLevel, itemStack, entity) -> {
        LodestoneTracker lodestoneTracker = (LodestoneTracker)itemStack.get(DataComponents.LODESTONE_TRACKER);
        return lodestoneTracker != null ? (GlobalPos)lodestoneTracker.target().orElse(null) : CompassItem.getSpawnPosition((Level)clientLevel);
    });
    private static final CompassItemPropertyFunction RECOVERY_FUNCTION = new CompassItemPropertyFunction((clientLevel, itemStack, entity) -> {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getLastDeathLocation().orElse(null);
        }
        return null;
    });
    private static final SmoothRandomFloat firstFloat = new SmoothRandomFloat();
    private static final SmoothRandomFloat secondFloat = new SmoothRandomFloat();
    private static final ResourceLocation R_CLICK_ICON = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"r_click_icon");

    public static void init() {
    }

    private static int componentTint(ItemStack itemStack, int rgbBase) {
        DyedItemColor itemColor = (DyedItemColor)itemStack.get(DataComponents.DYED_COLOR);
        if (itemColor != null) {
            int rgbTint = itemColor.rgb();
            return CommonClient.smartAverageTint(rgbTint, rgbBase).rgb();
        }
        return rgbBase;
    }

    private static int componentHighlight(ItemStack itemStack, int rgbBase) {
        DyedItemColor itemColor = (DyedItemColor)itemStack.get(DataComponents.DYED_COLOR);
        int rgb = itemColor == null ? rgbBase : itemColor.rgb();
        Tint tint = new Tint(rgb);
        double brightness = tint.brightness();
        Tint.HSL hsl = tint.HSL();
        double lum = hsl.getLum();
        hsl.rotate(10.0);
        hsl.setLum((Math.pow(brightness, 4.0) + lum + 2.3 + (double)tint.getBlue() / 160.0) / 5.0);
        double sat = hsl.getSat();
        hsl.setSat((1.0 - brightness + sat) / 2.0);
        return hsl.rgb();
    }

    public static Tint.HSL smartAverageTint(int rgbTint, int rgbBase) {
        Tint tint = new Tint(rgbTint, true);
        tint.setAlpha(1.0f);
        Tint.HSL tintHsl = tint.HSL();
        tintHsl.modLum(l -> (Math.sqrt(l) + l) / 2.0);
        return tintHsl;
    }

    public static void playSound(SoundEvent soundEvent, float volume, float pitch) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)soundEvent, (float)pitch, (float)volume));
    }

    public static EnderStorage getEnderStorage() {
        MinecraftAccessor instance = (MinecraftAccessor)Minecraft.getInstance();
        return instance.beans_Backpacks_2$getEnder();
    }

    public static Level getLevel() {
        return Minecraft.getInstance().level;
    }

    public static void renderSlots(GuiGraphics graphics, int leftPos, int topPos, int imageWidth, int imageHeight, LocalPlayer player) {
        graphics.blit(BACK_SLOT, leftPos + BackSlot.getX() - 1, topPos + BackSlot.getY() - 1, 10, 0.0f, 0.0f, 18, 18, 18, 18);
        ItemStack backpack = player.getItemBySlot(EquipmentSlot.BODY);
        byte utilities = UtilityComponent.getSize(backpack);
        if (utilities > 0) {
            for (byte i = 0; i < utilities; i = (byte)(i + 1)) {
                graphics.blit(UTIL_SLOT, leftPos + UtilitySlot.getX(i) - 1, topPos + UtilitySlot.getY(i) - 1, 10, 0.0f, 0.0f, 18, 18, 18, 18);
            }
        }
    }

    public static void renderCompassClockHUD(Minecraft minecraft, GuiGraphics gui, Player player) {
        if (player == null || player.isSpectator() || minecraft.options.hideGui) {
            return;
        }
        ItemStack backpack = player.getItemBySlot(EquipmentSlot.BODY);
        UtilityComponent utilities = (UtilityComponent)backpack.get(ITraitData.UTILITIES);
        if (utilities == null) {
            return;
        }
        ClientLevel level = minecraft.level;
        boolean second = false;
        Iterator<ItemStack> iterator = utilities.iterator();
        while (iterator.hasNext()) {
            ResourceLocation clockLocation;
            ResourceLocation background;
            int compassFrame;
            float direction;
            ItemStack stack = iterator.next();
            int x = 8 + (second ? 24 : 0);
            if (UtilityComponent.Type.LODESTONE.test(stack)) {
                RenderSystem.enableBlend();
                direction = COMPASS_FUNCTION.unclampedCall(stack, level, (LivingEntity)player, 0);
                compassFrame = CommonClient.modCompassDirection(direction);
                background = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)("compass_background" + compassFrame));
                gui.blitSprite(background, x, 0, 32, 32);
                int pZ1 = 10;
                Optional target = ((LodestoneTracker)stack.get(DataComponents.LODESTONE_TRACKER)).target();
                CommonClient.drawYDifference("compass_lodestone", gui, player, target, x, 0, pZ1, second);
                RenderSystem.disableBlend();
                CommonClient.drawGlint(gui, x, pZ1);
                second = true;
                continue;
            }
            if (UtilityComponent.Type.RECOVERY.test(stack)) {
                RenderSystem.enableBlend();
                direction = RECOVERY_FUNCTION.unclampedCall(stack, level, (LivingEntity)player, 0);
                compassFrame = CommonClient.modCompassDirection(direction);
                clockLocation = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)("recovery_background" + compassFrame));
                gui.blitSprite(clockLocation, x, 0, 32, 32);
                CommonClient.drawYDifference("recovery_default", gui, player, player.getLastDeathLocation(), x, 0, 0, second);
                second = true;
                RenderSystem.disableBlend();
                continue;
            }
            if (UtilityComponent.Type.COMPASS.test(stack)) {
                RenderSystem.enableBlend();
                direction = COMPASS_FUNCTION.unclampedCall(stack, level, (LivingEntity)player, 0);
                compassFrame = CommonClient.modCompassDirection(direction);
                background = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)("compass_background" + compassFrame));
                gui.blitSprite(background, x, 0, 32, 32);
                int rotation = CommonClient.getPlayerRotation(player);
                ResourceLocation overlay = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)("compass_default" + rotation));
                gui.blitSprite(overlay, x, 0, 10, 32, 32);
                second = true;
                RenderSystem.disableBlend();
                continue;
            }
            if (!UtilityComponent.Type.CLOCK.test(stack)) continue;
            RenderSystem.enableBlend();
            float day = level.getTimeOfDay(1.0f);
            int clockFrame = Mth.floor((float)(day * 92.0f));
            clockLocation = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)("clock" + clockFrame));
            gui.blitSprite(clockLocation, x, 0, 32, 32);
            second = true;
            RenderSystem.disableBlend();
        }
    }

    /*
     * Exception decompiling
     */
    private static int getPlayerRotation(Player player) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithmeticOperation.applyExpressionRewriter(ArithmeticOperation.java:171)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void drawGlint(GuiGraphics gui, int x, int pZ1) {
        PoseStack pose = gui.pose();
        pose.pushPose();
        pose.translate((float)x, 0.0f, 0.0f);
        float scale = 0.03125f;
        Matrix4f matrix4f = pose.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(matrix4f, 0.0f, 0.0f, (float)pZ1).setUv(0.0f, 0.0f);
        bufferbuilder.addVertex(matrix4f, 0.0f, 32.0f, (float)pZ1).setUv(0.0f, scale);
        bufferbuilder.addVertex(matrix4f, 32.0f, 32.0f, (float)pZ1).setUv(scale, scale);
        bufferbuilder.addVertex(matrix4f, 32.0f, 0.0f, (float)pZ1).setUv(scale, 0.0f);
        MeshData data = bufferbuilder.buildOrThrow();
        RenderType.glint().draw(data);
        pose.popPose();
    }

    private static void drawYDifference(String prefix, GuiGraphics gui, Player player, Optional<GlobalPos> target, int pX1, int pY1, int pZ1, boolean second) {
        if (target.isPresent() && target.get().dimension().equals(player.level().dimension())) {
            GlobalPos pos = target.get();
            double v = (double)pos.pos().getY() - player.getY();
            double abs = Math.abs(v);
            int yFrame = abs < 8.0 ? 0 : (abs < 16.0 ? 1 : (abs < 32.0 ? 2 : (abs < 64.0 ? 3 : (abs < 128.0 ? 4 : 5))));
            if (v < 0.0) {
                yFrame *= -1;
            }
            ResourceLocation overlay = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)(prefix + (yFrame += 6)));
            gui.blitSprite(overlay, pX1, pY1, pZ1, 32, 32);
        } else {
            RandomSource random = player.getRandom();
            int fps = Minecraft.getInstance().getFps() + 2;
            SmoothRandomFloat aFloat = second ? secondFloat : firstFloat;
            float direction = aFloat.getDirection(random, fps);
            int yFrame = Mth.floor((float)(direction * 10.0f)) + 1;
            ResourceLocation overlay = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)(prefix + yFrame));
            gui.blitSprite(overlay, pX1, pY1, pZ1, 32, 32);
        }
    }

    private static int modCompassDirection(float d) {
        float f = (d + 0.5f) % 1.0f;
        double r = (double)f > 0.5 ? 1.0 - -(Math.cos(Math.PI * (double)(1.0f - f)) - 1.0) / 2.0 : ((double)f < 0.5 ? -(Math.cos(Math.PI * (double)f) - 1.0) / 2.0 : 0.5);
        return Mth.floor((double)(r * 58.0)) + 1;
    }

    public static void modifyBackpackKeyDisplay(Component name, Button changeButton) {
        KeyPress keyPress = KeyPress.INSTANCE;
        if (name.equals((Object)Component.translatable((String)"key.beansbackpacks.action"))) {
            if (keyPress.INSTANT_KEY.isUnbound()) {
                MutableComponent translatable = Component.translatable((String)"key.sprint");
                changeButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"key.beansbackpacks.desc.action", (Object[])new Object[]{translatable.plainCopy()})));
                if (keyPress.ACTION_KEY.isUnbound()) {
                    changeButton.setMessage((Component)translatable.withStyle(ChatFormatting.ITALIC));
                }
            } else {
                MutableComponent action = Component.translatable((String)"key.beansbackpacks.action");
                MutableComponent instant = Component.translatable((String)"key.beansbackpacks.instant");
                changeButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"key.beansbackpacks.desc.action_disabled", (Object[])new Object[]{action, instant})));
                MutableComponent disabledMessage = Component.translatable((String)"key.beansbackpacks.action_disabled");
                changeButton.setMessage((Component)disabledMessage.withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.RED}));
            }
            return;
        }
        if (name.equals((Object)Component.translatable((String)"key.beansbackpacks.inventory"))) {
            MutableComponent translatable = Component.translatable((String)"key.beansbackpacks.action");
            changeButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"key.beansbackpacks.desc.inventory", (Object[])new Object[]{translatable})));
            if (keyPress.MENUS_KEY.isUnbound()) {
                String boundKey = KeyPress.getMenusKeyBind().getName();
                changeButton.setMessage((Component)Component.translatable((String)boundKey).withStyle(ChatFormatting.ITALIC));
            }
            return;
        }
        if (name.equals((Object)Component.translatable((String)"key.beansbackpacks.instant"))) {
            MutableComponent translatable = Component.translatable((String)"key.beansbackpacks.action");
            changeButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"key.beansbackpacks.desc.instant", (Object[])new Object[]{translatable})));
            return;
        }
    }

    public static void handleKeyBinds(LocalPlayer player, @Nullable HitResult hitResult) {
        KeyPress keyPress = KeyPress.INSTANCE;
        while (keyPress.INSTANT_KEY.consumeClick()) {
            BlockHitResult blockHitResult;
            if (hitResult instanceof BlockHitResult && (KeyPress.placeBackpack((Player)player, blockHitResult = (BlockHitResult)hitResult) || keyPress.pickUpThru(player)) || !(hitResult instanceof EntityHitResult)) continue;
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            Entity hit = entityHitResult.getEntity();
            KeyPress.tryEquip(player, hit);
        }
        keyPress.handleUtility(player, hitResult);
    }

    public static Boolean cancelCapeRender(Player player) {
        ItemStack backpack = player.getItemBySlot(EquipmentSlot.BODY);
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits == null) {
            return false;
        }
        return true;
    }

    public static boolean scrollTraits(Player player, ItemStack stack, Level level, int containerId, int scrolled, Slot hoveredSlot) {
        GenericTraits traits;
        EnderTraits enderTraits;
        Optional<GenericTraits> optional;
        ISlotSelectorTrait trait = ISlotSelectorTrait.get(stack);
        if (trait != null) {
            ComponentHolder holder = ComponentHolder.of(stack);
            return trait.mouseScrolled(player, holder, hoveredSlot.index, containerId, scrolled);
        }
        Optional<EnderTraits> optionalEnder = EnderTraits.get(stack);
        if (optionalEnder.isPresent() && (optional = (enderTraits = optionalEnder.get()).getTrait()).isPresent() && (traits = optional.get()) instanceof ISlotSelectorTrait) {
            ISlotSelectorTrait storageTraits = (ISlotSelectorTrait)((Object)traits);
            return storageTraits.mouseScrolled(player, enderTraits, hoveredSlot.index, containerId, scrolled);
        }
        return false;
    }

    public static void renderItemDecorations(GuiGraphics gui, Font font, ItemStack pStack, int x, int y, int z) {
        if (!pStack.isEmpty()) {
            PoseStack pose = gui.pose();
            pose.translate(0.0f, 0.0f, (float)(z + 50));
            pose.pushPose();
            int count = pStack.getCount();
            if (count != 1) {
                String string = String.valueOf(count);
                if (count > 999) {
                    float k = (float)count / 1000.0f;
                    String s = (int)k + "k";
                    gui.drawString(font, s, x + 9 - font.width(s), y + 1, -1, true);
                } else if (count > 99) {
                    char[] chars = string.toCharArray();
                    for (int i1 = 0; i1 < chars.length; ++i1) {
                        char c = chars[i1];
                        String s = CommonClass.getTinyNumberFromDigitChar(c);
                        chars[i1] = s.toCharArray()[0];
                    }
                    String s = String.valueOf(chars);
                    gui.drawString(font, s, x + 10 - font.width(s), y - 1, -1, true);
                } else {
                    gui.drawString(font, string, x + 9 - font.width(string), y + 1, -1, true);
                }
            } else if (pStack.isBarVisible()) {
                int barColor = pStack.getBarColor();
                int barX = x - 6;
                int barY = y + 5;
                gui.fill(barX, barY, barX + 13, barY + 2, -16777216);
                gui.fill(barX, barY, barX + pStack.getBarWidth(), barY + 1, barColor | 0xFF000000);
            }
            Optional<GenericTraits> traitsOptional = Traits.get(pStack);
            if (traitsOptional.isPresent()) {
                GenericTraits traits = traitsOptional.get();
                traits.client().renderItemDecorations(traits, ComponentHolder.of(pStack), gui, font, pStack, x - 8, y - 8);
            }
            pose.popPose();
        }
    }

    public static void renderItem(Minecraft minecraft, GuiGraphics gui, ItemStack stack, int x, int y, int z, boolean drawShadows) {
        PoseStack pose = gui.pose();
        pose.pushPose();
        BakedModel model = minecraft.getItemRenderer().getModel(stack, (Level)minecraft.level, (LivingEntity)minecraft.player, 0);
        pose.translate((float)x, (float)y, (float)z);
        CommonClient.renderModel(minecraft, gui, stack, drawShadows, pose, model);
        pose.popPose();
    }

    public static void renderModel(Minecraft minecraft, GuiGraphics gui, ItemStack stack, boolean drawShadows, PoseStack pose, BakedModel model) {
        try {
            boolean $$8;
            pose.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            pose.scale(16.0f, 16.0f, 16.0f);
            boolean bl = $$8 = !model.usesBlockLight();
            if ($$8) {
                Lighting.setupForFlatItems();
            }
            minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)gui.bufferSource(), 0xF000F0, OverlayTexture.NO_OVERLAY, model);
            if (drawShadows && !model.isGui3d()) {
                pose.translate(0.0625f, -0.0625f, -0.0625f);
                minecraft.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, pose, (MultiBufferSource)gui.bufferSource(), 0, OverlayTexture.NO_OVERLAY, model);
            }
            gui.flush();
            if ($$8) {
                Lighting.setupFor3DItems();
            }
        }
        catch (Throwable var12) {
            CrashReport $$10 = CrashReport.forThrowable((Throwable)var12, (String)"Rendering item");
            CrashReportCategory $$11 = $$10.addCategory("Item being rendered");
            $$11.setDetail("Item Type", () -> String.valueOf(stack.getItem()));
            $$11.setDetail("Item Components", () -> String.valueOf(stack.getComponents()));
            $$11.setDetail("Item Foil", () -> String.valueOf(stack.hasFoil()));
            throw new ReportedException($$10);
        }
    }

    public static void renderHoveredItem(Minecraft minecraft, GuiGraphics instance, ItemStack stack, int x, int y, int seed, Operation<Void> original, String modelName) {
        ISlotSelectorTrait trait = ISlotSelectorTrait.get(stack);
        if (trait != null) {
            ItemStack food = trait.getHoverItem(ComponentHolder.of(stack), (Player)minecraft.player);
            if (food != null) {
                original.call(new Object[]{instance, food, x, y, seed});
            } else {
                ModelResourceLocation location = Services.PLATFORM.getModelVariant(ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)("backpack/" + modelName)));
                BakedModel model = minecraft.getItemRenderer().getItemModelShaper().getModelManager().getModel(location);
                PoseStack pose = instance.pose();
                pose.pushPose();
                pose.translate((float)(x + 8), (float)(y + 8), 0.0f);
                CommonClient.renderModel(minecraft, instance, stack, false, pose, model);
                pose.popPose();
            }
        }
    }

    public static void handleSentItemComponentPatch(int slot, DataComponentPatch patch) {
        if (slot < 0) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        Inventory inventory = minecraft.player.getInventory();
        ItemStack stack = inventory.getItem(slot);
        stack.applyComponents(patch);
    }

    public static void renderInfoTooltip(GuiGraphics gui, int mouseX, int mouseY, Slot slot, BundleLikeTraits traits) {
        int x = mouseX - 20;
        int y = mouseY - 8;
        TooltipRenderUtil.renderTooltipBackground((GuiGraphics)gui, (int)x, (int)y, (int)11, (int)13, (int)600);
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"textures/gui/sprites/r_click_icon.png");
        gui.blitSprite(R_CLICK_ICON, 16, 16, 0, 0, x - 2, y - 2, 600, 16, 16);
    }
}

