/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.Registries;
import com.beansgalaxy.backpacks.client.KeyPress;
import com.beansgalaxy.backpacks.client.renderer.BackpackCapeModel;
import com.beansgalaxy.backpacks.client.renderer.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.EntityRender;
import com.beansgalaxy.backpacks.client.renderer.RenderBackpack;
import com.beansgalaxy.backpacks.data.config.screen.ConfigRows;
import com.beansgalaxy.backpacks.data.config.screen.ConfigScreen;
import com.beansgalaxy.backpacks.data.config.screen.IConfig;
import com.beansgalaxy.backpacks.items.ModItems;
import com.beansgalaxy.backpacks.screen.BurlapSackScreen;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="beansbackpacks", dist={Dist.CLIENT})
public class NeoForgeClient {
    public NeoForgeClient(IEventBus eventBus, ModContainer container) {
        ItemProperties.registerGeneric((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"utilities"), (ItemPropertyFunction)CommonClient.UTILITIES_PREDICATE);
        ItemProperties.registerGeneric((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"fullness"), (ItemPropertyFunction)CommonClient.FULLNESS_ITEM_PREDICATE);
        ItemProperties.registerGeneric((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"eating"), (ItemPropertyFunction)CommonClient.EATING_TRAIT_ITEM_PREDICATE);
        ItemProperties.registerGeneric((ResourceLocation)ResourceLocation.withDefaultNamespace((String)"searching"), (ItemPropertyFunction)CommonClient.ENDER_SEARCHING_PREDICATE);
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(modContainer, screen) -> {
            ImmutableMap.Builder map = ImmutableMap.builder();
            Minecraft minecraft = screen.getMinecraft();
            ConfigScreen.buildPageMap(minecraft, (ImmutableMap.Builder<IConfig, Function<ConfigScreen, ConfigRows>>)map);
            return new ConfigScreen(screen, (Map<IConfig, Function<ConfigScreen, ConfigRows>>)map.build());
        }));
        CommonClient.init();
    }

    public static class GameEvents {
    }

    @EventBusSubscriber(modid="beansbackpacks", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ModEvents {
        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register(Registries.BURLAP_SACK_MENU.get(), BurlapSackScreen::new);
        }

        @SubscribeEvent
        public static void registerColorHandlers(RegisterColorHandlersEvent.Item event) {
            event.register(CommonClient.LEATHER_BACKPACK_ITEM_COLOR, new ItemLike[]{ModItems.LEATHER_BACKPACK.get()});
            event.register(CommonClient.BUNDLE_ITEM_COLOR, new ItemLike[]{ModItems.BUNDLE.get()});
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(RenderBackpack.BACKPACK_MODEL, BackpackModel::getTexturedModelData);
            event.registerLayerDefinition(RenderBackpack.PACK_CAPE_MODEL, BackpackCapeModel::createBodyLayer);
        }

        @SubscribeEvent
        public static void registerEntityRenderer(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(CommonClass.BACKPACK_ENTITY.get(), EntityRender::new);
        }

        @SubscribeEvent
        public static void registerAdditionalModels(ModelEvent.RegisterAdditional event) {
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            ModEvents.appendModels(resourceManager, "backpack", event);
            ModEvents.appendModels(resourceManager, "utilities", event);
        }

        private static void appendModels(ResourceManager resourceManager, String path, ModelEvent.RegisterAdditional event) {
            Map resourceMap = resourceManager.listResources("models/" + path, p_251575_ -> {
                String s = p_251575_.getPath();
                return s.endsWith(".json");
            });
            for (ResourceLocation resourceLocation : resourceMap.keySet()) {
                ResourceLocation location = resourceLocation.withPath(key -> key.replaceAll("models/", "").replaceAll(".json", ""));
                ModelResourceLocation model = ModelResourceLocation.standalone((ResourceLocation)location);
                event.register(model);
            }
        }

        @SubscribeEvent
        public static void registerKeys(RegisterKeyMappingsEvent event) {
            event.register(KeyPress.INSTANCE.ACTION_KEY);
            event.register(KeyPress.INSTANCE.MENUS_KEY);
            event.register(KeyPress.INSTANCE.INSTANT_KEY);
            event.register(KeyPress.INSTANCE.SPYGLASS_KEY);
        }

        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> CommonClass.CLIENT_CONFIG.read());
        }
    }
}

