/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.access;

import com.beansgalaxy.backpacks.components.BulkComponent;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.MutableBundleLike;
import com.beansgalaxy.backpacks.traits.generic.MutableItemStorage;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DecoratedPotBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.math.Fraction;
import org.jetbrains.annotations.Nullable;

public interface DecoratedPotEntityAccess {
    public static final int SIZE = 108;

    default public Fraction getWeight() {
        BulkComponent bulk = this.getBulkComponent();
        if (bulk == null) {
            return Traits.getStackWeight(this.item().get());
        }
        Fraction bulkWeight = bulk.weight();
        Fraction stackWeight = Traits.getStackWeight(this.item().get());
        return bulkWeight.add(stackWeight);
    }

    default public float getFullness() {
        return this.getWeight().multiplyBy(Fraction.getFraction((int)1, (int)108)).floatValue();
    }

    default public boolean isFull() {
        return this.getWeight().multiplyBy(Fraction.getFraction((int)1, (int)108)).compareTo(Fraction.ONE) > -1;
    }

    default public ItemStack takeFromFocus() {
        ItemStack returned = this.item().get();
        if (returned.isEmpty()) {
            return ItemStack.EMPTY;
        }
        BulkComponent bulk = this.getBulkComponent();
        if (bulk == null) {
            this.item().set(ItemStack.EMPTY);
            return returned;
        }
        ArrayList<BulkComponent.ItemlessStack> stacks = new ArrayList<BulkComponent.ItemlessStack>(bulk.stacks());
        ItemStack stack = stacks.removeLast().withItem(bulk.item());
        this.item().set(stack);
        if (stacks.isEmpty()) {
            this.setBulkComponent(null);
            return returned;
        }
        this.tryFillFocusedItem(bulk.item(), stacks);
        return returned;
    }

    default public boolean insertIntoFocus(ItemStack stack) {
        if (!stack.getItem().canFitInsideContainerItems()) {
            return false;
        }
        ItemStack focused = this.item().get();
        if (focused.isEmpty()) {
            this.item().set(stack);
            return true;
        }
        Holder item = focused.getItemHolder();
        if (!stack.is(item)) {
            return false;
        }
        Level level = this.getLevel();
        if (level.isClientSide) {
            return true;
        }
        BulkComponent bulk = this.getBulkComponent();
        ArrayList<BulkComponent.ItemlessStack> stacks = bulk == null ? new ArrayList<BulkComponent.ItemlessStack>() : new ArrayList<BulkComponent.ItemlessStack>(bulk.stacks());
        BulkComponent.ItemlessStack itemless = new BulkComponent.ItemlessStack(focused.getComponentsPatch(), focused.getCount());
        stacks.addFirst(itemless);
        this.item().set(stack);
        if (stacks.size() > 1) {
            BulkComponent.ItemlessStack first = (BulkComponent.ItemlessStack)stacks.removeFirst();
            int maxSize = first.withItem((Holder<Item>)item).getMaxStackSize();
            int count = first.count();
            DataComponentPatch patch = first.patch();
            Iterator<BulkComponent.ItemlessStack> iterator = stacks.iterator();
            while (iterator.hasNext() && count < maxSize) {
                BulkComponent.ItemlessStack next = iterator.next();
                if (!Objects.equals(patch, next.patch())) continue;
                count += next.count();
                iterator.remove();
            }
            if (count > maxSize) {
                stacks.addFirst(new BulkComponent.ItemlessStack(patch, maxSize));
                count -= maxSize;
            }
            stacks.addFirst(new BulkComponent.ItemlessStack(patch, count));
        }
        this.tryFillFocusedItem((Holder<Item>)item, stacks);
        return true;
    }

    default public void tryFillFocusedItem(Holder<Item> item, ArrayList<BulkComponent.ItemlessStack> stacks) {
        ItemStack focused = this.item().get();
        if (focused.isEmpty()) {
            focused = stacks.removeFirst().withItem(item);
            this.item().set(focused);
        }
        if (stacks.isEmpty()) {
            this.setBulkComponent(null);
            return;
        }
        int toAdd = focused.getMaxStackSize() - focused.getCount();
        if (toAdd == 0) {
            this.setBulkComponent(new BulkComponent(item, (List<BulkComponent.ItemlessStack>)ImmutableList.copyOf(stacks)));
            return;
        }
        while (toAdd != 0) {
            if (stacks.isEmpty()) {
                this.setBulkComponent(null);
                return;
            }
            ItemStack stack = stacks.removeLast().withItem(item);
            if (!ItemStack.isSameItemSameComponents((ItemStack)focused, (ItemStack)stack)) {
                return;
            }
            int count = Math.min(stack.getCount(), toAdd);
            stack.shrink(count);
            focused.grow(count);
            toAdd -= count;
            if (stack.isEmpty()) continue;
            BulkComponent.ItemlessStack newItemless = new BulkComponent.ItemlessStack(stack.getComponentsPatch(), stack.getCount());
            stacks.add(newItemless);
            this.setBulkComponent(new BulkComponent(item, (List<BulkComponent.ItemlessStack>)ImmutableList.copyOf(stacks)));
            return;
        }
        if (stacks.isEmpty()) {
            this.setBulkComponent(null);
        } else {
            this.setBulkComponent(new BulkComponent(item, (List<BulkComponent.ItemlessStack>)ImmutableList.copyOf(stacks)));
        }
    }

    public static boolean attack(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)blockEntity;
            BlockPos above = pos.above();
            BlockState blockState = level.getBlockState(above);
            if (blockState.isRedstoneConductor((BlockGetter)level, above)) {
                return true;
            }
            ItemStack returned = entity.takeFromFocus();
            if (returned.isEmpty()) {
                return false;
            }
            if (!level.isClientSide) {
                double d2 = (double)pos.getX() + 0.5;
                double d3 = (double)pos.getY() + 1.0;
                double d4 = (double)pos.getZ() + 0.5;
                double d5 = Mth.nextDouble((RandomSource)level.random, (double)-0.1, (double)0.1);
                double d6 = 0.2;
                double d7 = Mth.nextDouble((RandomSource)level.random, (double)-0.1, (double)0.1);
                ItemEntity itementity = new ItemEntity(level, d2, d3, d4, returned, d5, d6, d7);
                itementity.setPickUpDelay(0);
                level.addFreshEntity((Entity)itementity);
            }
            float fullness = entity.getFullness();
            entity.success(level, pos, player, fullness);
            return true;
        }
        return false;
    }

    public static ItemInteractionResult useItemOn(ItemStack inHand, Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)blockEntity;
            BlockPos above = pos.above();
            BlockState blockState = level.getBlockState(above);
            if (blockState.isRedstoneConductor((BlockGetter)level, above)) {
                return ItemInteractionResult.SUCCESS;
            }
            int toAdd = entity.amountToAdd(inHand);
            if (toAdd <= 0) {
                entity.fail(level, pos, player);
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ItemStack insert = inHand.copyWithCount(toAdd);
            boolean success = entity.insertIntoFocus(insert);
            if (level.isClientSide) {
                return success ? ItemInteractionResult.SUCCESS : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            if (success) {
                inHand.shrink(toAdd);
                entity.success(inHand, level, pos, player, entity.getFullness());
                return ItemInteractionResult.SUCCESS;
            }
            entity.fail(level, pos, player);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static InteractionResult useWithoutItem(Level level, BlockPos pos, Player player) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)blockEntity;
            BlockPos above = pos.above();
            BlockState blockState = level.getBlockState(above);
            if (blockState.isRedstoneConductor((BlockGetter)level, above)) {
                return InteractionResult.SUCCESS;
            }
            ItemStack focused = entity.item().get();
            if (focused.isEmpty()) {
                return InteractionResult.PASS;
            }
            Inventory inventory = player.getInventory();
            Stream aStream = Stream.concat(inventory.items.stream(), inventory.armor.stream());
            Stream<ItemStack> bStream = Stream.of(player.getItemBySlot(EquipmentSlot.BODY));
            Iterator iterator = Stream.concat(aStream, bStream).iterator();
            while (iterator.hasNext()) {
                int toAdd;
                ItemStack copy;
                ItemStack item = (ItemStack)iterator.next();
                Optional<BundleLikeTraits> optional = BundleLikeTraits.get(ComponentHolder.of(item));
                if (optional.isPresent()) {
                    BundleLikeTraits traits = optional.get();
                    MutableItemStorage mutable = traits.mutable(ComponentHolder.of(item));
                    for (ItemStack stack : ((MutableBundleLike)mutable).getItemStacks()) {
                        int toAdd2;
                        ItemStack copy2 = stack.copyWithCount(toAdd2 = entity.amountToAdd(stack));
                        if (!entity.insertIntoFocus(copy2)) continue;
                        entity.success(stack, level, pos, player, entity.getFullness());
                        stack.shrink(toAdd2);
                        ((MutableBundleLike)mutable).push();
                        return InteractionResult.SUCCESS;
                    }
                }
                if (!entity.insertIntoFocus(copy = item.copyWithCount(toAdd = entity.amountToAdd(item)))) continue;
                entity.success(item, level, pos, player, entity.getFullness());
                item.shrink(toAdd);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public static void onRemove(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)blockEntity;
            BulkComponent bulk = entity.getBulkComponent();
            if (bulk == null) {
                return;
            }
            Holder<Item> item = bulk.item();
            for (BulkComponent.ItemlessStack stack : bulk.stacks()) {
                ItemStack itemStack = stack.withItem(item);
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStack);
            }
            entity.setBulkComponent(null);
        }
    }

    public static int getAnalogOutputSignal(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof DecoratedPotEntityAccess) {
            DecoratedPotEntityAccess entity = (DecoratedPotEntityAccess)blockEntity;
            if (entity.item().get().isEmpty()) {
                return 0;
            }
            Fraction fraction = entity.getWeight().multiplyBy(Fraction.getFraction((int)13, (int)108));
            return fraction.intValue() + 1;
        }
        return 0;
    }

    private int amountToAdd(ItemStack added) {
        Fraction size = Fraction.getFraction((int)108, (int)1);
        Fraction weight = this.getWeight();
        Fraction weightLeft = size.subtract(weight);
        int i = weightLeft.divideBy(Traits.getItemWeight(added)).intValue();
        return Math.min(i, added.getCount());
    }

    private void fail(Level level, BlockPos pos, Player player) {
        level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.wobble(DecoratedPotBlockEntity.WobbleStyle.NEGATIVE);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    private void success(ItemStack inHand, Level level, BlockPos pos, Player player, float fullness) {
        player.awardStat(Stats.ITEM_USED.get((Object)inHand.getItem()));
        this.success(level, pos, player, fullness);
    }

    private void success(Level level, BlockPos pos, Player player, float fullness) {
        this.wobble(DecoratedPotBlockEntity.WobbleStyle.POSITIVE);
        level.playSound(null, pos, SoundEvents.DECORATED_POT_INSERT, SoundSource.BLOCKS, 1.0f, 0.7f + 0.5f * fullness);
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            Vec3 center = pos.getCenter();
            serverlevel.sendParticles((ParticleOptions)ParticleTypes.DUST_PLUME, center.x, (double)pos.getY() + 1.2, center.z, 7, 0.0, 0.0, 0.0, 0.0);
        }
        this.setChanged();
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
    }

    @Nullable
    public BulkComponent getBulkComponent();

    public void setBulkComponent(@Nullable BulkComponent var1);

    public SlotAccess item();

    public void wobble(DecoratedPotBlockEntity.WobbleStyle var1);

    public void setChanged();

    public Level getLevel();
}

