/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.PlayerAccessor;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.network.serverbound.BackpackUseOn;
import com.beansgalaxy.backpacks.network.serverbound.InstantKeyPress;
import com.beansgalaxy.backpacks.network.serverbound.SyncHotkey;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.OptionalInt;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class KeyPress {
    public static final KeyPress INSTANCE = new KeyPress();
    public static final String KEY_CATEGORY = "key.beansbackpacks.category";
    public static final String ACTION_KEY_IDENTIFIER = "key.beansbackpacks.action";
    public static final String MENUS_KEY_IDENTIFIER = "key.beansbackpacks.inventory";
    public static final String INSTANT_KEY_IDENTIFIER = "key.beansbackpacks.instant";
    public static final String ACTION_KEY_DESC = "key.beansbackpacks.desc.action";
    public static final String MENUS_KEY_DESC = "key.beansbackpacks.desc.inventory";
    public static final String INSTANT_KEY_DESC = "key.beansbackpacks.desc.instant";
    public static final String ACTION_KEY_DISABLED = "key.beansbackpacks.action_disabled";
    public static final String ACTION_KEY_DISABLED_DESC = "key.beansbackpacks.desc.action_disabled";
    public static final String SPYGLASS_KEY_IDENTIFIER = "key.beansbackpacks.spyglass";
    public final KeyMapping ACTION_KEY = new KeyMapping(this, "key.beansbackpacks.action", -1, "key.beansbackpacks.category"){

        public Component getTranslatedKeyMessage() {
            if (this.isUnbound()) {
                return KeyPress.getDefaultKeyBind().getTranslatedKeyMessage();
            }
            return super.getTranslatedKeyMessage();
        }
    };
    public final KeyMapping MENUS_KEY = new KeyMapping(this, "key.beansbackpacks.inventory", -1, "key.beansbackpacks.category"){

        public Component getTranslatedKeyMessage() {
            if (this.isUnbound()) {
                return KeyPress.getActionKeyBind().getTranslatedKeyMessage();
            }
            return super.getTranslatedKeyMessage();
        }
    };
    public final KeyMapping INSTANT_KEY = new KeyMapping("key.beansbackpacks.instant", -1, "key.beansbackpacks.category");
    public final KeyMapping SPYGLASS_KEY = new KeyMapping("key.beansbackpacks.spyglass", 66, "key.beansbackpacks.category");
    @Nullable
    private CoyoteClick coyoteClick = null;
    private boolean wasUtilityDown = false;

    public void tick(Minecraft minecraft, LocalPlayer player, DeltaTracker delta) {
        isPressed actionKey;
        if (this.coyoteClick != null) {
            if (this.coyoteClick.shouldUnload(minecraft, player)) {
                this.unloadCoyoteClick(minecraft, player, this.coyoteClick);
            } else if (player.isUsingItem()) {
                this.cancelCoyoteClick();
            }
        }
        boolean actionKeyPressed = (actionKey = KeyPress.isPressed(minecraft, KeyPress.getActionKeyBind())).pressed() && this.INSTANT_KEY.isUnbound();
        isPressed menusKey = KeyPress.isPressed(minecraft, KeyPress.getMenusKeyBind());
        int tinyChestSlot = -1;
        boolean menuKeyPressed = menusKey.pressed();
        BackData backData = BackData.get((Player)player);
        if (actionKeyPressed == backData.isActionKeyDown() && menuKeyPressed == backData.isMenuKeyDown()) {
            return;
        }
        backData.setActionKey(actionKeyPressed);
        backData.setMenuKey(menuKeyPressed);
        backData.setTinySlot(tinyChestSlot);
        SyncHotkey.send(actionKeyPressed, menuKeyPressed, tinyChestSlot);
    }

    private void unloadCoyoteClick(Minecraft minecraft, LocalPlayer player, CoyoteClick coyoteClick) {
        InteractionHand interactionhand;
        ItemStack itemstack;
        InteractionHand[] interactionHandArray = InteractionHand.values();
        int n = interactionHandArray.length;
        for (int i = 0; i < n && (itemstack = player.getItemInHand(interactionhand = interactionHandArray[i])).isItemEnabled(minecraft.level.enabledFeatures()); ++i) {
            int i2 = itemstack.getCount();
            InteractionResult interactionresult = minecraft.gameMode.useItemOn(player, interactionhand, coyoteClick.blockhitresult);
            if (!interactionresult.consumesAction()) continue;
            if (!interactionresult.shouldSwing()) break;
            player.swing(interactionhand);
            if (itemstack.isEmpty() || itemstack.getCount() == i2 && !minecraft.gameMode.hasInfiniteItems()) break;
            minecraft.gameRenderer.itemInHandRenderer.itemUsed(interactionhand);
            break;
        }
        this.cancelCoyoteClick();
    }

    public OptionalInt loadCoyoteClick(LocalPlayer player, BlockHitResult hitResult) {
        EquipmentSlot[] slots;
        if (this.coyoteClick != null) {
            if (this.coyoteClick.isFinished()) {
                EquipmentSlot slot = this.coyoteClick.slot;
                BackpackTraits traits = this.coyoteClick.traits;
                this.coyoteClick = null;
                ItemStack backpack = player.getItemBySlot(slot);
                if (BackpackUseOn.placeBackpack((Player)player, hitResult, backpack, traits)) {
                    BackpackUseOn.send(hitResult, slot);
                    return OptionalInt.of(8);
                }
                return OptionalInt.of(4);
            }
            this.coyoteClick.indexProgress();
            return OptionalInt.of(0);
        }
        if (this.pickUpThru(player)) {
            return OptionalInt.of(0);
        }
        for (EquipmentSlot slot : slots = new EquipmentSlot[]{EquipmentSlot.BODY, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND}) {
            ItemStack backpack = player.getItemBySlot(slot);
            BackpackTraits traits = BackpackTraits.get(backpack);
            if (traits == null) continue;
            this.coyoteClick = new CoyoteClick(slot, traits, hitResult);
            return OptionalInt.of(0);
        }
        return OptionalInt.empty();
    }

    public void cancelCoyoteClick() {
        this.coyoteClick = null;
    }

    public boolean hasCoyoteClick() {
        return this.coyoteClick != null;
    }

    public float placementProgress() {
        if (this.coyoteClick == null) {
            return 0.0f;
        }
        return (float)this.coyoteClick.progress / 4.0f;
    }

    public boolean pickUpThru(LocalPlayer player) {
        AABB aabb;
        double pBlockInteractionRange = player.blockInteractionRange();
        double d0 = Math.max(pBlockInteractionRange, player.entityInteractionRange());
        double d1 = Mth.square((double)d0);
        float pPartialTick = 1.0f;
        Vec3 vec3 = player.getEyePosition(pPartialTick);
        Vec3 vec31 = player.getViewVector(pPartialTick);
        Vec3 vec32 = vec3.add(vec31.x * d0, vec31.y * d0, vec31.z * d0);
        EntityHitResult entityhitresult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)vec3, (Vec3)vec32, (AABB)(aabb = player.getBoundingBox().expandTowards(vec31.scale(d0)).inflate(1.0, 1.0, 1.0)), p_234237_ -> !p_234237_.isSpectator() && p_234237_.isPickable(), (double)d1);
        if (entityhitresult == null || HitResult.Type.MISS.equals((Object)entityhitresult.getType())) {
            return false;
        }
        Vec3 vec33 = entityhitresult.getLocation();
        if (!vec33.closerThan((Position)vec33, pBlockInteractionRange)) {
            return false;
        }
        Entity entity = entityhitresult.getEntity();
        if (!player.hasLineOfSight(entity)) {
            return false;
        }
        return KeyPress.tryEquip(player, entity);
    }

    public static boolean tryEquip(LocalPlayer player, Entity entity) {
        if (entity instanceof BackpackEntity) {
            BackpackEntity backpack = (BackpackEntity)entity;
            InteractionResult tryEquip = backpack.tryEquip((Player)player);
            if (tryEquip.consumesAction()) {
                InstantKeyPress.send(entity.getId());
            }
            return true;
        }
        if (entity instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)entity;
            InteractionResult tryEquip = CommonClass.swapBackWith(armorStand, (Player)player);
            if (tryEquip.consumesAction()) {
                InstantKeyPress.send(entity.getId());
            }
            return true;
        }
        if (entity instanceof Allay) {
            Allay allay = (Allay)entity;
            InteractionResult tryEquip = CommonClass.swapBackWith(allay, (Player)player);
            if (tryEquip.consumesAction()) {
                InstantKeyPress.send(entity.getId());
            }
            return true;
        }
        return false;
    }

    public static boolean placeBackpack(Player player, BlockHitResult hitResult) {
        return KeyPress.tryPlace(player, hitResult, EquipmentSlot.MAINHAND) || KeyPress.tryPlace(player, hitResult, EquipmentSlot.BODY);
    }

    private static boolean tryPlace(Player player, BlockHitResult hitResult, EquipmentSlot slot) {
        ItemStack backpack = player.getItemBySlot(slot);
        BackpackTraits traits = BackpackTraits.get(backpack);
        if (traits == null) {
            return false;
        }
        if (BackpackUseOn.placeBackpack(player, hitResult, backpack, traits)) {
            BackpackUseOn.send(hitResult, slot);
            return true;
        }
        return false;
    }

    public static KeyMapping getDefaultKeyBind() {
        Minecraft instance = Minecraft.getInstance();
        return instance.options.keySprint;
    }

    public static KeyMapping getActionKeyBind() {
        KeyMapping sprintKey = KeyPress.getDefaultKeyBind();
        KeyMapping customKey = KeyPress.INSTANCE.ACTION_KEY;
        return customKey.isUnbound() ? sprintKey : customKey;
    }

    public static KeyMapping getMenusKeyBind() {
        KeyMapping sprintKey = KeyPress.getActionKeyBind();
        KeyMapping customKey = KeyPress.INSTANCE.MENUS_KEY;
        return customKey.isUnbound() ? sprintKey : customKey;
    }

    @NotNull
    public static isPressed isPressed(Minecraft minecraft, KeyMapping bind) {
        KeyMapping sneakKey = minecraft.options.keyShift;
        if (sneakKey.same(bind)) {
            sneakKey.setDown(bind.isDown());
        }
        InputConstants.Key key = InputConstants.getKey((String)bind.saveString());
        long window = minecraft.getWindow().getWindow();
        int value = key.getValue();
        boolean isMouseKey = key.getType().equals((Object)InputConstants.Type.MOUSE);
        boolean isPressed2 = isMouseKey ? GLFW.glfwGetMouseButton((long)window, (int)value) == 1 : InputConstants.isKeyDown((long)window, (int)value);
        return new isPressed(isMouseKey, isPressed2);
    }

    public void handleUtility(LocalPlayer player, HitResult result) {
        boolean isUtilityDown = this.SPYGLASS_KEY.isDown();
        if (isUtilityDown != this.wasUtilityDown) {
            UtilityComponent.testItems((Player)player, (item, mute) -> {
                if (item.is(Items.SPYGLASS)) {
                    PlayerAccessor access = (PlayerAccessor)player;
                    access.setUtilityScoped(isUtilityDown);
                    if (isUtilityDown) {
                        player.playSound(SoundEvents.SPYGLASS_USE, 1.0f, 1.0f);
                    }
                    return true;
                }
                return false;
            });
        }
        this.wasUtilityDown = isUtilityDown;
    }

    private static class CoyoteClick {
        final EquipmentSlot slot;
        final BackpackTraits traits;
        final BlockHitResult blockhitresult;
        int progress = 1;

        private CoyoteClick(EquipmentSlot slot, BackpackTraits backpack, BlockHitResult blockhitresult) {
            this.slot = slot;
            this.traits = backpack;
            this.blockhitresult = blockhitresult;
        }

        void indexProgress() {
            ++this.progress;
        }

        boolean isFinished() {
            return this.progress > 4;
        }

        public boolean shouldUnload(Minecraft minecraft, LocalPlayer player) {
            if (!minecraft.options.keyUse.isDown()) {
                return true;
            }
            HitResult hitResult = minecraft.hitResult;
            if (hitResult instanceof BlockHitResult) {
                BlockHitResult hitResult2 = (BlockHitResult)hitResult;
                return !hitResult2.getBlockPos().equals((Object)this.blockhitresult.getBlockPos()) || !hitResult2.getDirection().equals((Object)this.blockhitresult.getDirection());
            }
            return true;
        }
    }

    public record isPressed(boolean onMouse, boolean pressed) {
    }
}

