/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.client.renderer.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.RenderBackpack;
import com.beansgalaxy.backpacks.components.equipable.EquipmentModel;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AllayModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.allay.Allay;
import net.minecraft.world.item.ItemStack;

public class AllayFeature
extends RenderLayer<Allay, AllayModel>
implements RenderBackpack {
    private final BackpackModel<Allay> backpackModel;
    private final ItemRenderer itemRenderer;
    private final BlockRenderDispatcher blockDispatcher;

    public AllayFeature(RenderLayerParent<Allay, AllayModel> pRenderer, ItemRenderer itemRenderer, EntityModelSet modelSet, BlockRenderDispatcher blockDispatcher) {
        super(pRenderer);
        this.itemRenderer = itemRenderer;
        this.backpackModel = new BackpackModel(modelSet.bakeLayer(BACKPACK_MODEL));
        this.blockDispatcher = blockDispatcher;
    }

    @Override
    public BackpackModel<?> model() {
        return this.backpackModel;
    }

    @Override
    public ItemRenderer itemRenderer() {
        return this.itemRenderer;
    }

    @Override
    public BlockRenderDispatcher blockRenderer() {
        return this.blockDispatcher;
    }

    public void render(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, Allay allay, float limbAngle, float limbDistance, float tick, float animationProgress, float playerHeadYaw, float playerHeadPitch) {
        ItemStack itemStack = allay.getItemBySlot(EquipmentSlot.BODY);
        BackpackTraits traits = BackpackTraits.get(itemStack);
        if (traits == null) {
            return;
        }
        float pAgeInTicks = (float)allay.tickCount + tick;
        float f3 = pAgeInTicks * 9.0f * ((float)Math.PI / 180);
        float bobY = (float)Math.cos(f3) * 0.015f;
        pose.pushPose();
        ViewableBackpack viewable = ViewableBackpack.get((LivingEntity)allay);
        if (viewable.lastDelta > tick) {
            viewable.updateOpen();
        }
        float headPitch = Mth.lerp((float)tick, (float)viewable.lastPitch, (float)viewable.headPitch) * 0.25f;
        this.model().setOpenAngle(headPitch);
        viewable.lastDelta = tick;
        pose.translate(0.0f, 1.59375f + bobY, 0.24375f);
        pose.mulPose(Axis.YP.rotationDegrees(180.0f));
        pose.mulPose(Axis.XN.rotationDegrees(16.0f));
        float scale = 0.875f;
        pose.scale(scale, scale, scale);
        ResourceLocation texture = traits.getTexture();
        this.renderTexture(pose, pBufferSource, pCombinedLight, texture, itemStack, viewable);
        pose.popPose();
    }

    private void renderModel(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, LivingEntity player, EquipmentModel model, ItemStack itemStack) {
        ResourceLocation backLocation;
        ResourceLocation bodyLocation = model.attachments().get((Object)EquipmentModel.Attachment.BODY);
        if (bodyLocation != null) {
            pose.pushPose();
            this.renderBackpack(pose, pBufferSource, pCombinedLight, bodyLocation, itemStack, player, Minecraft.getInstance().level, player.getId());
            pose.popPose();
        }
        if ((backLocation = model.attachments().get((Object)EquipmentModel.Attachment.BACK)) != null) {
            pose.pushPose();
            this.renderBackpack(pose, pBufferSource, pCombinedLight, backLocation, itemStack, player, Minecraft.getInstance().level, player.getId());
            pose.popPose();
        }
    }
}

