/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.client.renderer.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.RenderBackpack;
import com.beansgalaxy.backpacks.components.equipable.EquipmentModel;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;

public class ArmorStandFeature
extends RenderLayer<ArmorStand, ArmorStandArmorModel>
implements RenderBackpack {
    private final BackpackModel<ArmorStand> backpackModel;
    private final ItemRenderer itemRenderer;
    private final BlockRenderDispatcher blockDispatcher;

    public ArmorStandFeature(RenderLayerParent<ArmorStand, ArmorStandArmorModel> pRenderer, ItemRenderer itemRenderer, EntityModelSet modelSet, BlockRenderDispatcher blockDispatcher) {
        super(pRenderer);
        this.itemRenderer = itemRenderer;
        this.backpackModel = new BackpackModel(modelSet.bakeLayer(BACKPACK_MODEL));
        this.blockDispatcher = blockDispatcher;
    }

    @Override
    public BackpackModel<?> model() {
        return this.backpackModel;
    }

    @Override
    public ItemRenderer itemRenderer() {
        return this.itemRenderer;
    }

    @Override
    public BlockRenderDispatcher blockRenderer() {
        return this.blockDispatcher;
    }

    public void render(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, ArmorStand armorStand, float limbAngle, float limbDistance, float tick, float animationProgress, float playerHeadYaw, float playerHeadPitch) {
        ItemStack itemStack = armorStand.getItemBySlot(EquipmentSlot.BODY);
        BackpackTraits traits = BackpackTraits.get(itemStack);
        if (traits == null) {
            return;
        }
        pose.pushPose();
        ((ArmorStandArmorModel)this.getParentModel()).body.translateAndRotate(pose);
        pose.translate(0.0f, armorStand.isCrouching() ? 0.0625f : 0.0f, -0.03125f);
        if (!armorStand.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) {
            pose.translate(0.0f, -0.0625f, 0.09375f);
        }
        ViewableBackpack viewable = ViewableBackpack.get((LivingEntity)armorStand);
        if (viewable.lastDelta > tick) {
            viewable.updateOpen();
        }
        float headPitch = Mth.lerp((float)tick, (float)viewable.lastPitch, (float)viewable.headPitch) * 0.25f;
        this.model().setOpenAngle(headPitch);
        viewable.lastDelta = tick;
        pose.translate(0.0f, 0.8125f, 0.0f);
        ResourceLocation texture = traits.getTexture();
        this.renderTexture(pose, pBufferSource, pCombinedLight, texture, itemStack, viewable);
        pose.popPose();
    }

    private void renderModel(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, LivingEntity player, EquipmentModel model, ItemStack itemStack) {
        model.attachments().forEach((attachment, location) -> {
            pose.pushPose();
            switch (attachment) {
                case HEAD: {
                    ((ArmorStandArmorModel)this.getParentModel()).head.translateAndRotate(pose);
                    pose.translate(0.0f, -0.75f, 0.0f);
                    break;
                }
                case BODY: {
                    ((ArmorStandArmorModel)this.getParentModel()).body.translateAndRotate(pose);
                    break;
                }
                case BACK: {
                    ((ArmorStandArmorModel)this.getParentModel()).body.translateAndRotate(pose);
                    if (player.isCrouching()) {
                        pose.translate(0.0f, 0.0625f, 0.0f);
                    }
                    if (player.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) break;
                    pose.translate(0.0f, -0.0625f, 0.0625f);
                    break;
                }
                case L_ARM: {
                    ((ArmorStandArmorModel)this.getParentModel()).leftArm.translateAndRotate(pose);
                    pose.translate(0.0625f, -0.125f, 0.0f);
                    break;
                }
                case R_ARM: {
                    ((ArmorStandArmorModel)this.getParentModel()).rightArm.translateAndRotate(pose);
                    pose.translate(-0.0625f, -0.125f, 0.0f);
                    break;
                }
                case L_LEG: {
                    ((ArmorStandArmorModel)this.getParentModel()).leftLeg.translateAndRotate(pose);
                    break;
                }
                case R_LEG: {
                    ((ArmorStandArmorModel)this.getParentModel()).rightLeg.translateAndRotate(pose);
                }
            }
            this.renderBackpack(pose, pBufferSource, pCombinedLight, (ResourceLocation)location, itemStack, player, Minecraft.getInstance().level, player.getId());
            pose.popPose();
        });
    }
}

