/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.client.renderer.BackpackCapeModel;
import com.beansgalaxy.backpacks.client.renderer.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.RenderBackpack;
import com.beansgalaxy.backpacks.components.equipable.EquipmentModel;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class BackFeature
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>
implements RenderBackpack {
    private final BackpackModel<AbstractClientPlayer> model;
    private final BackpackCapeModel<AbstractClientPlayer> capeModel;
    private final ItemRenderer itemRenderer;
    private final BlockRenderDispatcher blockDispatcher;

    public BackFeature(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> pRenderer, ItemRenderer itemRenderer, EntityModelSet modelSet, BlockRenderDispatcher blockDispatcher) {
        super(pRenderer);
        this.itemRenderer = itemRenderer;
        this.model = new BackpackModel(modelSet.bakeLayer(BACKPACK_MODEL));
        this.capeModel = new BackpackCapeModel(modelSet.bakeLayer(PACK_CAPE_MODEL));
        this.blockDispatcher = blockDispatcher;
    }

    @Override
    public BackpackModel<?> model() {
        return this.model;
    }

    @Override
    public ItemRenderer itemRenderer() {
        return this.itemRenderer;
    }

    @Override
    public BlockRenderDispatcher blockRenderer() {
        return this.blockDispatcher;
    }

    public void render(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, AbstractClientPlayer player, float limbAngle, float limbDistance, float tick, float animationProgress, float playerHeadYaw, float playerHeadPitch) {
        this.renderEquipables(pose, pBufferSource, pCombinedLight, player, tick);
    }

    private void renderEquipables(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, AbstractClientPlayer player, float tick) {
        if (((Boolean)CommonClass.CLIENT_CONFIG.disable_equipable_render.get()).booleanValue()) {
            return;
        }
        ItemStack itemStack = player.getItemBySlot(EquipmentSlot.BODY);
        BackpackTraits traits = BackpackTraits.get(itemStack);
        if (traits == null) {
            return;
        }
        pose.pushPose();
        ((PlayerModel)this.getParentModel()).body.translateAndRotate(pose);
        ViewableBackpack viewable = ViewableBackpack.get((LivingEntity)player);
        if (viewable.lastDelta > tick) {
            viewable.updateOpen();
        }
        float headPitch = Mth.lerp((float)tick, (float)viewable.lastPitch, (float)viewable.headPitch) * 0.25f;
        this.model().setOpenAngle(headPitch);
        viewable.lastDelta = tick;
        pose.translate(0.0f, 0.8125f, 0.0f);
        ItemStack chestStack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (((HashSet)CommonClass.CLIENT_CONFIG.elytra_model_equipment.get()).contains(chestStack.getItem())) {
            float xRot = ((PlayerModel)this.getParentModel()).body.xRot;
            this.setUpWithWings(player, xRot, pose);
        } else {
            pose.translate(0.0f, player.isCrouching() ? 0.0625f : 0.0f, 0.0f);
            if (!chestStack.isEmpty()) {
                pose.translate(0.0f, -0.0625f, 0.0625f);
            }
            this.renderCapeAbove(pose, pBufferSource, pCombinedLight, player, headPitch);
        }
        ResourceLocation texture = traits.getTexture();
        this.renderTexture(pose, pBufferSource, pCombinedLight, texture, itemStack, viewable);
        pose.popPose();
    }

    private void renderCapeAbove(PoseStack pose, MultiBufferSource mbs, int light, AbstractClientPlayer player, float headPitch) {
        ResourceLocation cloakTexture = player.getSkin().capeTexture();
        if (cloakTexture != null) {
            float fallDistance = player.fallDistance;
            float fallPitch = player.isFallFlying() ? 0.0f : (float)Math.log(fallDistance * 3.0f + 1.0f) * -0.05f;
            this.capeModel.cape.yRot = (float)Math.PI * 2;
            this.capeModel.cape.xRot = -headPitch;
            this.capeModel.cape.y = fallPitch * 6.0f - 11.0f;
            this.capeModel.cape.z = 2.0f;
            RenderType renderType = RenderType.entitySolid((ResourceLocation)cloakTexture);
            VertexConsumer vertexConsumer = mbs.getBuffer(renderType);
            this.capeModel.cape.render(pose, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
        }
    }

    private void setUpWithWings(AbstractClientPlayer player, float scale, PoseStack poseStack) {
        float wingSpread;
        boolean fallFlying = player.isFallFlying();
        if (fallFlying) {
            poseStack.translate(0.0f, 0.03125f, 0.0f);
            Vec3 deltaMovement = player.getDeltaMovement();
            Vec3 norm = deltaMovement.normalize();
            wingSpread = norm.y > 0.0 ? 0.0f : (float)Math.pow(-norm.y, 1.5);
        } else {
            wingSpread = 1.0f;
        }
        float xRot = 0.25f * wingSpread;
        float z = Mth.lerp((float)scale, (float)(fallFlying ? xRot : 0.25f), (float)-0.09375f);
        float y = Mth.lerp((float)scale, (float)(fallFlying ? -0.0625f : 0.0f), (float)0.1875f);
        poseStack.translate(0.0f, y, z);
        poseStack.mulPose(new Quaternionf().rotationXYZ(Mth.lerp((float)scale, (float)xRot, (float)0.0f), 0.0f, 0.0f));
    }

    private void renderModel(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, AbstractClientPlayer player, EquipmentSlot slot, EquipmentModel model, ItemStack itemStack) {
        model.attachments().forEach((attachment, location) -> {
            pose.pushPose();
            switch (attachment) {
                case HEAD: {
                    ((PlayerModel)this.getParentModel()).head.translateAndRotate(pose);
                    pose.translate(0.0f, -0.75f, 0.0f);
                    break;
                }
                case BODY: {
                    ((PlayerModel)this.getParentModel()).body.translateAndRotate(pose);
                    break;
                }
                case BACK: {
                    ((PlayerModel)this.getParentModel()).body.translateAndRotate(pose);
                    if (player.isCrouching()) {
                        pose.translate(0.0f, 0.0625f, 0.0f);
                    }
                    if (player.getItemBySlot(EquipmentSlot.CHEST).isEmpty()) break;
                    pose.translate(0.0f, -0.0625f, 0.0625f);
                    break;
                }
                case L_ARM: {
                    ((PlayerModel)this.getParentModel()).leftArm.translateAndRotate(pose);
                    pose.translate(0.0625f, -0.125f, 0.0f);
                    break;
                }
                case R_ARM: {
                    ((PlayerModel)this.getParentModel()).rightArm.translateAndRotate(pose);
                    pose.translate(-0.0625f, -0.125f, 0.0f);
                    break;
                }
                case L_LEG: {
                    ((PlayerModel)this.getParentModel()).leftLeg.translateAndRotate(pose);
                    break;
                }
                case R_LEG: {
                    ((PlayerModel)this.getParentModel()).rightLeg.translateAndRotate(pose);
                }
            }
            this.renderBackpack(pose, pBufferSource, pCombinedLight, (ResourceLocation)location, itemStack, (LivingEntity)player, player.clientLevel, player.getId());
            pose.popPose();
        });
    }
}

