/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.Entity;

public class BackpackModel<T extends Entity>
extends EntityModel<T> {
    private final ModelPart main;
    private final ModelPart body;
    private final ModelPart button;
    private final ModelPart body_mask;
    private final ModelPart head_mask;

    public BackpackModel(ModelPart root) {
        this.main = root.getChild("main");
        this.body = this.main.getChild("body");
        this.button = this.main.getChild("button");
        this.body_mask = this.main.getChild("body_mask");
        this.head_mask = this.main.getChild("head_mask");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition main = partdefinition.addOrReplaceChild("main", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        main.addOrReplaceChild("body_mask", CubeListBuilder.create().texOffs(0, 20).addBox(-4.0f, -6.0f, 2.0f, 8.0f, 7.0f, 4.0f, new CubeDeformation(-0.01f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)0.0f, (float)3.1416f, (float)3.1416f, (float)0.0f));
        main.addOrReplaceChild("button", CubeListBuilder.create().texOffs(26, 0).addBox(-1.0f, 1.0f, -5.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)2.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition mask_head = main.addOrReplaceChild("head_mask", CubeListBuilder.create(), PartPose.offsetAndRotation((float)0.0f, (float)-11.0f, (float)2.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        mask_head.addOrReplaceChild("spine_r1", CubeListBuilder.create().texOffs(8, 20).addBox(-4.0f, 0.0f, -4.0f, 8.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-4.0f, (float)-0.3229f, (float)3.1416f, (float)0.0f));
        mask_head.addOrReplaceChild("top_r1", CubeListBuilder.create().texOffs(11, 23).addBox(-4.0f, -1.0f, -4.0f, 8.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)-4.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        PartDefinition body = main.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-12.0f, (float)0.0f));
        body.addOrReplaceChild("bottom", CubeListBuilder.create().texOffs(0, 8).addBox(-4.0f, 7.0f, -6.0f, 8.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        body.addOrReplaceChild("top", CubeListBuilder.create().texOffs(0, 1).addBox(-4.0f, -1.0f, -4.0f, 8.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)2.0f, (float)0.0f, (float)3.1416f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)32, (int)32);
    }

    public void setupAnim(T entity, float f, float g, float h, float i, float j) {
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.body.render(matrices, vertexConsumer, light, overlay, color);
        this.button.render(matrices, vertexConsumer, light, overlay, color);
    }

    public void renderMask(PoseStack pose, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.head_mask.render(pose, vertexConsumer, light, overlay, color);
        pose.pushPose();
        pose.mulPose(Axis.YP.rotationDegrees(180.0f));
        pose.scale(1.0f, 1.0f, -1.0f);
        this.body_mask.render(pose, vertexConsumer, light, overlay, color);
        pose.popPose();
    }

    public void renderBody(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.body.render(matrices, vertexConsumer, light, overlay, color);
    }

    public void renderButton(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, int color) {
        this.button.render(matrices, vertexConsumer, light, overlay, color);
    }

    public void setOpenAngle(float headPitch) {
        ModelPart[] topParts;
        for (ModelPart topPart : topParts = new ModelPart[]{this.body.getChild("top"), this.button, this.head_mask}) {
            topPart.xRot = headPitch;
        }
    }
}

