/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.client.renderer.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.RenderBackpack;
import com.beansgalaxy.backpacks.traits.IEntityTraits;
import com.beansgalaxy.backpacks.traits.common.BackpackEntity;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class EntityRender
extends EntityRenderer<BackpackEntity>
implements RenderBackpack {
    ModelLayerLocation BACKPACK_MODEL = new ModelLayerLocation(ResourceLocation.parse((String)"beansbackpacks:backpack_model"), "main");
    ResourceLocation TEXTURE = ResourceLocation.parse((String)"beansbackpacks:textures/entity/backpack/null.png");
    public final BackpackModel<BackpackEntity> model;
    private final ItemRenderer itemRenderer;
    private final BlockRenderDispatcher blockDispatcher;

    public EntityRender(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new BackpackModel(ctx.bakeLayer(this.BACKPACK_MODEL));
        this.itemRenderer = ctx.getItemRenderer();
        this.blockDispatcher = ctx.getBlockRenderDispatcher();
    }

    @Override
    public BackpackModel<?> model() {
        return this.model;
    }

    @Override
    public ItemRenderer itemRenderer() {
        return this.itemRenderer;
    }

    @Override
    public BlockRenderDispatcher blockRenderer() {
        return this.blockDispatcher;
    }

    public void render(@NotNull BackpackEntity backpack, float yaw, float tick, @NotNull PoseStack pose, @NotNull MultiBufferSource source, int light) {
        if (backpack.isRemoved()) {
            return;
        }
        double breakTime = backpack.viewable.wobble;
        ItemStack stack = (ItemStack)backpack.getEntityData().get(BackpackEntity.ITEM_STACK);
        pose.pushPose();
        pose.mulPose(Axis.YN.rotationDegrees((yaw += (float)(breakTime * (double)0.8f * Math.sin(breakTime / Math.PI * 3.0))) + 180.0f));
        pose.pushPose();
        pose.mulPose(Axis.XP.rotationDegrees(180.0f));
        pose.translate(0.0f, -0.625f, -0.25f);
        ViewableBackpack viewable = backpack.viewable;
        if (viewable.lastDelta > tick) {
            viewable.updateOpen();
        }
        float headPitch = Mth.lerp((float)tick, (float)viewable.lastPitch, (float)viewable.headPitch) * 0.25f;
        this.model().setOpenAngle(headPitch);
        viewable.lastDelta = tick;
        pose.translate(0.0f, 0.8125f, 0.0f);
        IEntityTraits<?> traits = backpack.getTraits();
        ResourceLocation texture = traits.getTexture();
        this.renderTexture(pose, source, light, texture, stack, viewable);
        if (backpack.breakAmount > 0) {
            pose.pushPose();
            int breakStage = Math.min(Mth.ceil((float)((float)backpack.breakAmount / 3.0f)), 7);
            ResourceLocation location = ResourceLocation.parse((String)("beansbackpacks:textures/entity/destroy_stage/" + breakStage + ".png"));
            VertexConsumer crumble = source.getBuffer(RenderType.crumbling((ResourceLocation)location));
            this.model().renderToBuffer(pose, crumble, light, OverlayTexture.NO_OVERLAY, -1);
            pose.popPose();
        }
        pose.popPose();
        pose.popPose();
        this.renderNameAndHitbox(pose, source, backpack, yaw, light);
    }

    public ResourceLocation getTextureLocation(BackpackEntity var1) {
        return this.TEXTURE;
    }

    public void renderNameAndHitbox(PoseStack pose, MultiBufferSource mbs, BackpackEntity entity, float yaw, int light) {
        EntityHitResult hitResult;
        HitResult hitResult2;
        Minecraft minecraft = Minecraft.getInstance();
        if (!minecraft.options.hideGui && (hitResult2 = minecraft.hitResult) instanceof EntityHitResult && (hitResult = (EntityHitResult)hitResult2).getEntity() == entity) {
            AABB box;
            Component displayName;
            if (this.shouldShowName(entity) && !Constants.isEmpty(displayName = entity.getDisplayName())) {
                pose.pushPose();
                double $$5 = this.entityRenderDispatcher.distanceToSqr((Entity)entity);
                if (!($$5 > 4096.0)) {
                    Direction direction = entity.getDirection();
                    double y = entity.getY() + 1.0;
                    double yOff = entity.getEyeY() - this.entityRenderDispatcher.camera.getPosition().y;
                    pose.translate((double)(direction.getStepX() * 5) / 16.0, y -= yOff / 16.0, (double)(direction.getStepZ() * 5) / 16.0);
                    pose.mulPose(this.entityRenderDispatcher.cameraOrientation());
                    pose.scale(-0.02f, -0.02f, 1.0f);
                    Matrix4f $$9 = pose.last().pose();
                    float $$10 = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
                    int $$11 = (int)($$10 * 255.0f) << 24;
                    Font $$12 = this.getFont();
                    float $$13 = -$$12.width((FormattedText)displayName) / 2;
                    $$12.drawInBatch(displayName, $$13, 0.0f, 0x20FFFFFF, false, $$9, mbs, Font.DisplayMode.SEE_THROUGH, $$11, light);
                    $$12.drawInBatch(displayName, $$13, 0.0f, -1, false, $$9, mbs, Font.DisplayMode.NORMAL, 0, light);
                }
                pose.popPose();
            }
            pose.pushPose();
            if (!entity.getDirection().getAxis().isHorizontal()) {
                double h = 0.5625;
                double w = 0.25;
                double d = 0.125;
                box = new AABB(w, 0.0, d, -w, h, -d);
                box.move(-entity.getX(), -entity.getY(), -entity.getZ());
            } else {
                box = entity.getBoundingBox().move(-entity.getX(), -entity.getY(), -entity.getZ());
                float yRot = entity.getDirection().toYRot();
                yaw += yRot;
            }
            pose.mulPose(Axis.YN.rotationDegrees(yaw));
            VertexConsumer vertices = mbs.getBuffer(RenderType.lines());
            LevelRenderer.renderLineBox((PoseStack)pose, (VertexConsumer)vertices, (AABB)box, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
            pose.popPose();
        }
    }
}

