/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.client.renderer;

import com.beansgalaxy.backpacks.client.renderer.BackpackModel;
import com.beansgalaxy.backpacks.client.renderer.RenderUtilities;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.util.Tint;
import com.beansgalaxy.backpacks.util.ViewableBackpack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;
import net.minecraft.world.item.component.DyedItemColor;
import org.jetbrains.annotations.Nullable;

public interface RenderBackpack
extends RenderUtilities {
    public static final ModelLayerLocation BACKPACK_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"backpack_model"), "main");
    public static final ModelLayerLocation PACK_CAPE_MODEL = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"backpack_cape_model"), "main");

    public BackpackModel<?> model();

    default public void renderTexture(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, ResourceLocation texture, ItemStack itemStack, ViewableBackpack viewable) {
        this.tryRenderUtilities(pose, pBufferSource, pCombinedLight, itemStack, viewable);
        if (texture.equals((Object)ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"leather"))) {
            this.builtInLeatherModel(pose, pBufferSource, pCombinedLight, itemStack);
            return;
        }
        ResourceLocation location = texture.withPath(path -> "textures/backpack/" + path + ".png");
        VertexConsumer outer = pBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)location));
        this.model().renderBody(pose, outer, pCombinedLight, OverlayTexture.NO_OVERLAY, -1);
        this.model().renderMask(pose, outer, pCombinedLight, OverlayTexture.NO_OVERLAY, -1);
        ArmorTrim armorTrim = (ArmorTrim)itemStack.get(DataComponents.TRIM);
        if (armorTrim != null) {
            ResourceLocation pattern = ((TrimPattern)armorTrim.pattern().value()).assetId();
            String material = ((TrimMaterial)armorTrim.material().value()).assetName();
            ResourceLocation trimTexture = ResourceLocation.fromNamespaceAndPath((String)pattern.getNamespace(), (String)("trims/backpacks/" + pattern.getPath() + "_" + material));
            TextureAtlas atlas = Minecraft.getInstance().getModelManager().getAtlas(Sheets.ARMOR_TRIMS_SHEET);
            VertexConsumer trimVC = pBufferSource.getBuffer(RenderType.entityDecal((ResourceLocation)Sheets.ARMOR_TRIMS_SHEET));
            VertexConsumer wrapped = atlas.getSprite(trimTexture).wrap(trimVC);
            this.model().renderBody(pose, wrapped, pCombinedLight, OverlayTexture.NO_OVERLAY, -1);
            VertexConsumer buttonVertex = pBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)Sheets.ARMOR_TRIMS_SHEET));
            VertexConsumer buttonWrap = atlas.getSprite(trimTexture).wrap(buttonVertex);
            this.model().renderButton(pose, buttonWrap, pCombinedLight, OverlayTexture.NO_OVERLAY, -1);
        } else {
            this.model().renderButton(pose, outer, pCombinedLight, OverlayTexture.NO_OVERLAY, -1);
        }
    }

    default public void builtInLeatherModel(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, ItemStack pItemStack) {
        DyedItemColor dyedItemColor = (DyedItemColor)pItemStack.get(DataComponents.DYED_COLOR);
        int color = dyedItemColor == null ? -7714783 : dyedItemColor.rgb();
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"textures/backpack/leather/base.png");
        ResourceLocation detail = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"textures/backpack/leather/detail.png");
        VertexConsumer outer = pBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)location));
        this.model().renderBody(pose, outer, pCombinedLight, OverlayTexture.NO_OVERLAY, color);
        this.model().renderMask(pose, outer, pCombinedLight, OverlayTexture.NO_OVERLAY, color);
        VertexConsumer buttonVC = pBufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)detail));
        this.model().renderButton(pose, buttonVC, pCombinedLight, OverlayTexture.NO_OVERLAY, -1);
        this.model().renderMask(pose, buttonVC, pCombinedLight, OverlayTexture.NO_OVERLAY, -1);
        Tint tint = new Tint(color);
        double brightness = tint.brightness();
        Tint.HSL hsl = tint.HSL();
        double lum = hsl.getLum();
        hsl.setLum((Math.cbrt(lum + 0.2) + lum) / 2.0).rotate(5.0).setSat(Math.sqrt((hsl.getSat() + brightness) / 2.0));
        int highColor = hsl.rgb();
        VertexConsumer detailVC = pBufferSource.getBuffer(RenderType.entityTranslucentCull((ResourceLocation)detail));
        this.model().renderBody(pose, detailVC, pCombinedLight, OverlayTexture.NO_OVERLAY, highColor);
    }

    default public void renderBackpack(PoseStack pose, MultiBufferSource pBufferSource, int pCombinedLight, ResourceLocation location, ItemStack itemStack, @Nullable LivingEntity entity, ClientLevel level, int seed) {
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        pose.mulPose(Axis.YP.rotationDegrees(180.0f));
        pose.translate(-0.5f, -0.75f, -0.501f);
        ModelManager modelmanager = this.itemRenderer().getItemModelShaper().getModelManager();
        ModelResourceLocation modelLocation = Services.PLATFORM.getModelVariant(location);
        BakedModel bakedModel = modelmanager.getModel(modelLocation);
        BakedModel backpackModel = bakedModel.getOverrides().resolve(bakedModel, itemStack, level, entity, seed);
        if (backpackModel != null) {
            VertexConsumer buffer = pBufferSource.getBuffer(Sheets.cutoutBlockSheet());
            this.blockRenderer().getModelRenderer().renderModel(pose.last(), buffer, null, backpackModel, 1.0f, 1.0f, 1.0f, pCombinedLight, OverlayTexture.NO_OVERLAY);
        }
    }
}

