/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SlotSelection {
    private static int SLOT_SELECTION_COUNT = 0;
    private final Int2IntArrayMap slots = SlotSelection.defaultSlotMap();
    private final int id = SLOT_SELECTION_COUNT++;
    public static final StreamCodec<RegistryFriendlyByteBuf, SlotSelection> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, SlotSelection>(){

        public void encode(RegistryFriendlyByteBuf buf, SlotSelection slotSelection) {
            int size = slotSelection.slots.size();
            buf.writeInt(size);
            slotSelection.slots.forEach((key, slot) -> {
                buf.writeInt(key.intValue());
                buf.writeInt(slot.intValue());
            });
        }

        public SlotSelection decode(RegistryFriendlyByteBuf buf) {
            int size = buf.readInt();
            SlotSelection slotSelection = new SlotSelection();
            for (int i = 0; i < size; ++i) {
                int key = buf.readInt();
                int slot = buf.readInt();
                slotSelection.slots.put(key, slot);
            }
            return slotSelection;
        }
    };

    public int get(Player player) {
        return this.slots.get(player.getId());
    }

    public void set(Player player, int selectedSlot) {
        this.slots.put(player.getId(), selectedSlot);
    }

    public void limit(int slot, int size) {
        IntIterator intIterator = this.slots.keySet().iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            int selectedSlot = this.slots.get(key);
            if (selectedSlot == 0) continue;
            int safeSlot = selectedSlot - 1;
            int i = safeSlot < slot ? selectedSlot : safeSlot;
            this.slots.put(key, i);
        }
    }

    public void grow(int slot) {
        IntIterator intIterator = this.slots.keySet().iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            int selectedSlot = this.slots.get(key);
            int i = slot == 0 ? selectedSlot + 1 : (selectedSlot < slot ? selectedSlot : selectedSlot + 1);
            this.slots.put(key, i);
        }
    }

    public void ceil(int max) {
        IntIterator intIterator = this.slots.keySet().iterator();
        while (intIterator.hasNext()) {
            int key = (Integer)intIterator.next();
            int i = this.slots.get(key);
            if (i <= max) continue;
            this.slots.put(key, max);
        }
    }

    public void clear() {
        this.slots.clear();
    }

    @NotNull
    private static Int2IntArrayMap defaultSlotMap() {
        Int2IntArrayMap map = new Int2IntArrayMap();
        map.defaultReturnValue(0);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SlotSelection)) {
            return false;
        }
        SlotSelection that = (SlotSelection)o;
        return this.slots == that.slots;
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

