/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components;

import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.util.Int2ValueMap;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UtilityComponent {
    public static final UtilityComponent BLANK = new UtilityComponent((Void)null){

        @Override
        public boolean isBlank() {
            return true;
        }
    };
    public static final String NAME = "utilities";
    private final Int2ObjectMap<ItemStack> slots;
    private static final Component OMINOUS_NAME = Component.translatable((String)"block.minecraft.ominous_banner").withStyle(ChatFormatting.GOLD);
    public static final Codec<Byte> SIZE_CODEC = PrimitiveCodec.BYTE.validate(i -> i > 0 ? (i < 3 ? DataResult.success((Object)i) : DataResult.error(() -> "\"size\" cannot be larger than 2; input: " + i)) : DataResult.error(() -> "\"size\" cannot be smaller than 1; input: " + i));
    public static final Codec<UtilityComponent> CODEC = Slots.CODEC.listOf().xmap(items -> {
        Int2ObjectArrayMap map = new Int2ObjectArrayMap(items.size());
        map.defaultReturnValue((Object)ItemStack.EMPTY);
        for (Slots slot : items) {
            map.put(slot.slot, (Object)slot.stack);
        }
        return new UtilityComponent((Int2ObjectArrayMap<ItemStack>)map);
    }, utility -> {
        ImmutableList.Builder list = ImmutableList.builder();
        utility.slots.forEach((integer, stack) -> list.add((Object)new Slots((int)integer, (ItemStack)stack)));
        return list.build();
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, UtilityComponent> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, UtilityComponent>(){

        public UtilityComponent decode(RegistryFriendlyByteBuf buf) {
            boolean isBlank = buf.readBoolean();
            if (isBlank) {
                return BLANK;
            }
            int size = buf.readVarInt();
            Int2ObjectArrayMap map = new Int2ObjectArrayMap(size);
            map.defaultReturnValue((Object)ItemStack.EMPTY);
            for (int i = 0; i < size; ++i) {
                int key = buf.readInt();
                ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buf);
                map.put(key, (Object)stack);
            }
            return new UtilityComponent((Int2ObjectArrayMap<ItemStack>)map);
        }

        public void encode(RegistryFriendlyByteBuf buf, UtilityComponent component) {
            boolean isBlank = component.isBlank();
            buf.writeBoolean(isBlank);
            if (isBlank) {
                return;
            }
            Int2ObjectMap<ItemStack> slots = component.slots;
            buf.writeVarInt(slots.size());
            slots.forEach((key, stack) -> {
                buf.writeInt(key.intValue());
                ItemStack.STREAM_CODEC.encode((Object)buf, stack);
            });
        }
    };

    public UtilityComponent(Int2ObjectArrayMap<ItemStack> map) {
        map.defaultReturnValue((Object)ItemStack.EMPTY);
        ImmutableList.Builder builder = ImmutableList.builder();
        map.forEach((integer, stack) -> {
            Type util = UtilityComponent.getUtilities(stack);
            if (!Type.NONE.equals((Object)util)) {
                builder.add((Object)util);
            }
        });
        this.slots = Int2ObjectMaps.unmodifiable(map);
    }

    private UtilityComponent(Void ignored) {
        this.slots = new Int2ValueMap<ItemStack>(ItemStack.EMPTY);
    }

    public static Optional<Mutable> get(ItemStack stack) {
        byte size;
        Byte utilities = (Byte)stack.get(Traits.UTILITIES);
        if (utilities != null) {
            size = utilities;
        } else {
            ReferenceTrait reference = (ReferenceTrait)stack.get(Traits.REFERENCE);
            if (reference == null) {
                return Optional.empty();
            }
            Optional<Byte> optional = reference.getUtilities();
            if (optional.isEmpty()) {
                return Optional.empty();
            }
            size = optional.get();
        }
        UtilityComponent component = (UtilityComponent)stack.getOrDefault(ITraitData.UTILITIES, (Object)BLANK);
        Mutable mutable = new Mutable(size, component, stack);
        return Optional.of(mutable);
    }

    public static byte getSize(ItemStack stack) {
        Optional<Byte> optional;
        if (stack.isEmpty()) {
            return 0;
        }
        Byte utilities = (Byte)stack.get(Traits.UTILITIES);
        if (utilities != null) {
            return utilities;
        }
        ReferenceTrait reference = (ReferenceTrait)stack.get(Traits.REFERENCE);
        if (reference != null && (optional = reference.getUtilities()).isPresent()) {
            return optional.get();
        }
        return 0;
    }

    public static boolean testItems(Player pPlayer, BiPredicate<ItemStack, Mutable> predicate) {
        ItemStack backpack = pPlayer.getItemBySlot(EquipmentSlot.BODY);
        Optional<Mutable> optional = UtilityComponent.get(backpack);
        if (optional.isEmpty()) {
            return false;
        }
        Mutable mutable = optional.get();
        for (Int2ObjectMap.Entry entry : mutable.slots.int2ObjectEntrySet()) {
            ItemStack value = (ItemStack)entry.getValue();
            if (!predicate.test(value, mutable)) continue;
            return true;
        }
        return false;
    }

    public static boolean consumeOminous(Player player, Runnable runnable) {
        ItemStack backpack = player.getItemBySlot(EquipmentSlot.BODY);
        Optional<Mutable> muteOptional = UtilityComponent.get(backpack);
        if (muteOptional.isEmpty()) {
            return false;
        }
        Mutable mutable = muteOptional.get();
        for (Int2ObjectMap.Entry entry : mutable.slots.int2ObjectEntrySet()) {
            ItemStack value = (ItemStack)entry.getValue();
            if (!Type.OMINOUS.test(value)) continue;
            value.shrink(1);
            mutable.freeze();
            runnable.run();
            return true;
        }
        return false;
    }

    public boolean has(Type type) {
        return this.get(type) != null;
    }

    @Nullable
    public ItemStack get(Type type) {
        ObjectCollection values = this.slots.values();
        for (ItemStack value : values) {
            if (!type.test(value)) continue;
            return value;
        }
        return null;
    }

    @NotNull
    private static Type getUtilities(ItemStack stack) {
        return Type.NONE;
    }

    public ItemStack get(int i) {
        return (ItemStack)this.slots.get(i);
    }

    public static Type getType(ItemStack stack) {
        for (Type value : Type.values()) {
            if (!value.test(stack)) continue;
            return value;
        }
        return Type.NONE;
    }

    public boolean isEmpty() {
        return this.slots.isEmpty();
    }

    public boolean isBlank() {
        return false;
    }

    public void clear() {
        this.slots.clear();
    }

    public Iterator<ItemStack> iterator() {
        return this.slots.values().iterator();
    }

    public static boolean isOminousBanner(ItemStack stack) {
        if (!stack.is(Items.WHITE_BANNER) || !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP)) {
            return false;
        }
        Component component = (Component)stack.get(DataComponents.ITEM_NAME);
        return component != null && component.equals((Object)OMINOUS_NAME);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UtilityComponent)) {
            return false;
        }
        UtilityComponent component = (UtilityComponent)o;
        return Objects.equals(this.slots, component.slots);
    }

    public int hashCode() {
        return Objects.hash(this.slots);
    }

    public static class Mutable {
        public final Int2ObjectArrayMap<ItemStack> slots;
        public final byte size;
        private final ItemStack holder;

        Mutable(byte size, UtilityComponent component, ItemStack holder) {
            Int2ObjectArrayMap map = new Int2ObjectArrayMap(component.slots);
            map.defaultReturnValue((Object)ItemStack.EMPTY);
            this.slots = map;
            this.size = size;
            this.holder = holder;
        }

        public UtilityComponent freeze() {
            UtilityComponent component;
            this.slots.int2ObjectEntrySet().removeIf(stack -> ((ItemStack)stack.getValue()).isEmpty());
            if (this.slots.isEmpty()) {
                this.holder.remove(ITraitData.UTILITIES);
                component = BLANK;
            } else {
                component = new UtilityComponent(this.slots);
                this.holder.set(ITraitData.UTILITIES, (Object)component);
            }
            return component;
        }
    }

    public static enum Type {
        SPYGLASS(Items.SPYGLASS, false),
        CLOCK(Items.CLOCK, false),
        COMPASS(Items.COMPASS, false),
        RECOVERY(Items.RECOVERY_COMPASS, false),
        LODESTONE(stack -> stack.is(Items.COMPASS) && stack.has(DataComponents.LODESTONE_TRACKER), false),
        CONDUIT(Items.CONDUIT, false),
        OMINOUS(UtilityComponent::isOminousBanner, true),
        ROCKET(Items.FIREWORK_ROCKET, true),
        TOTEM(Items.TOTEM_OF_UNDYING, false),
        LANTERN(stack -> stack.is(Items.LANTERN) || stack.is(Items.SOUL_LANTERN), false),
        CRAFTING(Items.CRAFTING_TABLE, false),
        CAULDRON(Items.CAULDRON, false),
        POT(Items.DECORATED_POT, false),
        NONE(Items.AIR, true);

        private final Predicate<ItemStack> predicate;
        private final boolean isStackable;

        private Type(Item item, boolean stackable) {
            this((ItemStack stack) -> stack.is(item), stackable);
        }

        private Type(Predicate<ItemStack> predicate, boolean stackable) {
            this.predicate = predicate;
            this.isStackable = stackable;
        }

        public boolean test(ItemStack item) {
            return this.predicate.test(item);
        }

        public boolean isStackable() {
            return this.isStackable;
        }
    }

    private record Slots(int slot, ItemStack stack) {
        private static final Codec<Slots> CODEC = RecordCodecBuilder.create(in -> in.group((App)PrimitiveCodec.INT.fieldOf("slot").forGetter(Slots::slot), (App)ItemStack.CODEC.fieldOf("item").forGetter(Slots::stack)).apply((Applicative)in, Slots::new));
    }
}

