/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components.ender;

import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.components.reference.ReferenceRegistry;
import com.beansgalaxy.backpacks.traits.Traits;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EmptyEnderItem
extends Item {
    public static final Codec<UnboundEnderTraits> CODEC = Codec.of((Encoder)ResourceLocation.CODEC.comap(UnboundEnderTraits::location), (Decoder)ResourceLocation.CODEC.flatMap(location -> ReferenceRegistry.get(location) == null ? DataResult.error(() -> "No trait is registered using the given location: " + String.valueOf(location)) : DataResult.success((Object)new UnboundEnderTraits((ResourceLocation)location))));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, UnboundEnderTraits> STREAM_CODEC = ResourceLocation.STREAM_CODEC.map(UnboundEnderTraits::new, UnboundEnderTraits::location);

    public EmptyEnderItem(String location) {
        super(new Item.Properties().stacksTo(1).component(Traits.EMPTY_ENDER, (Object)new UnboundEnderTraits(location)));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack thisStack = player.getItemInHand(hand);
        UnboundEnderTraits traits = (UnboundEnderTraits)thisStack.get(Traits.EMPTY_ENDER);
        if (traits == null) {
            return InteractionResultHolder.pass((Object)thisStack);
        }
        if (level.isClientSide) {
            return InteractionResultHolder.success((Object)thisStack);
        }
        thisStack.consume(1, (LivingEntity)player);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        ItemStack newStack = EnderTraits.createItem(player, traits.location);
        if (thisStack.isEmpty()) {
            return InteractionResultHolder.consume((Object)newStack);
        }
        if (!player.getInventory().add(-1, newStack.copy())) {
            player.drop(newStack, false);
        }
        return InteractionResultHolder.consume((Object)thisStack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> lines, TooltipFlag flag) {
        UnboundEnderTraits unboundEnderTraits;
        super.appendHoverText(stack, pContext, lines, flag);
        if (flag.isAdvanced() && (unboundEnderTraits = (UnboundEnderTraits)stack.get(Traits.EMPTY_ENDER)) != null) {
            lines.add((Component)Component.translatable((String)"tooltip.beansbackpacks.advanced.reference", (Object[])new Object[]{Component.literal((String)unboundEnderTraits.location.toString())}).withStyle(ChatFormatting.DARK_GRAY));
        }
    }

    public record UnboundEnderTraits(ResourceLocation location) {
        UnboundEnderTraits(String location) {
            this(ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)location));
        }
    }
}

