/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components.ender;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.components.SlotSelection;
import com.beansgalaxy.backpacks.components.ender.EnderTraits;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.lunch_box.LunchBoxTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.Cancellable;

public class EnderItem
extends Item {
    public EnderItem() {
        super(new Item.Properties().stacksTo(1));
    }

    private static void runIfPresent(ItemStack ender, LivingEntity entity, Cancellable cir, BiConsumer<EnderTraits, GenericTraits> consumer) {
        EnderItem.getEnderTrait(ender).ifPresent(enderTraits -> {
            Level level = entity.level();
            GenericTraits traits = enderTraits.getTrait(level);
            consumer.accept((EnderTraits)enderTraits, traits);
        });
    }

    private static Optional<EnderTraits> getEnderTrait(ItemStack ender) {
        return Optional.ofNullable((EnderTraits)ender.get(Traits.ENDER));
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack ender = pPlayer.getItemInHand(pUsedHand);
        InteractionResultHolder pass = InteractionResultHolder.pass((Object)ender);
        EnderCallback<InteractionResultHolder> cir = EnderCallback.of(pass);
        return (InteractionResultHolder)cir.getReturnValue();
    }

    public boolean overrideOtherStackedOnMe(ItemStack ender, ItemStack $$1, Slot $$2, ClickAction $$3, Player player, SlotAccess $$5) {
        EnderCallback<Boolean> cir = EnderCallback.of(false);
        EnderItem.runIfPresent(ender, (LivingEntity)player, cir, (enderTraits, genericTraits) -> genericTraits.stackedOnMe((ComponentHolder)enderTraits, $$1, $$2, $$3, player, $$5, (CallbackInfoReturnable<Boolean>)cir));
        return (Boolean)cir.getReturnValue();
    }

    public boolean overrideStackedOnOther(ItemStack ender, Slot slot, ClickAction $$2, Player player) {
        EnderCallback<Boolean> cir = EnderCallback.of(false);
        EnderItem.runIfPresent(ender, (LivingEntity)player, cir, (enderTraits, genericTraits) -> genericTraits.stackedOnOther((ComponentHolder)enderTraits, slot.getItem(), slot, $$2, player, (CallbackInfoReturnable<Boolean>)cir));
        return (Boolean)cir.getReturnValue();
    }

    public ItemStack finishUsingItem(ItemStack ender, Level pLevel, LivingEntity entity) {
        EnderCallback<ItemStack> cir = EnderCallback.of(ender);
        EnderItem.runIfPresent(ender, entity, cir, (enderTraits, genericTraits) -> {
            if (genericTraits instanceof LunchBoxTraits) {
                LunchBoxTraits lunchBoxTraits = (LunchBoxTraits)genericTraits;
                lunchBoxTraits.finishUsingItem((ComponentHolder)enderTraits, ender, pLevel, entity, (CallbackInfoReturnable<ItemStack>)cir);
            }
        });
        return (ItemStack)cir.getReturnValue();
    }

    public int getUseDuration(ItemStack ender, LivingEntity entity) {
        EnderCallback<Integer> cir = EnderCallback.of(0);
        EnderItem.getEnderTrait(ender).ifPresent(enderTraits -> {
            GenericTraits trait = enderTraits.getTrait(entity.level());
            if (trait instanceof LunchBoxTraits) {
                int selectedSlotSafe;
                LunchBoxTraits lunchBoxTraits = (LunchBoxTraits)trait;
                List<ItemStack> stacks = enderTraits.get(ITraitData.ITEM_STACKS);
                if (stacks == null || stacks.isEmpty()) {
                    return;
                }
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    SlotSelection selection = enderTraits.get(ITraitData.SLOT_SELECTION);
                    selectedSlotSafe = selection != null ? selection.get(player) : 0;
                } else {
                    selectedSlotSafe = 0;
                }
                ItemStack first = stacks.get(selectedSlotSafe);
                cir.setReturnValue(first.getUseDuration(entity));
            }
        });
        if (cir.isCancelled()) {
            return (Integer)cir.getReturnValue();
        }
        return super.getUseDuration(ender, entity);
    }

    public UseAnim getUseAnimation(ItemStack ender) {
        EnderCallback<UseAnim> cir = EnderCallback.of(UseAnim.NONE);
        EnderItem.getEnderTrait(ender).ifPresent(enderTraits -> enderTraits.getTrait().ifPresent(trait -> {
            if (trait instanceof LunchBoxTraits) {
                List<ItemStack> stacks = enderTraits.get(ITraitData.ITEM_STACKS);
                if (stacks == null || stacks.isEmpty()) {
                    return;
                }
                cir.setReturnValue(UseAnim.EAT);
            }
        }));
        if (cir.isCancelled()) {
            return (UseAnim)cir.getReturnValue();
        }
        return super.getUseAnimation(ender);
    }

    public void appendHoverText(ItemStack ender, Item.TooltipContext $$1, List<Component> lines, TooltipFlag flag) {
        EnderItem.getEnderTrait(ender).ifPresent(enderTraits -> {
            GenericTraits trait = enderTraits.getTrait(CommonClient.getLevel());
            Component displayName = enderTraits.getDisplayName();
            lines.add((Component)Component.translatable((String)"ender.beansbackpacks.bound_player", (Object[])new Object[]{displayName}).withStyle(ChatFormatting.GOLD));
            trait.client().appendTooltipLines(trait, lines::add);
            if (flag.isAdvanced()) {
                lines.add((Component)Component.translatable((String)"tooltip.beansbackpacks.advanced.reference", (Object[])new Object[]{Component.literal((String)enderTraits.trait().toString())}).withStyle(ChatFormatting.DARK_GRAY));
            }
        });
    }

    public static class EnderCallback<R>
    extends CallbackInfoReturnable<R> {
        private EnderCallback(R returnValue) {
            super("ender", true, returnValue);
        }

        static <R> EnderCallback<R> of(R returnValue) {
            return new EnderCallback<R>(returnValue);
        }
    }
}

