/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components.ender;

import com.beansgalaxy.backpacks.data.EnderStorage;
import com.beansgalaxy.backpacks.items.ModItems;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderTraits;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.traits.generic.ItemStorageTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public final class EnderTraits
implements ComponentHolder {
    private final UUID uuid;
    private final ResourceLocation location;
    @Nullable
    private Level level = null;
    public static final Codec<EnderTraits> CODEC = RecordCodecBuilder.create(in -> in.group((App)UUIDUtil.STRING_CODEC.fieldOf("owner").forGetter(EnderTraits::owner), (App)ResourceLocation.CODEC.fieldOf("location").forGetter(EnderTraits::trait)).apply((Applicative)in, EnderTraits::new));
    public static final StreamCodec<? super RegistryFriendlyByteBuf, EnderTraits> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, EnderTraits>(){

        public void encode(RegistryFriendlyByteBuf buf, EnderTraits traits) {
            ResourceLocation.STREAM_CODEC.encode((Object)buf, (Object)traits.location);
            UUIDUtil.STREAM_CODEC.encode((Object)buf, (Object)traits.uuid);
        }

        public EnderTraits decode(RegistryFriendlyByteBuf buf) {
            ResourceLocation location = (ResourceLocation)ResourceLocation.STREAM_CODEC.decode((Object)buf);
            UUID uuid = (UUID)UUIDUtil.STREAM_CODEC.decode((Object)buf);
            EnderTraits enderTraits = new EnderTraits(uuid, location);
            return enderTraits;
        }
    };

    public static Optional<EnderTraits> get(ItemStack stack) {
        if (!ModItems.ENDER_POUCH.is(stack)) {
            return Optional.empty();
        }
        EnderTraits enderTraits = (EnderTraits)stack.get(Traits.ENDER);
        return Optional.ofNullable(enderTraits);
    }

    public EnderTraits(UUID uuid, ResourceLocation location) {
        this.uuid = uuid;
        this.location = location;
    }

    public void reload(Level level) {
        this.level = level;
    }

    public boolean isLoaded() {
        return this.level != null;
    }

    public <T> Optional<T> mapLoaded(Function<Level, T> map) {
        return this.isLoaded() ? Optional.ofNullable(map.apply(this.level)) : Optional.empty();
    }

    public void runLoaded(Consumer<Level> run) {
        if (this.isLoaded()) {
            run.accept(this.level);
        }
    }

    public static Optional<ItemStorageTraits> getItemStorage(ItemStack stack) {
        EnderTraits enderTraits = (EnderTraits)stack.get(Traits.ENDER);
        if (enderTraits != null) {
            return enderTraits.getTrait().map(traits -> {
                if (traits instanceof ItemStorageTraits) {
                    ItemStorageTraits storageTraits = (ItemStorageTraits)traits;
                    return storageTraits;
                }
                return null;
            });
        }
        return Optional.empty();
    }

    public static ItemStack createItem(Player player, ResourceLocation location) {
        Item enderItem = ModItems.ENDER_POUCH.get();
        Level level = player.level();
        UUID uuid = player.getUUID();
        EnderStorage.get(level).get(player, location);
        EnderTraits traits = new EnderTraits(uuid, location);
        ItemStack defaultInstance = enderItem.getDefaultInstance();
        defaultInstance.set(Traits.ENDER, (Object)traits);
        return defaultInstance;
    }

    public UUID owner() {
        return this.uuid;
    }

    public ResourceLocation trait() {
        return this.location;
    }

    public Optional<GenericTraits> getTrait() {
        return this.mapLoaded(level -> EnderStorage.get(level).getTrait(this.uuid, this.location));
    }

    public GenericTraits getTrait(Level level) {
        if (this.level == null) {
            this.level = level;
        }
        return EnderStorage.get(this.level).getTrait(this.uuid, this.location);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EnderTraits that = (EnderTraits)obj;
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.location);
    }

    public String toString() {
        return "EnderTraits[owner=" + String.valueOf(this.uuid) + ", trait=" + String.valueOf(this.location) + "]";
    }

    @Override
    @Nullable
    public <T> T remove(DataComponentType<? extends T> type) {
        return this.mapLoaded(level -> EnderStorage.get(level).remove(this.uuid, this.location, type)).orElse(null);
    }

    @Override
    public <T> void set(DataComponentType<? super T> type, T trait) {
        this.runLoaded(level -> EnderStorage.get(level).set(this.uuid, this.location, type, trait));
    }

    @Override
    public <T> T get(DataComponentType<? extends T> type) {
        return this.mapLoaded(level -> {
            EnderStorage enderStorage = EnderStorage.get(level);
            return enderStorage.get(this.uuid, this.location).get((Object)type);
        }).orElse(null);
    }

    @Override
    public void setChanged() {
        if (!this.isLoaded() || this.level.isClientSide) {
            return;
        }
        Predicate<ItemStack> matchTraits = stack -> this.equals(stack.get(Traits.ENDER));
        HashSet<ServerPlayer> listeners = this.getListeners(this.level);
        Iterator<ServerPlayer> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ServerPlayer listener = iterator.next();
            if (listener.getInventory().contains(matchTraits) || matchTraits.test(listener.inventoryMenu.getCarried())) {
                SendEnderTraits.send(listener, this.uuid, this.location);
                continue;
            }
            iterator.remove();
        }
    }

    public void broadcastChanges() {
    }

    public void broadcastChanges(ServerPlayer player) {
        Predicate<ItemStack> matchTraits = stack -> this.equals(stack.get(Traits.ENDER));
        HashSet<ServerPlayer> listeners = this.getListeners(player.level());
        Iterator<ServerPlayer> iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ServerPlayer listener = iterator.next();
            if (listener.equals((Object)player)) continue;
            if (listener.getInventory().contains(matchTraits) || matchTraits.test(listener.inventoryMenu.getCarried())) {
                SendEnderTraits.send(listener, this.uuid, this.location);
                continue;
            }
            iterator.remove();
        }
    }

    private HashSet<ServerPlayer> getListeners(Level level) {
        return EnderStorage.get(level).getListeners(this.uuid);
    }

    public void addListener(ServerPlayer serverPlayer) {
        HashSet<ServerPlayer> listeners = this.getListeners(serverPlayer.level());
        if (!listeners.contains(serverPlayer)) {
            listeners.add(serverPlayer);
            EnderStorage.sendEntry(serverPlayer, this.uuid, this.location);
        }
    }

    public Component getDisplayName() {
        return this.mapLoaded(level -> EnderStorage.get(level).getDisplayName(this.uuid)).orElse((Component)Component.literal((String)"\u00c2\u00a7kPlayer"));
    }
}

