/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components.equipable;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record EquipmentModel(HashMap<Attachment, ResourceLocation> attachments, boolean isBuiltInLeatherModel) {
    public static final Codec<HashMap<Attachment, ResourceLocation>> ENTRY_CODEC = RecordCodecBuilder.create(in -> in.group((App)ResourceLocation.CODEC.optionalFieldOf("head").forGetter(equipable -> Optional.ofNullable((ResourceLocation)equipable.get((Object)Attachment.HEAD))), (App)ResourceLocation.CODEC.optionalFieldOf("body").forGetter(equipable -> Optional.ofNullable((ResourceLocation)equipable.get((Object)Attachment.BODY))), (App)ResourceLocation.CODEC.optionalFieldOf("back").forGetter(equipable -> Optional.ofNullable((ResourceLocation)equipable.get((Object)Attachment.BACK))), (App)ResourceLocation.CODEC.optionalFieldOf("leftArm").forGetter(equipable -> Optional.ofNullable((ResourceLocation)equipable.get((Object)Attachment.L_ARM))), (App)ResourceLocation.CODEC.optionalFieldOf("rightArm").forGetter(equipable -> Optional.ofNullable((ResourceLocation)equipable.get((Object)Attachment.R_ARM))), (App)ResourceLocation.CODEC.optionalFieldOf("leftLeg").forGetter(equipable -> Optional.ofNullable((ResourceLocation)equipable.get((Object)Attachment.L_LEG))), (App)ResourceLocation.CODEC.optionalFieldOf("rightLeg").forGetter(equipable -> Optional.ofNullable((ResourceLocation)equipable.get((Object)Attachment.R_LEG)))).apply((Applicative)in, (h, c, b, la, ra, ll, rl) -> {
        HashMap map = new HashMap();
        EquipmentModel.putIn(map, Attachment.HEAD, h);
        EquipmentModel.putIn(map, Attachment.BODY, c);
        EquipmentModel.putIn(map, Attachment.BACK, b);
        EquipmentModel.putIn(map, Attachment.L_ARM, la);
        EquipmentModel.putIn(map, Attachment.R_ARM, ra);
        EquipmentModel.putIn(map, Attachment.L_LEG, ll);
        EquipmentModel.putIn(map, Attachment.R_LEG, rl);
        return map;
    }));
    public static final Codec<EquipmentModel> CODEC = ENTRY_CODEC.xmap(model -> new EquipmentModel((HashMap<Attachment, ResourceLocation>)model, false), EquipmentModel::attachments);
    public static final StreamCodec<RegistryFriendlyByteBuf, EquipmentModel> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, EquipmentModel>(){

        public void encode(RegistryFriendlyByteBuf buf, EquipmentModel equipmentModel) {
            buf.writeBoolean(equipmentModel.isBuiltInLeatherModel);
            if (equipmentModel.isBuiltInLeatherModel) {
                return;
            }
            buf.writeMap(equipmentModel.attachments, FriendlyByteBuf::writeEnum, FriendlyByteBuf::writeResourceLocation);
        }

        public EquipmentModel decode(RegistryFriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return new EquipmentModel(new HashMap<Attachment, ResourceLocation>(), true);
            }
            Map map = buf.readMap(buf1 -> (Attachment)buf1.readEnum(Attachment.class), FriendlyByteBuf::readResourceLocation);
            HashMap<Attachment, ResourceLocation> attachments = new HashMap<Attachment, ResourceLocation>(map);
            return new EquipmentModel(attachments, false);
        }
    };

    private static <A, B, M extends Map<A, B>> void putIn(M map, A a, Optional<B> b) {
        b.ifPresent(c -> map.put(a, c));
    }

    public static enum Attachment {
        HEAD,
        BODY,
        BACK,
        R_ARM,
        L_ARM,
        R_LEG,
        L_LEG;

    }
}

