/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.components.reference;

import com.beansgalaxy.backpacks.components.DisplayComponent;
import com.beansgalaxy.backpacks.components.FilterComponent;
import com.beansgalaxy.backpacks.components.reference.NonTrait;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;

public record ReferenceRegistry(GenericTraits traits, ItemAttributeModifiers modifiers, byte utilities, DisplayComponent display, FilterComponent filter) {
    public static final HashMap<ResourceLocation, ReferenceRegistry> REFERENCES = new HashMap();
    public static StreamCodec<RegistryFriendlyByteBuf, ReferenceRegistry> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ReferenceRegistry>(){

        public void encode(RegistryFriendlyByteBuf buf, ReferenceRegistry reference) {
            TraitComponentKind<? extends GenericTraits> kind = reference.traits.kind();
            TraitComponentKind.STREAM_CODEC.encode((Object)buf, kind);
            this.encode(buf, kind.codec(), reference.traits);
            ItemAttributeModifiers.STREAM_CODEC.encode((Object)buf, (Object)reference.modifiers);
            boolean hasDisplay = reference.display != null;
            buf.writeBoolean(hasDisplay);
            if (hasDisplay) {
                DisplayComponent.STREAM_CODEC.encode((Object)buf, (Object)reference.display);
            }
            buf.writeByte(reference.utilities);
            FilterComponent.STREAM_CODEC.encode((Object)buf, (Object)reference.filter);
        }

        private <T extends GenericTraits> void encode(RegistryFriendlyByteBuf buf, Codec<T> codec, GenericTraits fields) {
            buf.writeJsonWithCodec(codec, (Object)fields);
        }

        public ReferenceRegistry decode(RegistryFriendlyByteBuf buf) {
            TraitComponentKind kind = (TraitComponentKind)TraitComponentKind.STREAM_CODEC.decode((Object)buf);
            GenericTraits fields = (GenericTraits)buf.readJsonWithCodec(kind.codec());
            ItemAttributeModifiers modifiers = (ItemAttributeModifiers)ItemAttributeModifiers.STREAM_CODEC.decode((Object)buf);
            boolean hasDisplay = buf.readBoolean();
            DisplayComponent display = hasDisplay ? (DisplayComponent)DisplayComponent.STREAM_CODEC.decode((Object)buf) : null;
            byte utilities = buf.readByte();
            FilterComponent filter = (FilterComponent)FilterComponent.STREAM_CODEC.decode((Object)buf);
            return new ReferenceRegistry(fields, modifiers, utilities, display, filter);
        }
    };

    public static ReferenceRegistry get(ResourceLocation location) {
        ReferenceRegistry reference = REFERENCES.get(location);
        if (reference == null) {
            return ReferenceRegistry.createEmptyReference();
        }
        return reference;
    }

    public static ReferenceRegistry createEmptyReference() {
        return new ReferenceRegistry(NonTrait.INSTANCE, ItemAttributeModifiers.EMPTY, 0, null, FilterComponent.EMPTY);
    }

    @Nullable
    public static ReferenceRegistry getNullable(ResourceLocation location) {
        return REFERENCES.get(location);
    }

    public static void put(ResourceLocation location, ReferenceRegistry referenceRegistry) {
        REFERENCES.put(location, referenceRegistry);
    }
}

