/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.container;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.access.EquipmentSlotAccess;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.container.UtilityContainer;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class BackSlot
extends Slot
implements EquipmentSlotAccess {
    public static final int SLOT = 41;
    private final Player owner;

    public BackSlot(Inventory inv) {
        super((Container)inv, 41, BackSlot.getX(), BackSlot.getY());
        this.owner = inv.player;
    }

    public static int getX() {
        return CommonClass.CLIENT_CONFIG.back_slot_pos.get(0);
    }

    public static int getY() {
        return CommonClass.CLIENT_CONFIG.back_slot_pos.get(1);
    }

    public boolean mayPlace(ItemStack stack) {
        boolean standardCheck = stack.isEmpty();
        if (standardCheck) {
            return true;
        }
        BackpackTraits traits = BackpackTraits.get(stack);
        if (traits == null) {
            return false;
        }
        return traits.slots().test(EquipmentSlot.BODY);
    }

    public boolean mayPickup(Player player) {
        ItemStack stack = this.getItem();
        if (stack.isEmpty()) {
            return true;
        }
        UtilityComponent utilities = (UtilityComponent)stack.get(ITraitData.UTILITIES);
        if (utilities != null) {
            return false;
        }
        BackpackTraits traits = BackpackTraits.get(stack);
        if (traits == null) {
            return true;
        }
        return traits.isEmpty(stack);
    }

    public void setByPlayer(ItemStack pNewStack, ItemStack pOldStack) {
        this.owner.onEquipItem(EquipmentSlot.BODY, pOldStack, pNewStack);
        super.setByPlayer(pNewStack, pOldStack);
    }

    public void setChanged() {
        super.setChanged();
        UtilityContainer utilities = UtilityContainer.get(this.owner);
        ItemStack newStack = this.getItem();
        utilities.size = UtilityComponent.getSize(newStack);
    }

    @Override
    public EquipmentSlot getSlot() {
        return EquipmentSlot.BODY;
    }

    @Nullable
    public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
        return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"item/empty_slot_backpack"));
    }
}

