/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.container;

import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.components.UtilityComponent;
import com.beansgalaxy.backpacks.traits.ITraitData;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class UtilityContainer
implements Container {
    private final BackData owner;
    public byte size;
    private static int EFFECT_COOLDOWN = 40;
    private int effectCooldown = 0;
    private int omenCooldown = 0;

    public UtilityContainer(BackData owner) {
        this.owner = owner;
    }

    public static UtilityContainer get(Player player) {
        BackData backData = BackData.get(player);
        return backData.getUtility();
    }

    public int getContainerSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.getUtility().isEmpty();
    }

    public ItemStack getItem(int i) {
        return this.getUtility().get(i);
    }

    public ItemStack removeItem(int i, int amount) {
        return this.mapMutable(mute -> {
            ItemStack itemStack = (ItemStack)mute.slots.get(i);
            if (itemStack.isEmpty()) {
                return (ItemStack)mute.slots.remove(i);
            }
            int count = itemStack.getCount();
            if (count <= amount) {
                return (ItemStack)mute.slots.remove(i);
            }
            ItemStack copy = itemStack.copyWithCount(amount);
            itemStack.shrink(amount);
            return copy;
        }, ItemStack.EMPTY);
    }

    public ItemStack removeItemNoUpdate(int i) {
        return this.mapMutable(mute -> (ItemStack)mute.slots.remove(i), ItemStack.EMPTY);
    }

    public void setItem(int i, ItemStack stack) {
        this.getMutable().ifPresent(mute -> {
            mute.slots.put(i, (Object)stack);
            mute.freeze();
        });
    }

    private Optional<UtilityComponent.Mutable> getMutable() {
        ItemStack backpack = (ItemStack)this.owner.beans_Backpacks_3$getBody().getFirst();
        if (backpack.isEmpty()) {
            return Optional.empty();
        }
        return UtilityComponent.get(backpack);
    }

    private <T> T mapMutable(Function<UtilityComponent.Mutable, T> map, T orElse) {
        Optional<UtilityComponent.Mutable> mutable = this.getMutable();
        if (mutable.isEmpty()) {
            return orElse;
        }
        UtilityComponent.Mutable mute = mutable.get();
        T apply = map.apply(mute);
        mute.freeze();
        return apply;
    }

    private UtilityComponent getUtility() {
        ItemStack backpack = (ItemStack)this.owner.beans_Backpacks_3$getBody().getFirst();
        return (UtilityComponent)backpack.getOrDefault(ITraitData.UTILITIES, (Object)UtilityComponent.BLANK);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        ItemStack backpack = (ItemStack)this.owner.beans_Backpacks_3$getBody().getFirst();
        backpack.remove(ITraitData.UTILITIES);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UtilityContainer)) {
            return false;
        }
        UtilityContainer container = (UtilityContainer)o;
        return this.size == container.size && Objects.equals(this.owner, container.owner);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.size);
    }

    public void tick(Inventory inventory) {
        Level level;
        if (this.effectCooldown > 0) {
            --this.effectCooldown;
            return;
        }
        Player player = inventory.player;
        Optional<UtilityComponent.Mutable> optionalMute = this.getMutable();
        if (optionalMute.isEmpty()) {
            return;
        }
        UtilityComponent.Mutable mutable = optionalMute.get();
        ItemStack first = (ItemStack)mutable.slots.get(0);
        ItemStack second = (ItemStack)mutable.slots.get(1);
        UtilityComponent.Type firstType = UtilityComponent.getType(first);
        UtilityComponent.Type secondType = UtilityComponent.getType(second);
        if (player.isInWaterOrBubble() || player.level().isRaining()) {
            if (firstType.equals((Object)UtilityComponent.Type.CONDUIT)) {
                if (secondType.equals((Object)UtilityComponent.Type.CONDUIT)) {
                    MobEffectInstance effect = new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 1, true, true);
                    player.addEffect(effect);
                    return;
                }
                effect = new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 0, true, true);
                player.addEffect(effect);
                this.effectCooldown = EFFECT_COOLDOWN;
            } else if (secondType.equals((Object)UtilityComponent.Type.CONDUIT)) {
                effect = new MobEffectInstance(MobEffects.CONDUIT_POWER, 260, 0, true, true);
                player.addEffect(effect);
                this.effectCooldown = EFFECT_COOLDOWN;
            }
        }
        if ((level = player.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (firstType.equals((Object)UtilityComponent.Type.OMINOUS)) {
                this.consumeOminousEffect(player, serverLevel, mutable, 0);
            } else if (secondType.equals((Object)UtilityComponent.Type.OMINOUS)) {
                this.consumeOminousEffect(player, serverLevel, mutable, 1);
            }
        }
    }

    private void consumeOminousEffect(Player player, ServerLevel serverLevel, UtilityComponent.Mutable mutable, int i) {
        if (this.omenCooldown > 0) {
            --this.omenCooldown;
            return;
        }
        MobEffectInstance effect = player.getEffect(MobEffects.BAD_OMEN);
        if (effect == null) {
            effect = player.getEffect(MobEffects.TRIAL_OMEN);
        }
        if (effect == null) {
            effect = player.getEffect(MobEffects.RAID_OMEN);
        }
        if (effect != null) {
            this.omenCooldown = (int)((float)effect.getDuration() / ((float)EFFECT_COOLDOWN * 0.55f));
        } else if (this.isInStructure(serverLevel, player, (TagKey<Structure>)StructureTags.VILLAGE) || this.isInStructure(serverLevel, player, (TagKey<Structure>)StructureTags.ON_TRIAL_CHAMBERS_MAPS)) {
            MobEffectInstance omen = new MobEffectInstance(MobEffects.BAD_OMEN, 5999, 0, true, true);
            player.addEffect(omen);
            ((ItemStack)mutable.slots.get(i)).shrink(1);
            mutable.freeze();
        }
    }

    private boolean isInStructure(ServerLevel level, Player player, TagKey<Structure> tag) {
        Optional optional = level.registryAccess().lookup(Registries.STRUCTURE);
        if (optional.isEmpty()) {
            return false;
        }
        HolderLookup.RegistryLookup lookup = (HolderLookup.RegistryLookup)optional.get();
        Optional optionalReference = lookup.get(tag);
        if (optionalReference.isEmpty()) {
            return false;
        }
        HolderSet.Named aThrow = (HolderSet.Named)optionalReference.get();
        StructureManager manager = level.structureManager();
        StructureStart at = manager.getStructureWithPieceAt(player.blockPosition(), (HolderSet)aThrow);
        return at.isValid();
    }

    private void applyConduitEffect(int amplifier, Player player) {
    }
}

