/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data;

import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.components.reference.ReferenceRegistry;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.network.clientbound.SendEnderEntry;
import com.beansgalaxy.backpacks.traits.ITraitData;
import com.beansgalaxy.backpacks.traits.TraitComponentKind;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnderStorage {
    public static final ResourceLocation LEGACY_ENDER_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)"legacy_ender");
    private final HashMap<UUID, PlayerEntry> storage = new HashMap();
    public static final StreamCodec<RegistryFriendlyByteBuf, Reference2ObjectOpenHashMap<DataComponentType<?>, Object>> ENTRY_MAP_STREAM_CODEC = StreamCodec.of((buf, map) -> {
        int size = map.size();
        buf.writeInt(size);
        map.forEach((key, value) -> EnderStorage.encodeMap(buf, key, value));
    }, buf -> {
        Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            DataComponentType key = (DataComponentType)DataComponentType.STREAM_CODEC.decode(buf);
            Object decode = key.streamCodec().decode(buf);
            map.put((Object)key, decode);
        }
        return map;
    });

    public static EnderStorage get(Level level) {
        MinecraftServer server = level.getServer();
        if (server == null) {
            return CommonClient.getEnderStorage();
        }
        return ServerSave.getSave((MinecraftServer)server, (boolean)true).enderStorage;
    }

    public PlayerEntry get(UUID uuid) {
        return this.storage.computeIfAbsent(uuid, key -> new PlayerEntry());
    }

    public GenericTraits getTrait(UUID uuid, ResourceLocation location) {
        return this.get((UUID)uuid).get((ResourceLocation)location).trait;
    }

    public Reference2ObjectOpenHashMap<DataComponentType<?>, Object> get(UUID uuid, ResourceLocation location) {
        return this.get((UUID)uuid).get((ResourceLocation)location).data;
    }

    public Reference2ObjectOpenHashMap<DataComponentType<?>, Object> get(Player player, ResourceLocation location) {
        PlayerEntry entry = this.get(player.getUUID());
        entry.displayName = player.getName();
        return entry.get((ResourceLocation)location).data;
    }

    public <T> T remove(UUID uuid, ResourceLocation location, DataComponentType<? extends T> type) {
        return (T)this.get((UUID)uuid).get((ResourceLocation)location).data.remove(type);
    }

    public <T> void set(UUID uuid, ResourceLocation location, DataComponentType<? super T> type, T trait) {
        TraitEntry entry = this.get((UUID)uuid).traits.computeIfAbsent(location, PlayerEntry::newMapFromLocation);
        if (entry != null) {
            entry.data.put(type, trait);
        }
    }

    public <T extends GenericTraits> void set(UUID uuid, ResourceLocation location, TraitComponentKind<T> kind, T trait, Reference2ObjectOpenHashMap<DataComponentType<?>, Object> data, Component name) {
        PlayerEntry entry = this.get(uuid);
        TraitEntry<T> newEntry = new TraitEntry<T>(kind, trait, data);
        entry.traits.put(location, newEntry);
        entry.displayName = name;
    }

    public void set(UUID uuid, ResourceLocation location, Reference2ObjectOpenHashMap<DataComponentType<?>, Object> traits, Component name) {
        PlayerEntry entry = this.get(uuid);
        TraitEntry traitEntry = entry.traits.get(location);
        if (traitEntry != null) {
            TraitEntry newEntry = new TraitEntry(traitEntry, traits);
            entry.traits.put(location, newEntry);
            entry.displayName = name;
        }
    }

    public void set(UUID uuid, ResourceLocation location, Reference2ObjectOpenHashMap<DataComponentType<?>, Object> traits) {
        PlayerEntry entry = this.get(uuid);
        TraitEntry traitEntry = entry.traits.get(location);
        if (traitEntry != null) {
            TraitEntry newEntry = new TraitEntry(traitEntry, traits);
            entry.traits.put(location, newEntry);
        }
    }

    public void setLegacyEnder(UUID uuid, List<ItemStack> itemStacks) {
        PlayerEntry playerEntry = this.get(uuid);
        playerEntry.traits.computeIfAbsent(LEGACY_ENDER_LOCATION, location -> {
            ReferenceRegistry reference = ReferenceRegistry.get(location);
            GenericTraits traits = reference.traits();
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
            map.put(ITraitData.ITEM_STACKS, (Object)itemStacks);
            return new TraitEntry<GenericTraits>(traits.kind(), traits, map);
        });
    }

    public void save(CompoundTag tag) {
        this.storage.forEach((uuid, entry) -> {
            DataResult encodedStart = PlayerEntry.ENTRY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, entry);
            encodedStart.ifSuccess(entryTag -> tag.put(uuid.toString(), entryTag));
        });
    }

    public void load(CompoundTag tag) {
        for (String key : tag.getAllKeys()) {
            UUID uuid = UUID.fromString(key);
            CompoundTag entryTag = tag.getCompound(key);
            PlayerEntry.ENTRY_CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)entryTag).ifSuccess(pair -> this.storage.put(uuid, (PlayerEntry)pair.getFirst()));
        }
    }

    public HashSet<ServerPlayer> getListeners(UUID uuid) {
        return this.get((UUID)uuid).listeners;
    }

    public Component getDisplayName(UUID uuid) {
        return this.get((UUID)uuid).displayName;
    }

    public static void sendEntry(ServerPlayer serverPlayer, UUID uuid, ResourceLocation location) {
        PlayerEntry entry = EnderStorage.get(serverPlayer.level()).get(uuid);
        TraitEntry traitEntry = entry.get(location);
        SendEnderEntry.send(serverPlayer, uuid, location, traitEntry.kind, traitEntry.trait, traitEntry.data, entry.displayName);
    }

    private static <T> void encodeMap(RegistryFriendlyByteBuf buf, DataComponentType<T> key, Object value) {
        DataComponentType.STREAM_CODEC.encode((Object)buf, key);
        key.streamCodec().encode((Object)buf, value);
    }

    private static final class PlayerEntry {
        private final HashMap<ResourceLocation, TraitEntry> traits = new HashMap();
        private final HashSet<ServerPlayer> listeners = new HashSet();
        private Component displayName = Component.empty();
        private static final MapCodec<GenericTraits> DISPATCHED_TRAIT_CODEC = TraitComponentKind.CODEC.dispatchMap("kind", GenericTraits::kind, kind -> kind.codec().fieldOf("trait"));
        private static final Codec<Pair<ResourceLocation, TraitEntry>> START_CODEC = RecordCodecBuilder.create(in -> in.group((App)ResourceLocation.CODEC.fieldOf("location").forGetter(Pair::first), (App)DISPATCHED_TRAIT_CODEC.forGetter(pair -> ((TraitEntry)pair.second()).trait), (App)DataComponentType.VALUE_MAP_CODEC.fieldOf("data").forGetter(pair -> ((TraitEntry)pair.second()).data)).apply((Applicative)in, (location, traits, data) -> {
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap(data);
            TraitEntry<GenericTraits> traitEntry = new TraitEntry<GenericTraits>((TraitComponentKind<GenericTraits>)traits.kind(), (GenericTraits)traits, (Reference2ObjectOpenHashMap<DataComponentType<?>, Object>)map);
            return Pair.of((Object)location, traitEntry);
        }));
        private static final Codec<PlayerEntry> ENTRY_CODEC = RecordCodecBuilder.create(in -> in.group((App)START_CODEC.listOf().fieldOf("entries").forGetter(entry -> entry.traits.entrySet().stream().map(e -> Pair.of((Object)((ResourceLocation)e.getKey()), (Object)((TraitEntry)e.getValue()))).toList()), (App)ComponentSerialization.CODEC.fieldOf("name").forGetter(entry -> entry.displayName)).apply((Applicative)in, (trait, name) -> {
            PlayerEntry entry = new PlayerEntry();
            entry.displayName = name;
            trait.forEach(reference -> entry.traits.put((ResourceLocation)reference.first(), (TraitEntry)reference.second()));
            return entry;
        }));

        private PlayerEntry() {
        }

        private TraitEntry get(ResourceLocation location) {
            return this.traits.computeIfAbsent(location, PlayerEntry::newMapFromLocation);
        }

        @Nullable
        private static TraitEntry newMapFromLocation(ResourceLocation key) {
            ReferenceRegistry reference = ReferenceRegistry.get(key);
            if (reference == null) {
                return null;
            }
            GenericTraits fields = reference.traits();
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
            return new TraitEntry<GenericTraits>(fields.kind(), fields, map);
        }
    }

    private record TraitEntry<T extends GenericTraits>(TraitComponentKind<T> kind, T trait, Reference2ObjectOpenHashMap<DataComponentType<?>, Object> data) {
        public TraitEntry(TraitEntry<T> entry, Reference2ObjectOpenHashMap<DataComponentType<?>, Object> traits) {
            this(entry.kind, entry.trait, traits);
        }
    }
}

