/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.data.config.screen.IConfig;
import com.beansgalaxy.backpacks.data.config.types.ConfigLine;
import com.beansgalaxy.backpacks.platform.Services;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TraitConfig
implements IConfig {
    public Map<String, JsonObject> traits = new HashMap<String, JsonObject>();

    @Override
    public String getPath() {
        return "traits";
    }

    @Override
    public Collection<ConfigLine> getLines() {
        return List.of();
    }

    @Override
    public void parse(String encodedConfig) {
        JsonObject object = JsonParser.parseString((String)encodedConfig).getAsJsonObject();
        object.asMap().forEach((string, element) -> {
            if (element.isJsonObject()) {
                this.traits.put((String)string, element.getAsJsonObject());
            } else {
                Constants.LOG.error("Error while parsing beansbackpacks-traits.json5; " + string + "is not a Json Object");
            }
        });
    }

    @Override
    public void write() {
        try {
            String roseKey;
            String bucketKey;
            String legKey;
            StringBuilder builder = new StringBuilder("{");
            Iterator<Map.Entry<String, JsonObject>> iterator = this.traits.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, JsonObject> entry = iterator.next();
                String name = entry.getKey();
                builder.append("\n  \"").append(name).append("\": ");
                StringWriter stringWriter = new StringWriter();
                JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
                jsonWriter.setLenient(true);
                JsonObject value = entry.getValue();
                Streams.write((JsonElement)value, (JsonWriter)jsonWriter);
                String string = stringWriter.toString();
                builder.append(string);
                if (!iterator.hasNext()) continue;
                builder.append(",");
            }
            String ironKey = "beansbackpacks:iron_backpack";
            if (!this.traits.containsKey(ironKey)) {
                builder.append("\n//\"").append(ironKey).append("\": {").append("\"bundle\":{\"size\":8}").append(",\"equipable\": {\"slots\": \"body\",\"backpack_texture\": \"beansbackpacks:iron\",\"sound_event\": [\"beansbackpacks:metal_equip\", \"beansbackpacks:metal_place\"]}").append(",\"placeable\": {\"backpack_texture\": \"beansbackpacks:iron\"}").append('}');
            }
            if (!this.traits.containsKey(legKey = "minecraft:leggings")) {
                builder.append("\n//\"").append(legKey).append("\" : {").append("\"bundle\": {\"size\": 2,\"sound\": \"soft\"}").append(",\"equipable\": {\"slots\": \"legs\"}").append('}');
            }
            if (!this.traits.containsKey(bucketKey = "beansbackpacks:netherite_bucket")) {
                builder.append("\n//\"").append(bucketKey).append("\" : {").append("\"bucket\": {\"size\": 8}").append('}');
            }
            if (!this.traits.containsKey(roseKey = "beansbackpacks:rose_boots")) {
                builder.append("\n//\"").append(roseKey).append("\" : {").append("\"equipable\": {\"slots\": \"feet\",\"equipment_model\": {\"leftLeg\": \"beansbackpacks:backpack/rose_boot_left\",\"rightLeg\": \"beansbackpacks:backpack/rose_boot_right\"},\"sound_event\": [\"item.armor.equip_generic\"]}").append(",\"modifiers\": ").append("[{\"type\": \"generic.scale\",\"amount\": 0.10,\"slot\": \"feet\",\"id\": \"rose_boot_step\",\"operation\": \"add_multiplied_base\"}").append(",{\"type\": \"generic.movement_speed\",\"amount\": 0.10,\"slot\": \"feet\",\"id\": \"rose_boot_step\",\"operation\": \"add_multiplied_base\"}").append(",{\"type\": \"generic.step_height\",\"amount\": 0.5,\"slot\": \"feet\",\"id\": \"rose_boot_step\",\"operation\": \"add_value\"}").append("]}");
            }
            builder.append("\n}");
            Path path = Services.PLATFORM.getConfigPath();
            Path resolve = path.resolve(this.getPath() + ".json5");
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            String string = builder.toString();
            Files.writeString(resolve, (CharSequence)string, new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

