/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config;

import com.beansgalaxy.backpacks.data.config.TraitConfig;
import com.beansgalaxy.backpacks.data.config.screen.ConfigRows;
import com.beansgalaxy.backpacks.data.config.screen.ConfigScreen;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class TraitConfigRows
extends ConfigRows {
    private MultiLineParentRow parentRow;

    public TraitConfigRows(ConfigScreen screen, Minecraft minecraft, TraitConfig config) {
        super(screen, minecraft, config);
        this.addEntry((AbstractSelectionList.Entry)new ConfigRows.ConfigDescription((Component)Component.translatable((String)"config.beansbackpacks.traits.description")));
        this.parentRow = new MultiLineParentRow(config.traits);
        this.addEntry((AbstractSelectionList.Entry)this.parentRow);
        this.addEntry((AbstractSelectionList.Entry)new ConfigRows.ConfigLabel((Component)Component.translatable((String)"config.beansbackpacks.traits.new")));
        this.addEntry((AbstractSelectionList.Entry)new NewTraitEntryRow(this.parentRow));
    }

    @Override
    public void resetToDefault() {
        TraitConfig config = (TraitConfig)this.config;
        this.parentRow = new MultiLineParentRow(config.traits);
    }

    @Override
    public void onSave() {
        TraitConfig traitConfig = (TraitConfig)this.config;
        Map<String, JsonObject> map = traitConfig.traits;
        map.clear();
        this.parentRow.map.forEach((name, row) -> {
            String value = "{" + row.editBox.getValue() + "}";
            JsonObject parse = JsonParser.parseString((String)value).getAsJsonObject();
            map.put((String)name, parse);
        });
    }

    public class MultiLineParentRow
    extends ConfigRows.ConfigLabel {
        protected final HashMap<String, MultiLineEntry> map;
        private List<AbstractWidget> widgets;

        public MultiLineParentRow(Map<String, JsonObject> traits) {
            super((Component)Component.literal((String)"multiline_parent"));
            this.map = new HashMap();
            this.widgets = List.of();
            traits.forEach(this::createRow);
            this.reloadMap();
        }

        private void createRow(String name, JsonObject row) {
            MultiLineEditBox editBox = new MultiLineEditBox(((TraitConfigRows)TraitConfigRows.this).minecraft.font, 0, 9, TraitConfigRows.this.getRowWidth(), 72, (Component)Component.literal((String)""), (Component)Component.literal((String)"message"));
            String string = row.toString();
            StringBuilder builder = new StringBuilder(string);
            builder.deleteCharAt(0).deleteCharAt(string.length() - 2);
            editBox.setValue(builder.toString());
            int height = editBox.getInnerHeight() + 9;
            editBox.setHeight(height);
            MultiLineEntry configRow = new MultiLineEntry(name, editBox);
            this.map.put(name, configRow);
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            for (MultiLineEntry value : this.map.values()) {
                value.render(guiGraphics, y, x, mouseX, mouseY, delta);
                y += value.getHeight();
            }
        }

        @Override
        public int getHeight() {
            return this.map.values().stream().mapToInt(MultiLineEntry::getHeight).sum();
        }

        private void reloadMap() {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (MultiLineEntry value : this.map.values()) {
                builder.add((Object[])new AbstractWidget[]{value.editBox, value.confirm_remove, value.deny_remove, value.title});
            }
            this.widgets = builder.build();
        }

        public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (pKeyCode == 258) {
                return true;
            }
            return super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }

        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            boolean fal = false;
            if (fal) {
                int i = TraitConfigRows.this.getRowWidth() / 2;
                int j = TraitConfigRows.this.getX() + TraitConfigRows.this.width / 2;
                int left = j - i;
                int right = j + i;
                if (pMouseX < (double)left || pMouseX > (double)right) {
                    return false;
                }
                for (AbstractWidget child : this.widgets) {
                    int x;
                    if (!child.isActive() || !child.visible) continue;
                    int topPos = child.getY();
                    int height = child.getHeight();
                    int botPos = topPos + height;
                    if (!(pMouseY > (double)topPos) || !(pMouseY < (double)botPos) || !(pMouseX > (double)(x = child.getX())) || !(pMouseX < (double)(x + child.getWidth()))) continue;
                    return child.mouseClicked(pMouseX, pMouseY, pButton);
                }
            }
            return super.mouseClicked(pMouseX, pMouseY, pButton);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return this.widgets;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.widgets;
        }

        public class MultiLineEntry {
            private final String entryName;
            private final MultiLineEditBox editBox;
            private final Button confirm_remove;
            private final Button deny_remove;
            private final Button title;

            public MultiLineEntry(String name, MultiLineEditBox editBox) {
                this.entryName = name;
                this.editBox = editBox;
                final Font font = ((TraitConfigRows)TraitConfigRows.this).minecraft.font;
                final int yesWidth = font.width((FormattedText)CommonComponents.GUI_YES);
                this.confirm_remove = new PlainTextButton(TraitConfigRows.this.getRowRight() - 40, 0, yesWidth, 9, CommonComponents.GUI_YES, button -> {
                    MultiLineParentRow row = MultiLineParentRow.this;
                    row.map.remove(this.entryName);
                    row.reloadMap();
                }, font);
                this.confirm_remove.visible = false;
                final int noWidth = font.width((FormattedText)CommonComponents.GUI_NO);
                this.deny_remove = new PlainTextButton(TraitConfigRows.this.getRowRight() - 40, 0, noWidth, 9, CommonComponents.GUI_NO, button -> {
                    this.title.active = true;
                    this.confirm_remove.visible = false;
                    this.deny_remove.visible = false;
                }, font);
                this.deny_remove.visible = false;
                this.title = new PlainTextButton(0, 0, TraitConfigRows.this.getRowWidth() - yesWidth - noWidth, 9, (Component)Component.literal((String)this.entryName), button -> {
                    this.confirm_remove.visible = true;
                    this.deny_remove.visible = true;
                    Button title = this.title;
                    title.active = false;
                }, font){
                    private final Component removal_title;
                    {
                        super(arg0, arg1, arg2, arg3, arg4, arg5, arg6);
                        this.removal_title = Component.literal((String)MultiLineEntry.this.entryName).withStyle(new ChatFormatting[]{ChatFormatting.STRIKETHROUGH, ChatFormatting.RED});
                    }

                    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                        Component component;
                        if (!this.active) {
                            component = this.removal_title;
                            MutableComponent text = Component.translatable((String)"config.beansbackpacks.traits.remove-trait").withStyle(ChatFormatting.GRAY);
                            int width = font.width((FormattedText)text);
                            pGuiGraphics.drawString(font, (Component)text, TraitConfigRows.this.getRowRight() - yesWidth - noWidth - width - 10, this.getY(), 0xFFFFFF | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
                        } else {
                            component = this.isHovered ? this.removal_title : this.getMessage();
                        }
                        pGuiGraphics.drawString(font, component, this.getX(), this.getY(), 0xFFFFFF | Mth.ceil((float)(this.alpha * 255.0f)) << 24);
                    }
                };
            }

            public void render(GuiGraphics guiGraphics, int y, int x, int mouseX, int mouseY, float delta) {
                this.confirm_remove.setY(y);
                this.deny_remove.setY(y);
                this.title.setY(y);
                int rightPos = TraitConfigRows.this.getRowRight() - this.confirm_remove.getWidth();
                this.confirm_remove.setX(rightPos);
                this.deny_remove.setX(rightPos - this.deny_remove.getWidth() - 4);
                this.title.setX(x + 2);
                this.confirm_remove.render(guiGraphics, mouseX, mouseY, delta);
                this.deny_remove.render(guiGraphics, mouseX, mouseY, delta);
                this.title.render(guiGraphics, mouseX, mouseY, delta);
                this.editBox.setY(y + 11);
                this.editBox.setX(x);
                int height = this.editBox.getInnerHeight() + 9;
                this.editBox.setHeight(height);
                this.editBox.render(guiGraphics, mouseX, mouseY, delta);
            }

            public int getHeight() {
                return this.editBox.getHeight() + 15;
            }
        }
    }

    public class NewTraitEntryRow
    extends ConfigRows.ConfigLabel {
        private final EditBox editBox;
        private final MultiLineParentRow parentRow;

        public NewTraitEntryRow(MultiLineParentRow parentRow) {
            super((Component)Component.literal((String)"new_trait_row"));
            this.editBox = new EditBox(((TraitConfigRows)TraitConfigRows.this).minecraft.font, TraitConfigRows.this.getRowWidth(), 12, (Component)Component.translatable((String)"config.beansbackpacks.traits.new-title"));
            this.editBox.setHint((Component)Component.translatable((String)"config.beansbackpacks.traits.new-box").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
            this.parentRow = parentRow;
        }

        public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
            if (pKeyCode == 257) {
                String name = this.editBox.getValue();
                this.parentRow.createRow(name, new JsonObject());
                this.parentRow.reloadMap();
                this.editBox.setValue("");
            }
            return super.keyPressed(pKeyCode, pScanCode, pModifiers);
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.editBox.setX(TraitConfigRows.this.getRowLeft());
            this.editBox.setY(y);
            this.editBox.render(guiGraphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return List.of(this.editBox);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.editBox);
        }
    }
}

