/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config.options;

import com.beansgalaxy.backpacks.platform.Services;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;

public interface DataFeaturesSource {
    public static final UnaryOperator<Component> PACK_DISPLAY = component -> Component.translatable((String)"pack.nameAndSource", (Object[])new Object[]{component, Component.translatable((String)"pack.source.beansbackpacks")}).withStyle(ChatFormatting.GRAY);
    public static final PackSource DATA_ENABLED = PackSource.create(PACK_DISPLAY, (boolean)true);

    public static Path getPath() {
        return Services.PLATFORM.getConfigDir().resolve("beansbackpacks/features");
    }

    public static void addPacks(Consumer<Pack> addPack) {
        Optional<Path> optional = Services.PLATFORM.getModFeaturesDir();
        optional.ifPresent(path -> DataFeaturesSource.addPacks(addPack, "built-in/", path));
        Path features = DataFeaturesSource.getPath();
        if (!DataFeaturesSource.addPacks(addPack, "feature/", features)) {
            try {
                Files.createDirectories(features, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean addPacks(Consumer<Pack> addPack, String prefix, Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(path);){
            for (Path next : paths) {
                DataFeaturesSource.addPack(addPack, prefix, next);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    private static void addPack(Consumer<Pack> addPack, String prefix, final Path next) {
        Pack.ResourcesSupplier supplier;
        Path name = next.getFileName();
        String id = prefix + String.valueOf(name);
        KnownPack knownPack = new KnownPack("beansbackpacks", id, "0.0");
        PackLocationInfo info = new PackLocationInfo(id, (Component)Component.literal((String)String.valueOf(name)), DATA_ENABLED, Optional.of(knownPack));
        Pack pack = Pack.readMetaAndCreate((PackLocationInfo)info, (Pack.ResourcesSupplier)(supplier = new Pack.ResourcesSupplier(){

            public PackResources openPrimary(PackLocationInfo info) {
                return new PathPackResources(info, next);
            }

            public PackResources openFull(PackLocationInfo info, Pack.Metadata metadata) {
                return new PathPackResources(info, next);
            }
        }), (PackType)PackType.SERVER_DATA, (PackSelectionConfig)new PackSelectionConfig(true, Pack.Position.TOP, false));
        if (pack != null) {
            addPack.accept(pack);
        }
    }
}

