/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config.screen;

import com.beansgalaxy.backpacks.Constants;
import com.beansgalaxy.backpacks.data.config.options.Orientation;
import com.beansgalaxy.backpacks.data.config.screen.ConfigScreen;
import com.beansgalaxy.backpacks.data.config.screen.IConfig;
import com.beansgalaxy.backpacks.data.config.screen.IntButton;
import com.beansgalaxy.backpacks.data.config.screen.MoveElementConfigScreen;
import com.beansgalaxy.backpacks.data.config.types.BoolConfigVariant;
import com.beansgalaxy.backpacks.data.config.types.EnumConfigVariant;
import com.beansgalaxy.backpacks.data.config.types.HSetConfigVariant;
import com.beansgalaxy.backpacks.data.config.types.IntConfigVariant;
import com.beansgalaxy.backpacks.data.config.types.ListConfigVariant;
import com.beansgalaxy.backpacks.data.config.types.MapConfigVariant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.function.TriConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigRows
extends ContainerObjectSelectionList<ConfigLabel> {
    public final IConfig config;
    protected ConfigScreen screen;

    public ConfigRows(ConfigScreen screen, Minecraft minecraft, IConfig config) {
        super(minecraft, minecraft.getWindow().getGuiScaledWidth(), minecraft.getWindow().getGuiScaledHeight() - 70, 36, 25);
        this.screen = screen;
        this.config = config;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int i) {
        ConfigLabel focused = (ConfigLabel)this.getFocused();
        if (focused != null) {
            focused.hungryClick(mouseX, mouseY, i);
        }
        return super.mouseClicked(mouseX, mouseY, i);
    }

    public abstract void resetToDefault();

    public abstract void onSave();

    protected int getMaxPosition() {
        return this.children().stream().mapToInt(ConfigLabel::getHeight).sum() + this.headerHeight;
    }

    @Nullable
    protected ConfigLabel getEntryAtPosition(double pMouseX, double pMouseY) {
        int i = this.getRowWidth() / 2;
        int j = this.getX() + this.width / 2;
        int left = j - i;
        int right = j + i;
        if (pMouseX < (double)left || pMouseX > (double)right) {
            return null;
        }
        double amount = this.getScrollAmount();
        int topPos = this.getY() + this.headerHeight - (int)amount;
        for (ConfigLabel child : this.children()) {
            int height = child.getHeight();
            int botPos = topPos + height;
            if (pMouseY > (double)topPos && pMouseY < (double)botPos) {
                return child;
            }
            topPos += height;
        }
        return null;
    }

    protected void renderListItems(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int leftPos = this.getRowLeft();
        int j = this.getRowWidth();
        int l = this.getItemCount();
        for (int index = 0; index < l; ++index) {
            int topPos = this.getRowTop(index);
            ConfigLabel configLabel = (ConfigLabel)((Object)this.children().get(index));
            int height = configLabel.getHeight();
            int k1 = height + topPos;
            if (k1 < this.getY() || topPos > this.getBottom()) continue;
            this.renderItem(pGuiGraphics, pMouseX, pMouseY, pPartialTick, index, leftPos, topPos, j, height);
        }
    }

    protected int getRowTop(int pIndex) {
        int i = 0;
        int height = this.headerHeight - (int)this.getScrollAmount() + this.getY() + 4;
        for (ConfigLabel child : this.children()) {
            if (i == pIndex) {
                return height;
            }
            height += child.getHeight();
            ++i;
        }
        return height;
    }

    protected int getRowBottom(int pIndex) {
        return this.getRowTop(pIndex) + ((ConfigLabel)((Object)this.children().get(pIndex))).getHeight();
    }

    public class ConfigLabel
    extends ContainerObjectSelectionList.Entry<ConfigLabel> {
        public final Component name;

        public ConfigLabel(Component name) {
            this.name = name;
        }

        public void resetToDefault() {
        }

        public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            guiGraphics.drawCenteredString(((ConfigRows)ConfigRows.this).minecraft.font, this.name, x + rowWidth / 2, y + 8, -1);
            guiGraphics.hLine(x + 30, x + rowWidth - 30, y + 18, -1);
        }

        public List<? extends GuiEventListener> children() {
            return List.of();
        }

        public List<? extends NarratableEntry> narratables() {
            return List.of();
        }

        public void hungryClick(double mouseX, double mouseY, int i) {
        }

        public void onSave() {
        }

        public int getHeight() {
            return ConfigRows.this.itemHeight;
        }
    }

    public class IntMapConfigRow<K>
    extends ConfigLabel {
        private final MapConfigVariant<K, Integer> value;
        private final EditBox keyBox;
        private final IntButton intButton;
        private final Button add;
        private final Button expand;
        private boolean expanded;
        private float lastDelta;
        private int scrollText;
        private HoveredEntry hoveredEntry;

        public IntMapConfigRow(MapConfigVariant<K, Integer> value) {
            super((Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + value.name()), (String)value.name()));
            this.expanded = false;
            this.lastDelta = 0.0f;
            this.scrollText = -80;
            this.hoveredEntry = null;
            this.value = value;
            int x = ConfigRows.this.getRowLeft();
            this.expand = Button.builder((Component)Component.literal((String)">"), this::toggleExpanded).bounds(x - 1, 0, 20, 20).build();
            this.keyBox = new EditBox(((ConfigRows)ConfigRows.this).minecraft.font, x + 43, 0, ConfigRows.this.getRowWidth() - 40 - 47, 20, (Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + value.name()), (String)value.name()));
            this.keyBox.setHint((Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + value.name()), (String)value.name()).withStyle(ChatFormatting.GRAY));
            this.intButton = IntButton.builder(in -> {}, null).bounds(x + ConfigRows.this.getRowWidth() - 40, 0, 40, 20).build();
            this.add = Button.builder((Component)Component.literal((String)"+"), in -> {
                String key = this.keyBox.getValue();
                int entry = this.intButton.storedValue;
                if (!Constants.isEmpty(key) && value.validate.test(key, entry)) {
                    value.put(key, (Integer)value.clamp.apply(entry));
                }
            }).bounds(x + 20, 0, 20, 20).build();
        }

        private void toggleExpanded(Button in) {
            boolean bl = this.expanded = !this.expanded;
            if (this.expanded) {
                in.setMessage((Component)Component.literal((String)"<"));
            } else {
                in.setMessage((Component)Component.literal((String)">"));
            }
        }

        @Override
        public void hungryClick(double mouseX, double mouseY, int i) {
            if (i == 0 && this.hoveredEntry != null && mouseX < (double)ConfigRows.this.getRowLeft() && (double)(this.hoveredEntry.y - 2) < mouseY && (double)(this.hoveredEntry.y + 8) > mouseY) {
                ((HashMap)this.value.get()).remove(this.hoveredEntry.key);
            }
            super.hungryClick(mouseX, mouseY, i);
        }

        @Override
        public void resetToDefault() {
            this.value.set(new HashMap((Map)this.value.defau()));
        }

        @Override
        public void render(GuiGraphics gui, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.keyBox.setY(y);
            this.keyBox.render(gui, mouseX, mouseY, delta);
            this.intButton.setY(y);
            this.intButton.render(gui, mouseX, mouseY, delta);
            this.add.setY(y);
            this.add.render(gui, mouseX, mouseY, delta);
            this.expand.setY(y);
            this.expand.render(gui, mouseX, mouseY, delta);
            if (!this.isFocused()) {
                this.keyBox.setValue("");
            }
            if (this.expanded) {
                if (!this.isFocused()) {
                    this.toggleExpanded(this.expand);
                } else {
                    this.renderSideMenu(gui, x, mouseX, mouseY, delta);
                }
            }
        }

        private void renderSideMenu(GuiGraphics gui, int x, int mouseX, int mouseY, float delta) {
            int i = 0;
            this.hoveredEntry = null;
            gui.enableScissor(10, 0, x - 1, ConfigRows.this.screen.height);
            for (String key : ((HashMap)this.value.get()).keySet()) {
                Integer entry = (Integer)((HashMap)this.value.get()).get(key);
                MutableComponent line = Component.literal((String)(key + ": " + entry));
                int lineX = 10;
                int lineY = 60 + 10 * i;
                if (mouseX < x - 10 && lineY - 2 < mouseY && lineY + 8 > mouseY) {
                    line.withStyle(ChatFormatting.RED);
                    this.hoveredEntry = new HoveredEntry(key, lineY);
                    int width = ((ConfigRows)ConfigRows.this).minecraft.font.width((FormattedText)line);
                    if (width > x) {
                        if (this.lastDelta > delta) {
                            ++this.scrollText;
                        }
                        lineX = 10 - Mth.clamp((int)this.scrollText, (int)0, (int)(width - x + 14));
                        if (this.scrollText > width) {
                            this.scrollText = -80;
                        }
                    } else {
                        this.scrollText = -20;
                    }
                }
                gui.drawString(((ConfigRows)ConfigRows.this).minecraft.font, (Component)line, lineX, lineY, -1);
                ++i;
            }
            gui.disableScissor();
            if (this.hoveredEntry != null) {
                gui.drawString(((ConfigRows)ConfigRows.this).minecraft.font, (Component)Component.literal((String)"\u00e2\u0153\u02dc").withStyle(ChatFormatting.RED), 3, this.hoveredEntry.y + 1, 0xFFFFFF);
            }
            this.lastDelta = delta;
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return List.of(this.keyBox, this.intButton, this.add, this.expand);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.keyBox, this.intButton, this.add, this.expand);
        }

        public record HoveredEntry(String key, int y) {
        }
    }

    public class MoveBackSlotConfigRow
    extends ConfigLabel {
        private final ListConfigVariant<Integer> value;
        private final Button button;

        public MoveBackSlotConfigRow(ListConfigVariant<Integer> value, EnumConfigVariant<Orientation> orientation) {
            super((Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + value.name()), (String)value.name()));
            this.value = value;
            this.button = Button.builder((Component)Component.translatable((String)"screen.beansbackpacks.config.back_slot_pos.edit"), in -> {
                MoveElementConfigScreen screen = MoveElementConfigScreen.Builder.create().background(InventoryScreen.INVENTORY_LOCATION).backgroundSize(176, 166).elementSize(16, 16).elementPos((Integer)value.get(0), (Integer)value.get(1)).childSlots(2).orientation((Orientation)((Object)((Object)orientation.get()))).onSave((TriConsumer<Integer, Integer, Orientation>)((TriConsumer)(x, y, o) -> {
                    ((ArrayList)value.get()).set(0, x);
                    ((ArrayList)value.get()).set(1, y);
                    orientation.set((Orientation)((Object)o));
                })).build(ConfigRows.this.screen);
                ConfigRows.this.minecraft.setScreen((Screen)screen);
            }).bounds(0, 0, 70, 20).build();
        }

        @Override
        public void resetToDefault() {
            this.value.set(new ArrayList((Collection)this.value.defau()));
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            guiGraphics.drawString(((ConfigRows)ConfigRows.this).minecraft.font, this.value.name(), x, y + 6, -1);
            this.button.setX(x + rowWidth - this.button.getWidth());
            this.button.setY(y);
            this.button.render(guiGraphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return List.of(this.button);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.button);
        }
    }

    public class ItemListConfigRow
    extends ConfigLabel {
        private final HSetConfigVariant<Item> value;
        private final EditBox searchBox;
        private SearchTree<Item> searchTree;
        private List<Item> searchResults;
        private HoveredItem hoveredStoredItem;
        private HoveredItem hoveredSearchItem;

        public ItemListConfigRow(HSetConfigVariant<Item> value) {
            super((Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + value.name()), (String)value.name()));
            this.searchTree = new SearchTree<Item>(){

                @NotNull
                public List<Item> search(@NotNull String s) {
                    Set itemIDs = BuiltInRegistries.ITEM.keySet();
                    ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(itemIDs.stream().filter(in -> in.toString().contains(s)).toList());
                    if (s.contains(":")) {
                        list.sort(Comparator.comparingInt(x -> {
                            String key = x.toString();
                            return key.compareTo(s);
                        }));
                    } else {
                        list.sort(Comparator.comparingInt(x -> {
                            String key = x.getPath();
                            int i = Math.abs(key.compareTo(s));
                            return i;
                        }));
                    }
                    ArrayList<Item> itemList = new ArrayList<Item>(list.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).toList());
                    itemList.removeAll((Collection)ItemListConfigRow.this.value.get());
                    return itemList;
                }
            };
            this.searchResults = List.of();
            this.hoveredStoredItem = null;
            this.hoveredSearchItem = null;
            this.value = value;
            this.searchBox = new EditBox(((ConfigRows)ConfigRows.this).minecraft.font, 0, 0, 120, 20, (Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + value.name()), (String)value.name()));
            this.searchBox.setHint((Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + value.name()), (String)value.name()).withStyle(ChatFormatting.GRAY));
        }

        @Override
        public void resetToDefault() {
            this.value.set((HashSet)this.value.defau());
        }

        public boolean keyPressed(int i, int $$1, int $$2) {
            boolean b = super.keyPressed(i, $$1, $$2);
            this.searchResults = this.getSearchResults();
            return b;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int i) {
            if (i == 0 && this.hoveredStoredItem != null) {
                ((HashSet)this.value.get()).remove(this.hoveredStoredItem.item);
            }
            this.searchResults = this.getSearchResults();
            return super.mouseClicked(mouseX, mouseY, i);
        }

        @Override
        public void hungryClick(double mouseX, double mouseY, int i) {
            if (i == 0 && this.hoveredSearchItem != null) {
                ((HashSet)this.value.get()).add(this.hoveredSearchItem.item);
                this.searchResults = this.getSearchResults();
            }
        }

        @Override
        public void render(GuiGraphics gui, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            this.searchBox.setX(x);
            this.searchBox.setY(y);
            this.searchBox.render(gui, mouseX, mouseY, delta);
            if (!this.searchBox.isFocused()) {
                this.searchBox.setValue("");
            } else if (!this.searchResults.isEmpty()) {
                double slotX = x - mouseX;
                double slotY = mouseY - y + 2;
                boolean checkHovering = slotX > 0.0 && slotY > 0.0;
                gui.pose().pushPose();
                gui.pose().translate((float)(x - 10), (float)(y - 2), 0.0f);
                gui.pose().scale(0.5f, 0.5f, 0.5f);
                this.hoveredSearchItem = null;
                for (int i = 0; i < this.searchResults.size() && i < 36; ++i) {
                    Item next = this.searchResults.get(i);
                    int entriesX = i / 3;
                    int entriesY = i % 3;
                    gui.renderItem(next.getDefaultInstance(), -entriesX * 16, entriesY * 16);
                    if (!checkHovering || Mth.floor((double)slotX) / 8 != entriesX || Mth.floor((double)slotY) / 8 != entriesY) continue;
                    this.hoveredSearchItem = new HoveredItem(next, entriesX, entriesY);
                }
                gui.pose().popPose();
                if (this.hoveredSearchItem != null) {
                    gui.pose().pushPose();
                    gui.pose().translate(0.0f, 0.0f, 300.0f);
                    gui.drawString(((ConfigRows)ConfigRows.this).minecraft.font, "o", x - this.hoveredSearchItem.x * 8 - 9, y - 2 + this.hoveredSearchItem.y * 8, -8917385);
                    gui.pose().popPose();
                }
            }
            this.renderStoredItems(gui, y, x, mouseX, mouseY);
        }

        private void renderStoredItems(GuiGraphics gui, int y, int x, int mouseX, int mouseY) {
            int x1 = x + this.searchBox.getWidth() + 2;
            double slotX = mouseX - x1;
            double slotY = mouseY - y + 2;
            boolean checkHovering = slotX > 0.0 && slotY > 0.0;
            Iterator iterator = ((HashSet)this.value.get()).iterator();
            gui.pose().pushPose();
            gui.pose().translate((float)x1, (float)(y - 2), 0.0f);
            gui.pose().scale(0.5f, 0.5f, 0.5f);
            this.hoveredStoredItem = null;
            for (int i = 0; iterator.hasNext() && i < 38; ++i) {
                Item next = (Item)iterator.next();
                int entriesX = i / 3;
                int entriesY = i % 3;
                gui.renderItem(next.getDefaultInstance(), entriesX * 16, entriesY * 16);
                if (!checkHovering || Mth.floor((double)slotX) / 8 != entriesX || Mth.floor((double)slotY) / 8 != entriesY) continue;
                this.hoveredStoredItem = new HoveredItem(next, entriesX, entriesY);
            }
            gui.pose().popPose();
            int size = ((HashSet)this.value.get()).size();
            if (size > 38) {
                gui.drawString(((ConfigRows)ConfigRows.this).minecraft.font, (Component)Component.literal((String)("+" + (size - 38))), x1 + 96, y - 2 + 16, -1);
            }
            if (this.hoveredStoredItem != null) {
                gui.pose().pushPose();
                gui.pose().translate(0.0f, 0.0f, 300.0f);
                gui.drawString(((ConfigRows)ConfigRows.this).minecraft.font, "x", x1 + 1 + this.hoveredStoredItem.x * 8, y - 2 + this.hoveredStoredItem.y * 8, -21846);
                gui.pose().popPose();
            }
        }

        private List<Item> getSearchResults() {
            String search = this.searchBox.getValue();
            if (search.isEmpty()) {
                return List.of();
            }
            return this.searchTree.search(search.toLowerCase(Locale.ROOT));
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return List.of(this.searchBox);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.searchBox);
        }

        private record HoveredItem(Item item, int x, int y) {
        }
    }

    public class IntConfigRow
    extends ConfigLabel {
        private final IntConfigVariant value;
        private final IntButton button;

        public IntConfigRow(IntConfigVariant value) {
            super((Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + value.name()), (String)value.name()));
            this.value = value;
            this.button = IntButton.builder(in -> {}, value::get).onEnter(in -> value.set(Mth.clamp((int)in, (int)value.min, (int)value.max))).onClose(in -> this.close()).bounds(0, 0, 70, 20).build();
        }

        @Override
        public void resetToDefault() {
            this.value.set((Integer)this.value.defau());
        }

        private void close() {
            ConfigRows.this.setFocused(null);
            this.button.setFocused(false);
            this.setFocused(false);
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            guiGraphics.drawString(((ConfigRows)ConfigRows.this).minecraft.font, this.value.name(), x, y + 6, -1);
            this.button.setX(x + rowWidth - this.button.getWidth());
            this.button.setY(y);
            this.button.render(guiGraphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return List.of(this.button);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.button);
        }
    }

    public static class EnumConfigRow<T extends Enum<T>>
    extends ConfigLabel {
        private final EnumConfigVariant<T> value;
        private final T[] values;
        private final Button button;
        final /* synthetic */ ConfigRows this$0;

        public EnumConfigRow(EnumConfigVariant<T> value, T[] values) {
            this.this$0 = this$0;
            super((Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + value.name()), (String)value.name()));
            this.value = value;
            this.values = values;
            this.button = Button.builder((Component)this.getTranslatedValue((Enum)value.get()), in -> value.set(this.getNextValue())).bounds(0, 0, 70, 20).build();
        }

        private T getNextValue() {
            Iterator iterator = Arrays.stream(this.values).iterator();
            Enum t = (Enum)this.value.get();
            while (iterator.hasNext()) {
                if (!t.equals(iterator.next())) continue;
                if (iterator.hasNext()) {
                    return (T)((Enum)iterator.next());
                }
                return this.values[0];
            }
            return (T)t;
        }

        @Override
        public void resetToDefault() {
            this.value.set((Enum)this.value.defau());
        }

        Component getTranslatedValue(T value) {
            return Component.translatableWithFallback((String)("screen.beansbackpacks.config.enum." + ((Enum)value).name()), (String)((Enum)value).name());
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            guiGraphics.drawString(((ConfigRows)this.this$0).minecraft.font, this.value.name(), x, y + 6, -1);
            this.button.setMessage(this.getTranslatedValue((Enum)this.value.get()));
            this.button.setX(x + rowWidth - this.button.getWidth());
            this.button.setY(y);
            this.button.render(guiGraphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return List.of(this.button);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.button);
        }
    }

    public class BoolConfigRow
    extends ConfigLabel {
        private final BoolConfigVariant bool;
        private final Button button;

        public BoolConfigRow(BoolConfigVariant bool) {
            super((Component)Component.translatableWithFallback((String)("screen.beansbackpacks.config." + bool.name()), (String)bool.name()));
            this.bool = bool;
            this.button = Button.builder((Component)BoolConfigRow.getTranslatedValue((Boolean)bool.get()), in -> bool.set((Boolean)bool.get() == false)).bounds(0, 0, 70, 20).build();
        }

        @Override
        public void resetToDefault() {
            this.bool.set((Boolean)this.bool.defau());
        }

        static Component getTranslatedValue(boolean value) {
            return value ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            guiGraphics.drawString(((ConfigRows)ConfigRows.this).minecraft.font, this.bool.name(), x, y + 6, -1);
            this.button.setMessage(BoolConfigRow.getTranslatedValue((Boolean)this.bool.get()));
            this.button.setX(x + rowWidth - this.button.getWidth());
            this.button.setY(y);
            this.button.render(guiGraphics, mouseX, mouseY, delta);
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return List.of(this.button);
        }

        @Override
        public List<? extends NarratableEntry> narratables() {
            return List.of(this.button);
        }
    }

    public class ConfigDescription
    extends ConfigLabel {
        int height;

        public ConfigDescription(Component name) {
            super(name);
            this.height = 0;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int index, int y, int x, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            int center = x + rowWidth / 2 - 6;
            Font font = ((ConfigRows)ConfigRows.this).minecraft.font;
            Language language = Language.getInstance();
            StringSplitter splitter = font.getSplitter();
            List texts = splitter.splitLines((FormattedText)this.name, rowWidth + 12, Style.EMPTY.withColor(ChatFormatting.GRAY));
            int yO = 0;
            for (FormattedText text : texts) {
                FormattedCharSequence ordered = language.getVisualOrder(text);
                int width = font.width(text);
                int leftPos = center - width / 2;
                guiGraphics.drawString(font, ordered, leftPos, y + yO, -1);
                yO += 9;
            }
            this.height = yO;
        }

        @Override
        public int getHeight() {
            return this.height + 6;
        }
    }
}

