/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config.screen;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.data.ServerSave;
import com.beansgalaxy.backpacks.data.config.ClientConfig;
import com.beansgalaxy.backpacks.data.config.ClientConfigRows;
import com.beansgalaxy.backpacks.data.config.CommonConfig;
import com.beansgalaxy.backpacks.data.config.CommonConfigRows;
import com.beansgalaxy.backpacks.data.config.TraitConfig;
import com.beansgalaxy.backpacks.data.config.TraitConfigRows;
import com.beansgalaxy.backpacks.data.config.screen.ConfigRows;
import com.beansgalaxy.backpacks.data.config.screen.IConfig;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ConfigScreen
extends Screen {
    private final Map<IConfig, Function<ConfigScreen, ConfigRows>> pageConstructor;
    private final Screen lastScreen;
    private final IConfig[] pages;
    private ConfigRows[] rows;
    private ConfigRows currentPage;

    public ConfigScreen(Screen lastScreen, Map<IConfig, Function<ConfigScreen, ConfigRows>> pageConstructor) {
        super((Component)Component.empty());
        this.pageConstructor = pageConstructor;
        this.lastScreen = lastScreen;
        for (IConfig page : this.pages = pageConstructor.keySet().toArray(new IConfig[0])) {
            page.read();
        }
    }

    public static void buildPageMap(Minecraft minecraft, ImmutableMap.Builder<IConfig, Function<ConfigScreen, ConfigRows>> map) {
        CommonConfig common = new CommonConfig();
        map.put((Object)common, configScreen -> new CommonConfigRows((ConfigScreen)((Object)configScreen), minecraft, common));
        ClientConfig client = CommonClass.CLIENT_CONFIG;
        map.put((Object)client, configScreen -> new ClientConfigRows((ConfigScreen)((Object)configScreen), minecraft, client));
        TraitConfig traits = new TraitConfig();
        map.put((Object)traits, configScreen -> new TraitConfigRows((ConfigScreen)((Object)configScreen), minecraft, traits));
    }

    public List<? extends GuiEventListener> children() {
        List<GuiEventListener> children = super.children().stream().filter(in -> in == this.currentPage || !(in instanceof ConfigRows)).toList();
        return children;
    }

    protected void init() {
        super.init();
        ArrayList<ConfigRows> rows = new ArrayList<ConfigRows>();
        ArrayList<PageTab> tabs = new ArrayList<PageTab>();
        int totalWidth = -20;
        for (IConfig page : this.pages) {
            ConfigRows row = this.pageConstructor.get(page).apply(this);
            rows.add(row);
            String path = row.config.getPath();
            MutableComponent title = Component.translatableWithFallback((String)("screen.beansbackpacks.config.title-" + path), (String)path);
            int titleWidth = this.minecraft.font.width((FormattedText)title);
            totalWidth += 20 + titleWidth;
            tabs.add(new PageTab(row, (Component)title, titleWidth));
        }
        this.rows = (ConfigRows[])rows.toArray(ConfigRows[]::new);
        ServerSave.CONFIG.read(false);
        this.currentPage = this.rows[0];
        this.addWidgets();
        int x = (this.width - totalWidth) / 2;
        for (final PageTab tab : tabs) {
            this.addWidget((GuiEventListener)tab.row);
            this.addRenderableWidget((GuiEventListener)new PlainTextButton(x, 20, tab.width, 20, tab.title, in -> {
                this.currentPage = tab.row;
            }, this.minecraft.font){

                public boolean isFocused() {
                    return ConfigScreen.this.currentPage == tab.row;
                }
            });
            x += tab.width + 20;
        }
    }

    private void addWidgets() {
        int center = this.width / 2;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.beansbackpacks.config.main.reset_all"), $$0 -> this.currentPage.resetToDefault()).bounds(center - 165, this.height - 26, 70, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.beansbackpacks.config.main.undo_all"), $$0 -> {
            for (IConfig page : this.pages) {
                page.read(false);
            }
        }).bounds(center - 80, this.height - 26, 70, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.beansbackpacks.config.main.save_and_exit"), $$0 -> {
            for (ConfigRows row : this.rows) {
                row.onSave();
                row.config.write();
            }
            this.minecraft.setScreen(this.lastScreen);
        }).bounds(center + 5, this.height - 26, 160, 20).build());
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public void render(GuiGraphics gui, int x, int y, float delta) {
        super.render(gui, x, y, delta);
        MutableComponent title = Component.literal((String)"Beans' Backpacks").withStyle(ChatFormatting.BOLD);
        gui.drawCenteredString(this.font, (Component)title, this.minecraft.getWindow().getGuiScaledWidth() / 2, 6, -3351041);
        if (this.currentPage != null) {
            this.currentPage.render(gui, x, y, delta);
        }
    }

    private record PageTab(ConfigRows row, Component title, int width) {
    }
}

