/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config.screen;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class IntButton
extends Button {
    private final Consumer<Integer> onClose;
    private final Consumer<Integer> onEnter;
    private final Supplier<Integer> getValue;
    public int storedValue = 0;
    private boolean isFirstEdit = true;

    protected IntButton(int x, int y, int w, int h, Button.OnPress onPress, Consumer<Integer> onClose, Consumer<Integer> onEnter, Supplier<Integer> getValue, Button.CreateNarration narration) {
        super(x, y, w, h, (Component)Component.empty(), onPress, narration);
        this.onClose = onClose;
        this.onEnter = onEnter;
        this.getValue = getValue == null ? () -> this.storedValue : getValue;
    }

    public static Builder builder(Button.OnPress onPress, @Nullable Supplier<Integer> getValue) {
        return new Builder(onPress, getValue);
    }

    public void onPress() {
        this.isFirstEdit = true;
        super.onPress();
    }

    public boolean keyPressed(int i, int j, int k) {
        switch (i) {
            case 259: {
                if (this.storedValue == 0) {
                    this.close();
                }
                this.storedValue /= 10;
                break;
            }
            case 45: {
                this.storedValue *= -1;
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                if (this.storedValue >= 1000000 || this.storedValue <= -1000000) break;
                int n = i - 48;
                this.storedValue = this.storedValue * 10 + n;
                break;
            }
            case 257: {
                if (!this.isFirstEdit) {
                    this.onEnter.accept(this.storedValue);
                }
                this.close();
            }
        }
        this.isFirstEdit = false;
        return super.keyPressed(i, j, k);
    }

    private void close() {
        this.onClose.accept(this.storedValue);
        this.setFocused(false);
    }

    public Component getMessage() {
        return this.isFocused() ? Component.literal((String)("[" + (this.isFirstEdit ? this.getValue.get() : this.storedValue) + "]")) : Component.literal((String)String.valueOf(this.getValue.get()));
    }

    static /* synthetic */ Button.CreateNarration access$000() {
        return DEFAULT_NARRATION;
    }

    public static class Builder {
        private final Button.OnPress onPress;
        private final Supplier<Integer> getValue;
        private Consumer<Integer> onClose = in -> {};
        private Consumer<Integer> onEnter = in -> {};
        private Button.CreateNarration narration = IntButton.access$000();
        private int x = 0;
        private int y = 0;
        private int w = 0;
        private int h = 0;

        private Builder(Button.OnPress onPress, Supplier<Integer> getValue) {
            this.onPress = onPress;
            this.getValue = getValue;
        }

        public Builder bounds(int x, int y, int w, int h) {
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            return this;
        }

        public Builder onClose(Consumer<Integer> onClose) {
            this.onClose = onClose;
            return this;
        }

        public Builder onEnter(Consumer<Integer> onEnter) {
            this.onEnter = onEnter;
            return this;
        }

        public IntButton build() {
            return new IntButton(this.x, this.y, this.w, this.h, this.onPress, this.onClose, this.onEnter, this.getValue, this.narration);
        }
    }
}

