/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config.screen;

import com.beansgalaxy.backpacks.data.config.options.Orientation;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.function.TriConsumer;

public class MoveElementConfigScreen
extends Screen {
    private final ResourceLocation background;
    private final Screen lastScreen;
    private final int bgU;
    private final int bgV;
    private final int bgWidth;
    private final int bgHeight;
    private final TriConsumer<Integer, Integer, Orientation> onSave;
    private final int elementW;
    private final int elementH;
    private int elementX;
    private int elementY;
    private int topPos;
    private int leftPos;
    private final int childSlots;
    private Orientation orientation;

    public MoveElementConfigScreen(Screen lastScreen, ResourceLocation background, TriConsumer<Integer, Integer, Orientation> onSave, int elementX, int elementY, int elementW, int elementH, int bgWidth, int bgHeight, int bgU, int bgV, int childSlots, Orientation orientation) {
        super((Component)Component.empty());
        this.lastScreen = lastScreen;
        this.background = background;
        this.bgU = bgU;
        this.bgV = bgV;
        this.onSave = onSave;
        this.elementW = elementW;
        this.elementH = elementH;
        this.bgWidth = bgWidth;
        this.bgHeight = bgHeight;
        this.elementX = elementX;
        this.elementY = elementY;
        this.childSlots = childSlots;
        this.orientation = orientation;
    }

    public boolean mouseDragged(double x1, double y1, int i, double x2, double y2) {
        Optional childAt = this.getChildAt(x1, y1);
        if (childAt.isEmpty() && i == 0) {
            this.elementX = (int)(x1 - (double)this.leftPos) - this.elementW / 2;
            this.elementY = (int)(y1 - (double)this.topPos) - this.elementH / 2;
        }
        return super.mouseDragged(x1, y1, i, x2, y2);
    }

    protected void init() {
        super.init();
        this.leftPos = (int)((double)this.bgWidth / -2.0 + (double)this.width / 2.0);
        this.topPos = (int)((double)this.bgHeight / -4.0 + (double)this.height / 4.0);
        int center = this.width / 2;
        Button save = Button.builder((Component)Component.translatable((String)"screen.beansbackpacks.move_element.save_and_close"), in -> {
            this.onSave.accept((Object)this.elementX, (Object)this.elementY, (Object)this.orientation);
            this.onClose();
        }).bounds(center + 5, this.height - 26, 80, 20).build();
        Button exit = Button.builder((Component)Component.translatable((String)"screen.beansbackpacks.move_element.cancel_and_exit"), in -> this.onClose()).bounds(center - 85, this.height - 26, 80, 20).build();
        Button rotate = Button.builder((Component)Component.translatable((String)"screen.beansbackpacks.move_element.rotate"), in -> {
            Orientation lastValue = Orientation.Right;
            for (Orientation value : Orientation.values()) {
                if (value == this.orientation) {
                    this.orientation = lastValue;
                    return;
                }
                lastValue = value;
            }
        }).bounds(center + 95, this.height - 26, 20, 20).build();
        this.addRenderableWidget((GuiEventListener)save);
        this.addRenderableWidget((GuiEventListener)exit);
        this.addRenderableWidget((GuiEventListener)rotate);
    }

    public void onClose() {
        this.minecraft.setScreen(this.lastScreen);
    }

    public void render(GuiGraphics gui, int x, int y, float delta) {
        super.renderBackground(gui, x, y, delta);
        int eleX = this.leftPos + this.elementX;
        int eleY = this.topPos + this.elementY;
        gui.fill(eleX, eleY, this.elementW + eleX, this.elementH + eleY, 300, -1166541);
        boolean positive = this.orientation.isPositive();
        for (int i = 0; i < this.childSlots; ++i) {
            int chiX;
            int chiY;
            if (this.orientation.isVertical()) {
                mod = (this.elementH + 2) * (i + 1);
                chiY = positive ? eleY + mod : eleY - mod;
                chiX = eleX;
            } else {
                chiY = eleY;
                mod = (this.elementW + 2) * (i + 1);
                chiX = positive ? eleX + mod : eleX - mod;
            }
            gui.fill(chiX, chiY, this.elementW + chiX, this.elementH + chiY, 300, -2241485);
        }
        gui.blit(this.background, this.leftPos, this.topPos, this.bgU, this.bgV, this.bgWidth, this.bgHeight);
        super.render(gui, x, y, delta);
    }

    public static class Builder {
        private TriConsumer<Integer, Integer, Orientation> onSave = (x, y, o) -> {};
        private ResourceLocation background = null;
        private int elementX = 0;
        private int elementY = 0;
        private int elementW = 1;
        private int elementH = 1;
        private int bgW = 0;
        private int bgH = 0;
        private int bgU = 0;
        private int bgV = 0;
        private int childSlots = 0;
        private Orientation orientation;

        public static Builder create() {
            return new Builder();
        }

        public Builder elementPos(int x, int y) {
            this.elementX = x;
            this.elementY = y;
            return this;
        }

        public Builder elementSize(int width, int height) {
            this.elementW = width;
            this.elementH = height;
            return this;
        }

        public Builder backgroundSize(int width, int height) {
            this.bgW = width;
            this.bgH = height;
            return this;
        }

        public Builder backgroundUV(int x, int y) {
            this.bgU = x;
            this.bgV = y;
            return this;
        }

        public Builder childSlots(int size) {
            this.childSlots = size;
            return this;
        }

        public Builder background(ResourceLocation background) {
            this.background = background;
            return this;
        }

        public Builder onSave(TriConsumer<Integer, Integer, Orientation> onClose) {
            this.onSave = onClose;
            return this;
        }

        public MoveElementConfigScreen build(Screen lastScreen) {
            return new MoveElementConfigScreen(lastScreen, this.background, this.onSave, this.elementX, this.elementY, this.elementW, this.elementH, this.bgW, this.bgH, this.bgU, this.bgV, this.childSlots, this.orientation);
        }

        public Builder orientation(Orientation orientation) {
            this.orientation = orientation;
            return this;
        }
    }
}

