/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.data.config.types;

import com.beansgalaxy.backpacks.data.config.types.ConfigVariant;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.util.GsonHelper;

public class EnumConfigVariant<T extends Enum<T>>
extends ConfigVariant<T> {
    private final T[] values;

    public EnumConfigVariant(String name, T defau, T[] values) {
        super(name, defau, "");
        this.values = values;
    }

    public EnumConfigVariant(String name, T defau, T[] values, String comment) {
        super(name, defau, comment);
        this.values = values;
    }

    @Override
    public String autoComment() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = Arrays.stream(this.values).iterator();
        while (iterator.hasNext()) {
            Enum next = (Enum)iterator.next();
            sb.append(next);
            if (next == this.defau()) {
                sb.append(" (Default)");
            }
            if (!iterator.hasNext()) continue;
            sb.append(" : ");
        }
        return sb.toString();
    }

    @Override
    public String encode() {
        return this.toString() + "\"" + ((Enum)this.value).name() + "\"";
    }

    @Override
    public void decode(JsonObject jsonObject) {
        if (!jsonObject.has(this.name)) {
            return;
        }
        String string = GsonHelper.getAsString((JsonObject)jsonObject, (String)this.name);
        for (T value : this.values) {
            if (!((Enum)value).name().equals(string)) continue;
            this.value = value;
        }
    }
}

