/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.items;

import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.Traits;
import com.google.common.collect.Lists;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.math.Fraction;

public abstract class AbstractBurlapSackEntity
extends BlockEntity
implements Container {
    protected static final Component NAME = Component.literal((String)"Burlap Sack");
    private List<ItemStack> stacks = Lists.newArrayList();

    public AbstractBurlapSackEntity(BlockPos pPos, BlockState pBlockState) {
        super(Services.PLATFORM.getBurlapSackEntityType(), pPos, pBlockState);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        DataResult result = Traits.STACKS_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.stacks);
        result.ifSuccess(tag -> pTag.put("stacks", tag));
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        DataResult result = Traits.STACKS_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)pTag.get("stacks"));
        result.ifSuccess(stacks -> {
            this.stacks.clear();
            this.stacks.addAll((Collection<ItemStack>)stacks);
        });
    }

    public abstract void openMenu(Player var1);

    public List<ItemStack> getItemStacks() {
        return this.stacks;
    }

    public int getSize() {
        return this.stacks.size();
    }

    public int getRemainingSpace(ItemStack input) {
        Fraction size = Fraction.getFraction((int)16, (int)1);
        Fraction weight = Traits.getWeight(this.getItemStacks());
        Fraction weightLeft = size.subtract(weight);
        return Math.max(weightLeft.divideBy(Traits.getItemWeight(input)).intValue(), 0);
    }

    public void addItem(ItemStack input) {
        this.addItem(this.getSize(), input);
    }

    public void addItem(int slot, ItemStack input) {
        this.addItem(slot, input, input.getCount());
    }

    public void addItem(int slot, ItemStack input, int increment) {
        if (input.isEmpty()) {
            return;
        }
        int space = this.getRemainingSpace(input);
        int toAdd = Math.min(increment, space);
        if (toAdd == 0) {
            return;
        }
        int size = this.getSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stored = this.getItemStacks().get(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)input, (ItemStack)stored)) continue;
            stored.grow(toAdd);
            input.shrink(toAdd);
            this.getItemStacks().remove(i);
            int min = Math.min(size - 1, slot);
            this.getItemStacks().add(min, stored);
            this.setChanged();
            return;
        }
        int min = Math.min(size, slot);
        this.getItemStacks().add(min, input.copyWithCount(toAdd));
        input.shrink(toAdd);
        this.setChanged();
    }

    public ItemStack removeItem(int slot, int amount) {
        int size = this.getSize();
        if (slot >= size) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.getItemStacks().get(slot);
        amount = Math.min(stack.getMaxStackSize(), amount);
        int count = stack.getCount();
        if (count <= amount) {
            ItemStack removed = this.getItemStacks().remove(slot);
            this.setChanged();
            return removed;
        }
        ItemStack removed = stack.copyWithCount(amount);
        stack.shrink(amount);
        return removed;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.getSize() > slot ? this.getItemStacks().remove(slot) : ItemStack.EMPTY;
    }

    public void setItem(int slot, ItemStack stack) {
        int size = this.getSize();
        boolean isEmpty = stack.isEmpty();
        if (!isEmpty) {
            if (size > slot) {
                this.getItemStacks().set(slot, stack);
            } else {
                this.getItemStacks().add(size, stack);
            }
        } else if (size > slot) {
            this.getItemStacks().remove(slot);
        }
        this.setChanged();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public int getContainerSize() {
        int i = 1 - Traits.getWeight(this.stacks, 16).intValue();
        int value = this.getSize() + i;
        return value;
    }

    public boolean canPlaceItem(int pSlot, ItemStack pStack) {
        return Traits.getWeight(this.stacks, 16).intValue() != 1;
    }

    public boolean isEmpty() {
        return this.stacks.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.getSize() > slot ? this.getItemStacks().get(slot) : ItemStack.EMPTY;
    }

    public void dropAll() {
        Containers.dropContents((Level)this.level, (BlockPos)this.getBlockPos(), (Container)this);
    }

    public void clearContent() {
    }
}

