/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.items;

import com.beansgalaxy.backpacks.components.ender.EmptyEnderItem;
import com.beansgalaxy.backpacks.components.ender.EnderItem;
import com.beansgalaxy.backpacks.components.reference.ReferenceTrait;
import com.beansgalaxy.backpacks.items.ModBlocks;
import com.beansgalaxy.backpacks.platform.Services;
import com.beansgalaxy.backpacks.traits.Traits;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public enum ModItems {
    LEATHER_BACKPACK("backpack", "leather_backpack"),
    IRON_BACKPACK("iron_backpack", "iron_backpack"),
    GOLD_BACKPACK("gold_backpack", "gold_backpack"),
    NETHERITE_BACKPACK("netherite_backpack", "netherite_backpack", properties -> properties.fireResistant().stacksTo(1)),
    ENDER_POUCH("ender_pouch", EnderItem::new, false),
    EMPTY_ENDER_POUCH("empty_ender_pouch", () -> new EmptyEnderItem("vanilla_bundle")),
    BUNDLE("bundle", "vanilla_bundle"),
    LUNCH_BOX("lunch_box", "lunch_box"),
    QUIVER("quiver", "quiver"),
    ALCHEMIST_BAG("alchemy_bag", "alchemy_bag"),
    NETHERITE_LUNCH_BOX("netherite_lunch_box", "netherite_lunch_box");

    public static final UnaryOperator<CreativeModeTab.Builder> CREATIVE_TAB;
    public final String id;
    public final Supplier<Item> item;
    public final boolean creativeIncluded;

    private ModItems(String id, String reference) {
        this(id, reference, p -> p.stacksTo(1));
    }

    private ModItems(String id, String reference, UnaryOperator<Item.Properties> properties) {
        this.id = id;
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"beansbackpacks", (String)reference);
        ReferenceTrait referenceTrait = new ReferenceTrait(location);
        Item.Properties properties1 = new Item.Properties().component(Traits.REFERENCE, (Object)referenceTrait);
        this.item = Services.PLATFORM.register(id, () -> new Item((Item.Properties)properties.apply(properties1)));
        this.creativeIncluded = true;
    }

    private ModItems(String id, Supplier<Item> item, boolean creativeIncluded) {
        this.id = id;
        this.item = Services.PLATFORM.register(id, item);
        this.creativeIncluded = creativeIncluded;
    }

    private ModItems(String id, Supplier<Item> item) {
        this(id, item, true);
    }

    public static void register() {
    }

    public Item get() {
        return this.item.get();
    }

    public boolean is(ItemStack stack) {
        return stack.is(this.get());
    }

    static {
        CREATIVE_TAB = builder -> builder.title((Component)Component.translatable((String)"itemGroup.beansbackpacks")).icon(() -> LEATHER_BACKPACK.get().getDefaultInstance()).displayItems((params, output) -> {
            for (ModItems modItems : ModItems.values()) {
                if (!modItems.creativeIncluded) continue;
                output.accept((ItemLike)modItems.get());
            }
            for (Enum enum_ : ModBlocks.values()) {
                if (!((ModBlocks)enum_).creativeIncluded) continue;
                output.accept((ItemLike)((ModBlocks)enum_).item.get());
            }
            output.accept((ItemLike)Items.LEATHER_LEGGINGS);
            output.accept((ItemLike)Items.DECORATED_POT);
        });
    }
}

