/*
 * Decompiled with CFR 0.152.
 */
package com.beansgalaxy.backpacks.mixin.client;

import com.beansgalaxy.backpacks.CommonClass;
import com.beansgalaxy.backpacks.CommonClient;
import com.beansgalaxy.backpacks.access.BackData;
import com.beansgalaxy.backpacks.access.EquipmentSlotAccess;
import com.beansgalaxy.backpacks.access.TraitMenuAccessor;
import com.beansgalaxy.backpacks.data.config.ClientConfig;
import com.beansgalaxy.backpacks.screen.TraitMenu;
import com.beansgalaxy.backpacks.traits.Traits;
import com.beansgalaxy.backpacks.traits.abstract_traits.DraggingContainer;
import com.beansgalaxy.backpacks.traits.abstract_traits.IDraggingTrait;
import com.beansgalaxy.backpacks.traits.backpack.BackpackTraits;
import com.beansgalaxy.backpacks.traits.generic.BundleLikeTraits;
import com.beansgalaxy.backpacks.traits.generic.GenericTraits;
import com.beansgalaxy.backpacks.util.ComponentHolder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractContainerScreen.class})
public abstract class AbstractScreenMixin<T extends AbstractContainerMenu>
extends Screen
implements TraitMenuAccessor {
    @Shadow
    protected Slot hoveredSlot;
    @Shadow
    @Final
    protected T menu;
    @Shadow
    protected boolean isQuickCrafting;
    @Shadow
    private boolean skipNextRelease;
    @Shadow
    @Nullable
    private Slot lastClickSlot;
    @Shadow
    protected int leftPos;
    @Shadow
    protected int topPos;
    @Shadow
    private int lastClickButton;
    @Shadow
    protected int imageHeight;
    @Shadow
    protected int imageWidth;
    @Unique
    private List<TraitMenu<?>> traitMenus = new ArrayList();
    private final DraggingContainer drag = new DraggingContainer(){

        @Override
        public void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
            AbstractScreenMixin.this.slotClicked(slot, slotId, mouseButton, type);
        }
    };

    @Shadow
    @Nullable
    protected abstract Slot findSlot(double var1, double var3);

    @Shadow
    protected abstract void slotClicked(Slot var1, int var2, int var3, ClickType var4);

    @Shadow
    public abstract T getMenu();

    protected AbstractScreenMixin(Component pTitle) {
        super(pTitle);
    }

    @Override
    public void clickTraitMenu(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (!this.traitMenus.isEmpty()) {
            Iterator<TraitMenu<?>> iterator = this.traitMenus.iterator();
            while (iterator.hasNext() && !cir.isCancelled()) {
                TraitMenu<?> traitMenu = iterator.next();
                if (traitMenu.isHoveringSlot((int)pMouseX, (int)pMouseY)) {
                    boolean doubleClick;
                    long i = Util.getMillis();
                    boolean bl = doubleClick = i - traitMenu.timeOpened < 250L && this.lastClickButton == pButton;
                    if (doubleClick) {
                        cir.setReturnValue((Object)true);
                        return;
                    }
                    iterator.remove();
                    if (pButton != 1) continue;
                    this.skipNextRelease = true;
                    cir.setReturnValue((Object)true);
                    return;
                }
                traitMenu.mouseClicked(pMouseX, pMouseY, pButton, cir);
                if (!cir.isCancelled()) continue;
                iterator.remove();
                this.traitMenus.addFirst(traitMenu);
                this.skipNextRelease = true;
                return;
            }
        }
    }

    @Unique
    private boolean shouldMakeNewMenu(int mButton) {
        if (mButton == 1) {
            return true;
        }
        if (mButton == 0) {
            if (BackData.get((Player)this.minecraft.player).isMenuKeyDown()) {
                return true;
            }
            if (this.hoveredSlot instanceof EquipmentSlotAccess) {
                return this.minecraft.player.isCreative() || !this.hoveredSlot.mayPickup((Player)this.minecraft.player) || !this.hoveredSlot.mayPlace(this.menu.getCarried());
            }
        }
        return false;
    }

    @Inject(method={"mouseClicked"}, cancellable=true, at={@At(value="HEAD")})
    private void mouseClicked(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (this.hoveredSlot != null) {
            if (this.shouldMakeNewMenu(pButton)) {
                TraitMenu<?> menu = TraitMenu.create(this.minecraft, this.leftPos, this.topPos, this.imageHeight, this.imageWidth, this.hoveredSlot);
                if (menu != null) {
                    this.traitMenus.addFirst(menu);
                    ClientConfig config = CommonClass.CLIENT_CONFIG;
                    if (!((Boolean)config.hide_bundle_tutorial.get()).booleanValue()) {
                        config.hide_bundle_tutorial.set(true);
                        config.write();
                    }
                }
            } else if (this.menu.getCarried().isEmpty() && this.hoveredSlot.hasItem() && this.minecraft.options.keyPickItem.matchesMouse(pButton)) {
                BackpackTraits.runIfEquipped((Player)this.minecraft.player, (traits, slot) -> {
                    LocalPlayer player = this.minecraft.player;
                    SlotAccess access = SlotAccess.of(() -> this.menu.getCarried(), arg_0 -> this.menu.setCarried(arg_0));
                    return traits.pickItemClient((Player)player, (EquipmentSlot)slot, access, (AbstractContainerMenu)this.menu, this.hoveredSlot.getItem(), cir);
                });
            }
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    private void init(CallbackInfo ci) {
        this.traitMenus = new ArrayList();
    }

    public boolean shouldCloseOnEsc() {
        if (this.traitMenus.isEmpty()) {
            return super.shouldCloseOnEsc();
        }
        this.traitMenus = new ArrayList();
        return false;
    }

    @Inject(method={"keyPressed"}, cancellable=true, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;checkHotbarKeyPressed(II)Z")})
    private void keyPressed(int pKeyCode, int pScanCode, int pModifiers, CallbackInfoReturnable<Boolean> cir) {
        boolean dropButtonWasPressed = this.minecraft.options.keyDrop.matches(pKeyCode, pScanCode);
        if (dropButtonWasPressed) {
            Iterator<TraitMenu<?>> iterator = this.traitMenus.iterator();
            while (iterator.hasNext() && !cir.isCancelled()) {
                TraitMenu<?> menu = iterator.next();
                menu.dropHoveredItem(cir);
            }
        }
    }

    @Inject(method={"isHovering(IIIIDD)Z"}, cancellable=true, at={@At(value="HEAD")})
    private void isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY, CallbackInfoReturnable<Boolean> cir) {
        for (TraitMenu<?> traitMenu : this.traitMenus) {
            if (!traitMenu.isHovering((int)pMouseX, (int)pMouseY)) continue;
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/minecraft/client/gui/screens/inventory/AbstractContainerScreen;renderLabels(Lnet/minecraft/client/gui/GuiGraphics;II)V")})
    protected void renderTooltip(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        ItemStack stack;
        TraitMenu<?> focusedMenu = null;
        for (TraitMenu<?> traitMenu : this.traitMenus) {
            if (focusedMenu == null && traitMenu.isHovering(pMouseX, pMouseY)) {
                focusedMenu = traitMenu;
                focusedMenu.setFocus(true);
                continue;
            }
            traitMenu.setFocus(false);
        }
        if (focusedMenu != null) {
            this.traitMenus.remove(focusedMenu);
            this.traitMenus.addFirst(focusedMenu);
        }
        PoseStack pose = pGuiGraphics.pose();
        pGuiGraphics.enableScissor(0, 0, this.width, this.height);
        int i = this.traitMenus.size();
        while (i > 0) {
            TraitMenu<?> traitMenu = this.traitMenus.get(--i);
            traitMenu.render((AbstractContainerScreen)this, pGuiGraphics, pMouseX, pMouseY);
            pose.translate(0.0f, 0.0f, 300.0f);
        }
        pGuiGraphics.disableScissor();
        if (this.hoveredSlot != null && !(stack = this.hoveredSlot.getItem()).isEmpty() && !((Boolean)CommonClass.CLIENT_CONFIG.hide_bundle_tutorial.get()).booleanValue()) {
            Optional<BundleLikeTraits> optional = BundleLikeTraits.get(ComponentHolder.of(stack));
            optional.ifPresent(traits -> {
                if (traits instanceof BackpackTraits && !(this.hoveredSlot instanceof EquipmentSlotAccess)) {
                    return;
                }
                CommonClient.renderInfoTooltip(pGuiGraphics, pMouseX - this.leftPos, pMouseY - this.topPos, this.hoveredSlot, traits);
            });
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void movePose(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick, CallbackInfo ci) {
        pGuiGraphics.pose().translate(0.0f, 0.0f, (float)(this.traitMenus.size() * 300));
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        int scrolled;
        int containerId;
        ClientLevel level;
        ItemStack stack;
        if (this.hoveredSlot != null && CommonClient.scrollTraits((Player)this.minecraft.player, stack = this.hoveredSlot.getItem(), (Level)(level = this.minecraft.level), containerId = ((AbstractContainerMenu)this.menu).containerId, scrolled = Mth.floor((double)(pScrollY + 0.5)), this.hoveredSlot)) {
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    @Inject(method={"mouseDragged"}, at={@At(value="HEAD")}, cancellable=true)
    public void backpackDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY, CallbackInfoReturnable<Boolean> cir) {
        TraitMenu<?> traitMenu;
        if (!this.traitMenus.isEmpty() && (traitMenu = this.traitMenus.getFirst()).isFocused()) {
            traitMenu.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY, cir);
            if (cir.isCancelled()) {
                return;
            }
        }
        ItemStack backpack = this.menu.getCarried();
        Slot slot = this.findSlot(pMouseX, pMouseY);
        if (backpack.isEmpty()) {
            return;
        }
        if (slot != this.lastClickSlot && slot != this.drag.firstSlot) {
            IDraggingTrait.runIfPresent(backpack, (Level)this.minecraft.level, (trait, holder) -> this.beans_Backpacks_3$dragTrait((IDraggingTrait)trait, pButton, slot, cir, (ComponentHolder)holder));
        }
    }

    @Unique
    private void beans_Backpacks_3$dragTrait(IDraggingTrait traits, int pButton, Slot slot, CallbackInfoReturnable<Boolean> cir, ComponentHolder holder) {
        this.isQuickCrafting = false;
        this.skipNextRelease = true;
        if (this.drag.allSlots.isEmpty()) {
            boolean bl = this.drag.isPickup = pButton == 0;
            if (this.drag.firstSlot != null) {
                traits.clickSlot(this.drag, (Player)this.minecraft.player, holder);
            } else if (this.lastClickSlot != null) {
                this.drag.firstSlot = this.lastClickSlot;
                traits.clickSlot(this.drag, (Player)this.minecraft.player, holder);
            }
        } else if (this.drag.firstSlot != null) {
            traits.clickSlot(this.drag, (Player)this.minecraft.player, holder);
        }
        this.drag.firstSlot = slot;
        cir.setReturnValue((Object)true);
    }

    @Inject(method={"mouseReleased"}, at={@At(value="HEAD")})
    public void backpackReleased(double pMouseX, double pMouseY, int pButton, CallbackInfoReturnable<Boolean> cir) {
        if (!this.drag.allSlots.isEmpty()) {
            if (this.drag.firstSlot != null) {
                ItemStack backpack = this.menu.getCarried();
                IDraggingTrait.runIfPresent(backpack, (Level)this.minecraft.level, (trait, holder) -> trait.clickSlot(this.drag, (Player)this.minecraft.player, ComponentHolder.of(backpack)));
                this.drag.firstSlot = null;
            }
            this.drag.allSlots.clear();
        }
    }

    @Inject(method={"renderSlot"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V")})
    public void renderBackpackDraggedSlot(GuiGraphics pGuiGraphics, Slot pSlot, CallbackInfo ci) {
        ItemStack pair = this.drag.allSlots.get(pSlot);
        if (pair != null) {
            int i = pSlot.x;
            int j = pSlot.y;
            if (this.drag.isPickup) {
                pGuiGraphics.renderFakeItem(pair, i, j);
                if (pSlot.getItem().getCount() == 1) {
                    PoseStack pose = pGuiGraphics.pose();
                    pose.pushPose();
                    pose.translate(0.0f, 0.0f, 200.0f);
                    String pText = String.valueOf(1);
                    pGuiGraphics.drawString(this.font, pText, i + 19 - 2 - this.font.width(pText), j + 6 + 3, 0xFFFFFF, true);
                    pose.popPose();
                }
            }
            pGuiGraphics.fill(i, j, i + 16, j + 16, this.drag.isPickup ? 200 : 0, -2130706433);
        }
    }

    @Inject(method={"slotClicked"}, cancellable=true, at={@At(value="HEAD")})
    private void slotClicked(Slot pSlot, int pSlotId, int pMouseButton, ClickType pType, CallbackInfo ci) {
        if (pSlot == null || pType != ClickType.PICKUP_ALL) {
            return;
        }
        Optional<GenericTraits> traits = Traits.get(this.menu.getCarried());
        if (traits.isEmpty()) {
            return;
        }
        this.minecraft.gameMode.handleInventoryMouseClick(((AbstractContainerMenu)this.menu).containerId, pSlot.index, pMouseButton, ClickType.PICKUP, (Player)this.minecraft.player);
        TraitMenu<?> menu = TraitMenu.create(this.minecraft, this.leftPos, this.topPos, this.imageHeight, this.imageWidth, this.hoveredSlot);
        if (menu != null) {
            this.traitMenus.addFirst(menu);
        }
        ci.cancel();
    }
}

